/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils.world;

import java.util.Map;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.utils.world.TCMazeHandler;
import makeo.gadomancy.common.utils.world.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.CellLoc;

public class TCMazeSession {
    public final EntityPlayerMP player;
    public final Map<CellLoc, Short> chunksAffected;
    public final CellLoc portalCell;
    public final int originDimId;
    public final Vec3 originLocation;

    TCMazeSession(EntityPlayer owner, Map<CellLoc, Short> locations, int dim, Vec3 origin) {
        this.player = (EntityPlayerMP)owner;
        this.chunksAffected = locations;
        this.originDimId = dim;
        this.originLocation = origin;
        this.portalCell = this.findPortal();
    }

    TCMazeSession() {
        this.player = null;
        this.chunksAffected = null;
        this.portalCell = null;
        this.originDimId = 0;
        this.originLocation = null;
    }

    private CellLoc findPortal() {
        for (CellLoc loc : this.chunksAffected.keySet()) {
            Short s = this.chunksAffected.get(loc);
            Cell c = new Cell(s.shortValue());
            if (c.feature != 1) continue;
            return loc;
        }
        return null;
    }

    final void closeSession(boolean teleport) {
        TCMazeHandler.free(this.chunksAffected);
        if (teleport) {
            WorldUtil.tryTeleportBack(this.player, this.originDimId);
            this.player.func_70634_a(this.originLocation.field_72450_a, this.originLocation.field_72448_b, this.originLocation.field_72449_c);
        }
    }

    final void startSession() {
        WorldServer ws = MinecraftServer.func_71276_C().func_71218_a(ModConfig.dimOuterId);
        for (CellLoc loc : this.chunksAffected.keySet()) {
            long k = ChunkCoordIntPair.func_77272_a((int)loc.x, (int)loc.z);
            if (!ws.field_73059_b.field_73244_f.func_76161_b(k)) continue;
            Chunk c = (Chunk)ws.field_73059_b.field_73244_f.func_76164_a(k);
            ws.field_73059_b.field_73245_g.remove(c);
            ws.field_73059_b.field_73244_f.func_76159_d(k);
        }
        if (this.portalCell == null) {
            LogManager.getLogger().error("Thaumcraft didn't generate a portal! Stopping instance! PLEASE REPORT THIS ERROR!", (Throwable)new IllegalStateException());
            this.closeSession(false);
            this.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Thaumcraft didn't generate a portal in the Eldritch dimension. Sorry, we can't teleport you.."));
        } else {
            WorldUtil.teleportToFakeOuter(this.player);
            int x = this.portalCell.x * 16 + 8;
            int z = this.portalCell.z * 16 + 8;
            this.player.func_70634_a((double)x + 0.5, 55.0, (double)z + 0.5);
            Thaumcraft.proxy.getResearchManager().completeResearch((EntityPlayer)this.player, "ENTEROUTER");
        }
    }

    public static TCMazeSession placeholder() {
        return new TCMazeSession();
    }
}

