/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.node.NodeManipulatorResult;
import makeo.gadomancy.common.registration.RegisteredManipulations;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;

public class NodeManipulatorResultHandler {
    private static List<NodeManipulatorResult> possibleResults = new ArrayList<NodeManipulatorResult>();

    private NodeManipulatorResultHandler() {
    }

    public static NodeManipulatorResult getRandomResult(World world, INode affectedNode, int percChance) {
        return NodeManipulatorResultHandler.getRandomResult(world, world.field_73012_v, affectedNode, percChance);
    }

    public static NodeManipulatorResult getRandomResult(World world, Random random, INode affectedNode, int percChance) {
        int resultPositiveChance = Math.round((float)percChance / 5.0f);
        ArrayList<NodeManipulatorResult> localResults = new ArrayList<NodeManipulatorResult>();
        for (NodeManipulatorResult result : possibleResults) {
            ResultType type;
            if (!result.canAffect(world, affectedNode) || (type = result.getResultType()) == ResultType.NEGATIVE && random.nextInt(100) < resultPositiveChance) continue;
            localResults.add(result);
        }
        if (localResults.isEmpty()) {
            return null;
        }
        return (NodeManipulatorResult)WeightedRandom.func_76271_a((Random)random, localResults);
    }

    public static void combine(AspectList containingList, Aspect a, Aspect b, int addition) {
        if (!NodeManipulatorResultHandler.canCombine(a, b)) {
            return;
        }
        Aspect combination = NodeManipulatorResultHandler.getCombination(a, b);
        int lowerAmount = containingList.getAmount(a) < containingList.getAmount(b) ? containingList.getAmount(a) : containingList.getAmount(b);
        containingList.remove(a, lowerAmount);
        containingList.remove(b, lowerAmount);
        containingList.add(combination, lowerAmount + addition);
    }

    public static boolean canCombine(Aspect a, Aspect b) {
        return NodeManipulatorResultHandler.getCombination(a, b) != null;
    }

    public static Aspect getCombination(Aspect a, Aspect b) {
        for (Aspect aspect : Aspect.getCompoundAspects()) {
            Aspect[] components = aspect.getComponents();
            if ((components[0] != a || components[1] != b) && (components[0] != b || components[1] != a)) continue;
            return aspect;
        }
        return null;
    }

    static {
        possibleResults.add(RegisteredManipulations.resultBreakCompounds);
        possibleResults.add(RegisteredManipulations.resultCombineAspects);
        possibleResults.add(RegisteredManipulations.resultIncreaseModifier);
        possibleResults.add(RegisteredManipulations.resultDecreaseModifier);
        possibleResults.add(RegisteredManipulations.resultSwitchType);
        if (ModConfig.enableAdditionalNodeTypes) {
            possibleResults.add(RegisteredManipulations.resultApplyGrowing);
        }
        possibleResults.add(RegisteredManipulations.resultGainPrimal);
    }

    public static enum ResultType {
        POSITIVE,
        NEGATIVE,
        NEUTRAL;

    }
}

