/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.aura;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.api.AuraEffect;
import makeo.gadomancy.common.aura.AuraResearchManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public class AuraEffectHandler {
    public static Map<Aspect, AuraEffect> registeredEffects = new HashMap<Aspect, AuraEffect>();

    public static void distributeEffects(Aspect aspect, World worldObj, double x, double y, double z, int tick) {
        if (!registeredEffects.containsKey(aspect) || worldObj.field_72995_K || AuraResearchManager.isBlacklisted(aspect)) {
            return;
        }
        AuraEffect effect = registeredEffects.get(aspect);
        if (tick % effect.getTickInterval() != 0) {
            return;
        }
        AuraEffect.EffectType type = effect.getEffectType();
        if (type != null) {
            switch (type) {
                case ENTITY_EFFECT: {
                    AuraEffectHandler.doEntityEffects(effect, worldObj, x, y, z);
                    break;
                }
                case BLOCK_EFFECT: {
                    AuraEffectHandler.doBlockEffects(effect, worldObj, x, y, z);
                }
            }
        } else {
            AuraEffectHandler.doEntityEffects(effect, worldObj, x, y, z);
            AuraEffectHandler.doBlockEffects(effect, worldObj, x, y, z);
        }
        double range = effect.getRange();
        List players = worldObj.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(x - 0.5), (double)(y - 0.5), (double)(z - 0.5), (double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5)).func_72314_b(range, range, range));
        for (Object p : players) {
            if (p == null || !(p instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)p;
            AuraResearchManager.tryUnlockAuraEffect(player, aspect);
        }
    }

    private static void doBlockEffects(AuraEffect effect, World worldObj, double x, double y, double z) {
        int count = effect.getBlockCount(worldObj.field_73012_v);
        ChunkCoordinates origin = new ChunkCoordinates((int)x, (int)y, (int)z);
        ArrayList<ChunkCoordinates> foundBlocks = new ArrayList<ChunkCoordinates>();
        int intRange = (int)effect.getRange();
        for (int i = 0; i < count; ++i) {
            int zz;
            int yy;
            int xx = worldObj.field_73012_v.nextInt(intRange) - worldObj.field_73012_v.nextInt(intRange);
            ChunkCoordinates blockCC = new ChunkCoordinates((int)x + xx, (int)y + (yy = worldObj.field_73012_v.nextInt(intRange) - worldObj.field_73012_v.nextInt(intRange)), (int)z + (zz = worldObj.field_73012_v.nextInt(intRange) - worldObj.field_73012_v.nextInt(intRange)));
            if (foundBlocks.contains(blockCC)) {
                ++count;
                continue;
            }
            foundBlocks.add(blockCC);
            effect.doBlockEffect(origin, blockCC, worldObj);
        }
    }

    private static void doEntityEffects(AuraEffect effect, World worldObj, double x, double y, double z) {
        double range = effect.getRange();
        List entitiesInRange = worldObj.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(x - 0.5), (double)(y - 0.5), (double)(z - 0.5), (double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5)).func_72314_b(range, range, range));
        Iterator it = entitiesInRange.iterator();
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            if (e == null || e.field_70128_L) {
                it.remove();
                continue;
            }
            if (effect.isEntityApplicable(e)) continue;
            it.remove();
        }
        ChunkCoordinates origin = new ChunkCoordinates((int)x, (int)y, (int)z);
        for (Object e : entitiesInRange) {
            effect.doEntityEffect(origin, (Entity)e);
        }
    }
}

