/*
 * Decompiled with CFR 0.152.
 */
package jss.bugtorch.mixins.early.minecraft.logcleanup;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Shadow(remap=false)
    protected HashMap<String, IExtendedEntityProperties> extendedProperties;

    @Overwrite(remap=false)
    public String registerExtendedProperties(String identifier, IExtendedEntityProperties properties) {
        if (identifier == null) {
            FMLLog.warning((String)"Someone is attempting to register extended properties using a null identifier.  This is not allowed.  Aborting.  This may have caused instability.", (Object[])new Object[0]);
            return "";
        }
        if (properties == null) {
            FMLLog.warning((String)"Someone is attempting to register null extended properties.  This is not allowed.  Aborting.  This may have caused instability.", (Object[])new Object[0]);
            return "";
        }
        String baseIdentifier = identifier;
        int identifierModCount = 1;
        while (this.extendedProperties.containsKey(identifier)) {
            identifier = String.format("%s%d", baseIdentifier, identifierModCount++);
        }
        this.extendedProperties.put(identifier, properties);
        return identifier;
    }
}

