/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.api.utils;

import blockrenderer6343.api.utils.Size;
import java.util.Objects;

public class Position {
    public static final Position ORIGIN = new Position(0, 0);
    public final int x;
    public final int y;

    public Position(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Position add(Position other) {
        return new Position(this.x + other.x, this.y + other.y);
    }

    public Position subtract(Position other) {
        return new Position(this.x - other.x, this.y - other.y);
    }

    public Position add(Size size) {
        return new Position(this.x + size.width, this.y + size.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position position = (Position)o;
        return this.x == position.x && this.y == position.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).toString();
    }
}

