/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.util.UniqueFluidStackSet;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.recipes.RecipeManagers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class AnalystPageProduce
extends ControlAnalystPage {
    public AnalystPageProduce(IWidget parent, IArea area) {
        super(parent, area);
    }

    protected Collection<? extends ItemStack> getAllProducts(ItemStack key) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        products.addAll(this.getCentrifuge(key));
        products.addAll(this.getSqueezer(key));
        products.add(FurnaceRecipes.func_77602_a().func_151395_a(key));
        products.addAll(this.getCrafting(key));
        return products;
    }

    public Collection<ItemStack> getCentrifuge(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Map.Entry recipe : RecipeManagers.centrifugeManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof ItemStack)) continue;
                products.add((ItemStack)obj);
            }
        }
        return products;
    }

    public Collection<ItemStack> getSqueezer(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Map.Entry recipe : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof ItemStack)) continue;
                products.add((ItemStack)obj);
            }
        }
        return products;
    }

    public Collection<ItemStack> getCrafting(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Object recipeO : CraftingManager.func_77594_a().func_77592_b()) {
            boolean match;
            if (recipeO instanceof ShapelessRecipes) {
                ShapelessRecipes recipe = (ShapelessRecipes)recipeO;
                match = true;
                for (Object rec : recipe.field_77579_b) {
                    if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe.func_77571_b());
                }
            }
            if (recipeO instanceof ShapedRecipes) {
                ShapedRecipes recipe2 = (ShapedRecipes)recipeO;
                match = true;
                for (ItemStack rec2 : recipe2.field_77574_d) {
                    if (rec2 == null || rec2 instanceof ItemStack && stack.func_77969_a(rec2)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe2.func_77571_b());
                }
            }
            if (!(recipeO instanceof ShapelessOreRecipe)) continue;
            ShapelessOreRecipe recipe3 = (ShapelessOreRecipe)recipeO;
            match = true;
            for (Object rec : recipe3.getInput()) {
                if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                match = false;
            }
            if (!match) continue;
            products.add(recipe3.func_77571_b());
        }
        return products;
    }

    public Collection<FluidStack> getAllFluids(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        products.addAll(this.getSqueezerFluid(stack));
        return products;
    }

    public Collection<FluidStack> getSqueezerFluid(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        for (Map.Entry recipe : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof FluidStack)) continue;
                products.add((FluidStack)obj);
            }
        }
        return products;
    }

    protected Collection<? extends FluidStack> getAllProducts(FluidStack stack) {
        return new UniqueFluidStackSet();
    }

    protected Collection<ItemStack> getAllProductsAndFluids(Collection<ItemStack> collection) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack itemStack : collection) {
            products.addAll(this.getAllProducts(itemStack));
        }
        UniqueItemStackSet products2 = new UniqueItemStackSet();
        for (Object stack2 : products) {
            products2.addAll(this.getAllProducts((ItemStack)stack2));
        }
        UniqueItemStackSet uniqueItemStackSet = new UniqueItemStackSet();
        for (Object stack3 : products2) {
            uniqueItemStackSet.addAll(this.getAllProducts((ItemStack)stack3));
        }
        products.addAll(products2);
        products.addAll(uniqueItemStackSet);
        UniqueFluidStackSet allFluids = new UniqueFluidStackSet();
        for (ItemStack itemStack : collection) {
            allFluids.addAll(this.getAllFluids(itemStack));
        }
        UniqueFluidStackSet fluids2 = new UniqueFluidStackSet();
        for (FluidStack stack5 : allFluids) {
            fluids2.addAll(this.getAllProducts(stack5));
        }
        UniqueFluidStackSet uniqueFluidStackSet = new UniqueFluidStackSet();
        for (FluidStack stack6 : fluids2) {
            uniqueFluidStackSet.addAll(this.getAllProducts(stack6));
        }
        allFluids.addAll(fluids2);
        allFluids.addAll(uniqueFluidStackSet);
        for (FluidStack fluid : allFluids) {
            ItemStack container = null;
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151069_bo)) && data.fluid.isFluidEqual(fluid)) {
                    container = data.filledContainer;
                    break;
                }
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151133_ar)) && data.fluid.isFluidEqual(fluid)) {
                    container = data.filledContainer;
                    break;
                }
                if (!data.fluid.isFluidEqual(fluid)) continue;
                container = data.filledContainer;
                break;
            }
            if (container == null) continue;
            products.add(container);
        }
        return products;
    }

    protected int getRefined(String string, int y, Collection<ItemStack> products) {
        new ControlTextCentered((IWidget)this, y, string).setColor(this.getColor());
        y += 10;
        int maxBiomePerLine = (int)((this.w() + 2.0f - 16.0f) / 18.0f);
        float biomeListX = (this.w() - (float)(Math.min(maxBiomePerLine, products.size()) * 18 - 2)) / 2.0f;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : products) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)soilStack);
            soilStack.field_77994_a = 1;
            ControlItemDisplay display = new ControlItemDisplay((IWidget)this, biomeListX + (float)dx, (float)(y + dy), soilStack, fluid == null);
            if (fluid != null) {
                display.addTooltip(fluid.getLocalizedName());
            }
            dx += 18;
        }
        if (dx != 0) {
            dy += 18;
        }
        return y + dy;
    }
}

