/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.WoodManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Lumbermill {
    public static final int SLOT_WOOD = 0;
    public static final int SLOT_PLANKS = 1;
    public static final int SLOT_BARK = 2;
    public static final int SLOT_SAWDUST = 3;
    public static final int TANK_WATER = 0;
    public static final int RF_COST = 900;
    public static final int TIME_PERIOD = 30;
    public static final int WATER_PER_TICK = 10;
    public static Map<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();

    public static ItemStack getPlankProduct(ItemStack item) {
        if (recipes.isEmpty()) {
            Lumbermill.calculateLumbermillProducts();
        }
        for (Map.Entry<ItemStack, ItemStack> entry : recipes.entrySet()) {
            if (!entry.getKey().func_77969_a(item)) continue;
            ItemStack stack = entry.getValue().func_77946_l();
            stack.field_77994_a = 6;
            return stack;
        }
        return null;
    }

    public static void calculateLumbermillProducts() {
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            for (ItemStack wood : Lumbermill.getRecipeResult(type.getStack())) {
                recipes.put(wood, type.getStack());
            }
        }
    }

    private static Collection<ItemStack> getRecipeResult(ItemStack output) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object recipeO : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessOreRecipe recipe3;
            ItemStack input;
            if (recipeO instanceof ShapelessRecipes) {
                ShapelessRecipes recipe = (ShapelessRecipes)recipeO;
                if (recipe.field_77579_b.size() != 1 || !(recipe.field_77579_b.get(0) instanceof ItemStack)) continue;
                input = (ItemStack)recipe.field_77579_b.get(0);
                if (recipe.func_77571_b() != null && recipe.func_77571_b().func_77969_a(output)) {
                    list.add(input);
                }
            }
            if (recipeO instanceof ShapedRecipes) {
                ShapedRecipes recipe2 = (ShapedRecipes)recipeO;
                if (recipe2.field_77574_d.length != 1) continue;
                input = recipe2.field_77574_d[0];
                if (recipe2.func_77571_b() != null && recipe2.func_77571_b().func_77969_a(output)) {
                    list.add(input);
                }
            }
            if (!(recipeO instanceof ShapelessOreRecipe) || (recipe3 = (ShapelessOreRecipe)recipeO).getInput().size() != 1 || !(recipe3.getInput().get(0) instanceof ItemStack)) continue;
            input = (ItemStack)recipe3.getInput().get(0);
            if (recipe3.func_77571_b() == null || !recipe3.func_77571_b().func_77969_a(output)) continue;
            list.add(input);
        }
        return list;
    }
}

