/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.Mods;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.ILogType;
import binnie.extratrees.genetics.ExtraTreeFruitFamily;
import binnie.extratrees.genetics.ExtraTreeFruitGene;
import binnie.extratrees.genetics.LeafType;
import binnie.extratrees.genetics.SaplingType;
import binnie.extratrees.worldgen.DefaultTreeGenerator;
import binnie.extratrees.worldgen.WorldGenAcornOak;
import binnie.extratrees.worldgen.WorldGenAspen;
import binnie.extratrees.worldgen.WorldGenBalsamFir;
import binnie.extratrees.worldgen.WorldGenBanana;
import binnie.extratrees.worldgen.WorldGenBox;
import binnie.extratrees.worldgen.WorldGenBrazilNut;
import binnie.extratrees.worldgen.WorldGenBrazilwood;
import binnie.extratrees.worldgen.WorldGenButternut;
import binnie.extratrees.worldgen.WorldGenCedar;
import binnie.extratrees.worldgen.WorldGenClove;
import binnie.extratrees.worldgen.WorldGenCoconut;
import binnie.extratrees.worldgen.WorldGenCoffee;
import binnie.extratrees.worldgen.WorldGenCommonAlder;
import binnie.extratrees.worldgen.WorldGenCommonAsh;
import binnie.extratrees.worldgen.WorldGenCommonBeech;
import binnie.extratrees.worldgen.WorldGenCopperBeech;
import binnie.extratrees.worldgen.WorldGenCypress;
import binnie.extratrees.worldgen.WorldGenDefault;
import binnie.extratrees.worldgen.WorldGenDouglasFir;
import binnie.extratrees.worldgen.WorldGenElder;
import binnie.extratrees.worldgen.WorldGenElm;
import binnie.extratrees.worldgen.WorldGenFloweringCrabapple;
import binnie.extratrees.worldgen.WorldGenGingko;
import binnie.extratrees.worldgen.WorldGenHawthorn;
import binnie.extratrees.worldgen.WorldGenHazel;
import binnie.extratrees.worldgen.WorldGenHolly;
import binnie.extratrees.worldgen.WorldGenHornbeam;
import binnie.extratrees.worldgen.WorldGenIroko;
import binnie.extratrees.worldgen.WorldGenLazy;
import binnie.extratrees.worldgen.WorldGenLoblollyPine;
import binnie.extratrees.worldgen.WorldGenLocust;
import binnie.extratrees.worldgen.WorldGenLogwood;
import binnie.extratrees.worldgen.WorldGenMango;
import binnie.extratrees.worldgen.WorldGenMonkeyPuzzle;
import binnie.extratrees.worldgen.WorldGenOldFustic;
import binnie.extratrees.worldgen.WorldGenOlive;
import binnie.extratrees.worldgen.WorldGenOrchardApple;
import binnie.extratrees.worldgen.WorldGenOsangeOsange;
import binnie.extratrees.worldgen.WorldGenPear;
import binnie.extratrees.worldgen.WorldGenPecan;
import binnie.extratrees.worldgen.WorldGenPrairieCrabapple;
import binnie.extratrees.worldgen.WorldGenPurpleheart;
import binnie.extratrees.worldgen.WorldGenRainbowGum;
import binnie.extratrees.worldgen.WorldGenRedMaple;
import binnie.extratrees.worldgen.WorldGenRoseGum;
import binnie.extratrees.worldgen.WorldGenRosewood;
import binnie.extratrees.worldgen.WorldGenRowan;
import binnie.extratrees.worldgen.WorldGenSallow;
import binnie.extratrees.worldgen.WorldGenShrub;
import binnie.extratrees.worldgen.WorldGenSilverFir;
import binnie.extratrees.worldgen.WorldGenSwampGum;
import binnie.extratrees.worldgen.WorldGenSweetCrabapple;
import binnie.extratrees.worldgen.WorldGenSweetgum;
import binnie.extratrees.worldgen.WorldGenSycamore;
import binnie.extratrees.worldgen.WorldGenTree;
import binnie.extratrees.worldgen.WorldGenWesternHemlock;
import binnie.extratrees.worldgen.WorldGenWhitebeam;
import binnie.extratrees.worldgen.WorldGenYew;
import binnie.genetics.genetics.AlleleHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumLeafType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IGermlingIconProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.render.TextureLeaves;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginArboriculture;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;

public enum ExtraTreeSpecies implements IAlleleTreeSpecies,
IIconProvider,
IGermlingIconProvider
{
    OrchardApple("malus", "domestica", 6588464, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Apple, WorldGenOrchardApple.class),
    SweetCrabapple("malus", "coronaria", 8034643, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenSweetCrabapple.class),
    FloweringCrabapple("malus", "hopa", 8034643, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenFloweringCrabapple.class),
    PrairieCrabapple("malus", "ioensis", 8034643, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenPrairieCrabapple.class),
    Blackthorn("prunus", "spinosa ", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Blackthorn),
    CherryPlum("prunus", "cerasifera", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.CherryPlum),
    Peach("prunus", "persica", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Peach),
    Nectarine("prunus", "nectarina", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Nectarine),
    Apricot("prunus", "armeniaca", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Apricot),
    Almond("prunus", "amygdalus", 7180062, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Almond),
    WildCherry("prunus", "avium", 7180062, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.WildCherry),
    SourCherry("prunus", "cerasus", 7180062, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.SourCherry),
    BlackCherry("prunus", "serotina", 7180062, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.BlackCherry),
    Orange("citrus", "sinensis", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Orange),
    Manderin("citrus", "reticulata", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Manderin),
    Satsuma("citrus", "unshiu", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Satsuma),
    Tangerine("citrus", "tangerina", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Tangerine),
    Lime("citrus", "latifolia", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Lime),
    KeyLime("citrus", "aurantifolia", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.KeyLime),
    FingerLime("citrus", "australasica", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.FingerLime),
    Pomelo("citrus", "maxima", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Pomelo),
    Grapefruit("citrus", "paradisi", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Grapefruit),
    Kumquat("citrus", "margarita", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Kumquat),
    Citron("citrus", "medica", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Citron),
    BuddhaHand("citrus", "sarcodactylus", 8957780, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.BuddhaHand),
    Banana("musa", "sinensis", 10603918, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.Banana, WorldGenBanana.class),
    RedBanana("musa", "rubra", 10603918, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.RedBanana, WorldGenBanana.class),
    Plantain("musa", "paradisiaca", 10603918, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.Plantain, WorldGenBanana.class),
    Butternut("juglans", "cinerea", 8566156, ILogType.ExtraTreeLog.Butternut, ExtraTreeFruitGene.Butternut, WorldGenButternut.class),
    Rowan("sorbus", "aucuparia", 10405787, ILogType.ExtraTreeLog.Rowan, null, WorldGenRowan.class),
    Hemlock("tsuga", "heterophylla", 6073458, ILogType.ExtraTreeLog.Hemlock, null, WorldGenWesternHemlock.class),
    Ash("fraxinus", "excelsior", 4754987, ILogType.ExtraTreeLog.Ash, null, WorldGenCommonAsh.class),
    Alder("alnus", "glutinosa", 6916659, ILogType.ExtraTreeLog.Alder, null, WorldGenCommonAlder.class),
    Beech("fagus", "sylvatica", 8626252, ILogType.ExtraTreeLog.Beech, ExtraTreeFruitGene.Beechnut, WorldGenCommonBeech.class),
    CopperBeech("fagus", "purpurea", 8393496, ILogType.ExtraTreeLog.Beech, ExtraTreeFruitGene.Beechnut, WorldGenCopperBeech.class),
    Aspen("populus", "tremula", 9096247, ILogType.ForestryLog.POPLAR, null, WorldGenAspen.class),
    Yew("taxus", "baccata", 9734733, ILogType.ExtraTreeLog.Yew, null, WorldGenYew.class),
    Cypress("chamaecyparis", "lawsoniana", 9030055, ILogType.ExtraTreeLog.Cypress, null, WorldGenCypress.class),
    DouglasFir("pseudotsuga", "menziesii", 10073474, ILogType.ExtraTreeLog.Fir, null, WorldGenDouglasFir.class),
    Hazel("Corylus", "avellana", 10204498, ILogType.ExtraTreeLog.Hazel, ExtraTreeFruitGene.Hazelnut, WorldGenHazel.class),
    Sycamore("ficus", "sycomorus", 10528047, ILogType.ExtraTreeLog.Fig, ExtraTreeFruitGene.Fig, WorldGenSycamore.class),
    Whitebeam("sorbus", "aria", 12242585, ILogType.ExtraTreeLog.Whitebeam, null, WorldGenWhitebeam.class),
    Hawthorn("crataegus", "monogyna", 7055434, ILogType.ExtraTreeLog.Hawthorn, null, WorldGenHawthorn.class),
    Pecan("carya", "illinoinensis", 8762996, ILogType.ExtraTreeLog.Hickory, ExtraTreeFruitGene.Pecan, WorldGenPecan.class),
    Elm("ulmus", "procera", 8163400, ILogType.ExtraTreeLog.Elm, null, WorldGenElm.class),
    Elder("sambucus", "nigra", 11450483, ILogType.ExtraTreeLog.Elder, ExtraTreeFruitGene.Elderberry, WorldGenElder.class),
    Holly("ilex", "aquifolium", 2444108, ILogType.ExtraTreeLog.Holly, null, WorldGenHolly.class),
    Hornbeam("carpinus", "betulus", 9873179, ILogType.ExtraTreeLog.Hornbeam, null, WorldGenHornbeam.class),
    Sallow("salix", "caprea", 11449123, ILogType.ForestryLog.WILLOW, null, WorldGenSallow.class),
    AcornOak("quercus", "robur", 6714174, ILogType.VanillaLog.Oak, ExtraTreeFruitGene.Acorn, WorldGenAcornOak.class),
    Fir("abies", "alba", 7306272, ILogType.ExtraTreeLog.Fir, null, WorldGenSilverFir.class),
    Cedar("cedrus", "libani", 9806704, ILogType.ExtraTreeLog.Cedar, null, WorldGenCedar.class),
    Olive("olea", "europaea", 3950644, ILogType.ExtraTreeLog.Olive, ExtraTreeFruitGene.Olive, WorldGenOlive.class),
    RedMaple("acer", "ubrum", 15216151, ILogType.ForestryLog.MAPLE, null, WorldGenRedMaple.class),
    BalsamFir("abies", "balsamea", 7643260, ILogType.ExtraTreeLog.Fir, null, WorldGenBalsamFir.class),
    LoblollyPine("pinus", "taeda", 7309895, ILogType.ForestryLog.PINE, null, WorldGenLoblollyPine.class),
    Sweetgum("liquidambar", "styraciflua", 9144162, ILogType.ExtraTreeLog.Sweetgum, null, WorldGenSweetgum.class),
    Locust("robinia", "pseudoacacia", 8942336, ILogType.ExtraTreeLog.Locust, null, WorldGenLocust.class),
    Pear("pyrus", "communis", 6195238, ILogType.ExtraTreeLog.Pear, ExtraTreeFruitGene.Pear, WorldGenPear.class),
    OsangeOsange("maclura", "pomifera", 6847056, ILogType.ExtraTreeLog.Maclura, ExtraTreeFruitGene.OsangeOsange, WorldGenOsangeOsange.class),
    OldFustic("maclura", "tinctoria", 6847056, ILogType.ExtraTreeLog.Maclura, null, WorldGenOldFustic.class),
    Brazilwood("caesalpinia", "echinata", 6321241, ILogType.ExtraTreeLog.Brazilwood, null, WorldGenBrazilwood.class),
    Logwood("haematoxylum", "campechianum", 8953707, ILogType.ExtraTreeLog.Logwood, null, WorldGenLogwood.class),
    Rosewood("dalbergia", "latifolia", 8887074, ILogType.ExtraTreeLog.Rosewood, null, WorldGenRosewood.class),
    Purpleheart("peltogyne", "spp.", 7835477, ILogType.ExtraTreeLog.Purpleheart, null, WorldGenPurpleheart.class),
    Iroko("milicia", "excelsa", 11520108, ILogType.ExtraTreeLog.Iroko, null, WorldGenIroko.class),
    Gingko("ginkgo", "biloba", 7444049, ILogType.ExtraTreeLog.Gingko, ExtraTreeFruitGene.GingkoNut, WorldGenGingko.class),
    Brazilnut("bertholletia", "excelsa", 8163195, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.BrazilNut, WorldGenBrazilNut.class),
    RoseGum("eucalyptus", "grandis", 10265176, ILogType.ExtraTreeLog.Eucalyptus, null, WorldGenRoseGum.class),
    SwampGum("eucalyptus", "grandis", 10667654, ILogType.ExtraTreeLog.Eucalyptus2, null, WorldGenSwampGum.class),
    Box("boxus", "sempervirens", 7510381, ILogType.ExtraTreeLog.Box, null, WorldGenBox.class),
    Clove("syzygium", "aromaticum", 8028703, ILogType.ExtraTreeLog.Syzgium, ExtraTreeFruitGene.Clove, WorldGenClove.class),
    Coffee("coffea", "arabica", 7311461, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Coffee, WorldGenCoffee.class),
    MonkeyPuzzle("araucaria", "araucana", 5726552, ILogType.ForestryLog.PINE, null, WorldGenMonkeyPuzzle.class),
    RainbowGum("eucalyptus", "deglupta", 12054565, ILogType.ExtraTreeLog.Eucalyptus3, null, WorldGenRainbowGum.class),
    PinkIvory("berchemia", "zeyheri", 8163673, ILogType.ExtraTreeLog.PinkIvory, null, WorldGenTree.class),
    Blackcurrant("ribes", "nigrum", 10934876, null, ExtraTreeFruitGene.Blackcurrant, WorldGenShrub.class),
    Redcurrant("ribes", "rubrum", 7646208, null, ExtraTreeFruitGene.Redcurrant, WorldGenShrub.class),
    Blackberry("rubus", "fruticosus", 9617755, null, ExtraTreeFruitGene.Blackberry, WorldGenShrub.class),
    Raspberry("rubus", "idaeus", 8632686, null, ExtraTreeFruitGene.Raspberry, WorldGenShrub.class),
    Blueberry("vaccinium", "corymbosum", 7522128, null, ExtraTreeFruitGene.Blueberry, WorldGenShrub.class),
    Cranberry("vaccinium", "oxycoccos", 9884025, null, ExtraTreeFruitGene.Cranberry, WorldGenShrub.class),
    Juniper("juniperus", "communis", 9482569, null, ExtraTreeFruitGene.Juniper, WorldGenShrub.class),
    Gooseberry("ribes", "grossularia", 7977728, null, ExtraTreeFruitGene.Gooseberry, WorldGenShrub.class),
    GoldenRaspberry("rubus", "occidentalis", 8632686, null, ExtraTreeFruitGene.GoldenRaspberry, WorldGenShrub.class),
    Cinnamon("cinnamomum", "cassia", 7573003, ILogType.ExtraTreeLog.Cinnamon, null, WorldGenLazy.class),
    Coconut("cocous", "nucifera", 6592803, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Coconut, WorldGenCoconut.class),
    Cashew("anacardium", "occidentale", 11254114, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Cashew, WorldGenLazy.class),
    Avacado("persea", "americana", 9872245, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Avacado, WorldGenLazy.class),
    Nutmeg("myristica", "fragrans", 4754764, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Nutmeg, WorldGenLazy.class),
    Allspice("pimenta", "dioica", 8165156, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Allspice, WorldGenLazy.class),
    Chilli("capsicum", "annuum", 2793217, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Chilli, WorldGenLazy.class),
    StarAnise("illicium", "verum", 8373257, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.StarAnise, WorldGenLazy.class),
    Mango("mangifera", "indica", 8893812, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Mango, WorldGenMango.class),
    Starfruit("averrhoa", "carambola", 7186733, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Starfruit, WorldGenLazy.class),
    Candlenut("aleurites", "moluccana", 9085804, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Candlenut, WorldGenLazy.class),
    DwarfHazel("Corylus", "americana", 10204498, ILogType.ExtraTreeLog.Hazel, ExtraTreeFruitGene.Hazelnut, WorldGenShrub.class);

    public ILogType wood;
    protected ArrayList<IFruitFamily> families;
    protected int girth;
    protected Class<? extends WorldGenerator> gen;
    protected IAlleleFruit fruit;
    protected IAllele[] template;
    protected int color;
    protected String binomial;
    protected String uid;
    protected String branchName;
    protected IClassification branch;
    protected int colorPollineted;
    private LeafType leafType;
    private SaplingType saplingType;

    private ExtraTreeSpecies(String branch, String binomial, int color, ILogType wood, IAlleleFruit fruit) {
        this(branch, binomial, color, wood, fruit, null);
    }

    private ExtraTreeSpecies(String branch, String binomial, int color, ILogType wood, IAlleleFruit fruit, Class<? extends WorldGenerator> gen) {
        this.color = color;
        this.wood = wood;
        this.fruit = fruit;
        this.gen = gen == null ? WorldGenTree.class : gen;
        this.binomial = binomial;
        this.leafType = LeafType.NORMAL;
        this.saplingType = SaplingType.DEFAULT;
        this.families = new ArrayList();
        this.girth = 1;
        this.colorPollineted = new Color(color).brighter().getRGB();
        this.uid = this.toString().toLowerCase();
        this.branchName = branch;
    }

    public static void init() {
        ExtraTreeSpecies[] citrusSpecies;
        ExtraTreeSpecies[] pruneSpecies;
        for (ExtraTreeSpecies species : ExtraTreeSpecies.values()) {
            species.preInit();
        }
        for (ExtraTreeSpecies species2 : pruneSpecies = new ExtraTreeSpecies[]{Blackthorn, CherryPlum, Almond, Apricot, Peach, Nectarine, WildCherry, SourCherry, BlackCherry}) {
            IAlleleTreeSpecies citrus = (IAlleleTreeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.treePlum");
            species2.setWorldGen(citrus.getGenerator().getWorldGenerator((ITreeGenData)TreeManager.treeRoot.templateAsIndividual(citrus.getRoot().getDefaultTemplate())).getClass()).setSaplingType(SaplingType.FRUIT);
        }
        for (ExtraTreeSpecies species3 : citrusSpecies = new ExtraTreeSpecies[]{Orange, Manderin, Satsuma, Tangerine, Lime, KeyLime, FingerLime, Pomelo, Grapefruit, Kumquat, Citron, BuddhaHand}) {
            IAlleleTreeSpecies citrus2 = (IAlleleTreeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.treeLemon");
            species3.setWorldGen(citrus2.getGenerator().getWorldGenerator((ITreeGenData)TreeManager.treeRoot.templateAsIndividual(citrus2.getRoot().getDefaultTemplate())).getClass()).setLeafType(LeafType.JUNGLE).setSaplingType(SaplingType.FRUIT);
        }
        for (ExtraTreeSpecies species3 : citrusSpecies = ExtraTreeSpecies.values()) {
            String scientific = species3.branchName.substring(0, 1).toUpperCase() + species3.branchName.substring(1).toLowerCase();
            String uid = "trees." + species3.branchName.toLowerCase();
            IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
            if (branch == null) {
                branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
            }
            species3.branch = branch;
            branch.addMemberSpecies((IAlleleSpecies)species3);
        }
        IFruitFamily familyPrune = AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes");
        IFruitFamily familyPome = AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes");
        IFruitFamily familyJungle = AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle");
        IFruitFamily familyNuts = AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts");
        ExtraTreeFruitFamily familyBerry = ExtraTreeFruitFamily.Berry;
        ExtraTreeFruitFamily familyCitrus = ExtraTreeFruitFamily.Citrus;
        OrchardApple.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setYield(EnumAllele.Yield.HIGHER).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FASTER);
        SweetCrabapple.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        FloweringCrabapple.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setFertility(EnumAllele.Saplings.AVERAGE).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        PrairieCrabapple.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Blackthorn.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        CherryPlum.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        Peach.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Nectarine.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Apricot.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Almond.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        WildCherry.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        SourCherry.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOW);
        BlackCherry.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOWEST).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        Orange.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        Manderin.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOW);
        Satsuma.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        Tangerine.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.AVERAGE).setMaturation(EnumAllele.Maturation.FASTER);
        Lime.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW);
        KeyLime.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOWEST).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        FingerLime.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        Pomelo.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Grapefruit.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        Kumquat.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOW);
        Citron.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.AVERAGE);
        BuddhaHand.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW);
        Banana.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.PALM).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FAST);
        RedBanana.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.PALM).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOWER);
        Plantain.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.PALM).setHeight(EnumAllele.Height.AVERAGE).setYield(EnumAllele.Yield.LOWER);
        Butternut.setGirth(2).addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLER).setYield(EnumAllele.Yield.LOW);
        Rowan.addFamily(familyNuts).addFamily(familyBerry).setHeight(EnumAllele.Height.LARGER).setFertility(EnumAllele.Saplings.LOW).setSappiness(EnumAllele.Sappiness.LOWER);
        Ash.addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setFertility(EnumAllele.Saplings.LOW).setSappiness(EnumAllele.Sappiness.LOWER);
        Alder.addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Beech.addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.AVERAGE).setYield(EnumAllele.Yield.LOWER);
        CopperBeech.addFamily(familyPrune).addFamily(familyNuts).setMaturation(EnumAllele.Maturation.SLOW);
        Aspen.addFamily(familyPome).addFamily(familyNuts).setFertility(EnumAllele.Saplings.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Hazel.addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.AVERAGE).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOWER);
        Sycamore.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setFertility(EnumAllele.Saplings.LOWEST).setSappiness(EnumAllele.Sappiness.LOWER);
        Whitebeam.addFamily(familyPome).addFamily(familyPrune).setHeight(EnumAllele.Height.SMALLER);
        Hawthorn.addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.AVERAGE);
        Pecan.addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setHeight(EnumAllele.Height.LARGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        Elm.addFamily(familyPome).addFamily(familyPrune).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Elder.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).addFamily(familyBerry).setHeight(EnumAllele.Height.SMALLER).setSappiness(EnumAllele.Sappiness.LOW);
        Holly.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW);
        Hornbeam.addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        Sallow.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setLeafType(LeafType.WILLOW).setHeight(EnumAllele.Height.LARGE).setFertility(EnumAllele.Saplings.LOW);
        AcornOak.addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).setHeight(EnumAllele.Height.LARGE).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOWER).setGirth(2);
        Fir.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.LARGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        Olive.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setYield(EnumAllele.Yield.AVERAGE);
        Cedar.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.SMALLER).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOWER).setGirth(2);
        RedMaple.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setLeafType(LeafType.MAPLE).setFertility(EnumAllele.Saplings.AVERAGE).setSappiness(EnumAllele.Sappiness.HIGH);
        BalsamFir.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        LoblollyPine.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.SMALLER).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        Sweetgum.addFamily(familyNuts).setHeight(EnumAllele.Height.AVERAGE).setFertility(EnumAllele.Saplings.HIGH).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.AVERAGE);
        Locust.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLEST);
        Pear.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        OsangeOsange.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setYield(EnumAllele.Yield.LOWER);
        OldFustic.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLER).setSappiness(EnumAllele.Sappiness.LOWER);
        Brazilwood.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOWER);
        Logwood.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.AVERAGE).setFertility(EnumAllele.Saplings.LOW).setSappiness(EnumAllele.Sappiness.LOWER);
        Rosewood.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Purpleheart.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Iroko.addFamily(familyNuts).addFamily(familyJungle).setHeight(EnumAllele.Height.AVERAGE).setFertility(EnumAllele.Saplings.LOW);
        Gingko.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGE).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOW);
        Brazilnut.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGER).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOW);
        RoseGum.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGEST).setFertility(EnumAllele.Saplings.LOWEST).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.SLOWEST);
        SwampGum.addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGEST).setFertility(EnumAllele.Saplings.LOWEST).setMaturation(EnumAllele.Maturation.SLOWER).setGirth(2);
        Box.addFamily(familyPome).addFamily(familyPrune).addFamily(familyNuts).addFamily(familyCitrus).setHeight(EnumAllele.Height.SMALLER).setMaturation(EnumAllele.Maturation.FASTER);
        Clove.addFamily(familyNuts).addFamily(familyJungle).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        Coffee.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.LARGE).setYield(EnumAllele.Yield.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        MonkeyPuzzle.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.AVERAGE).setYield(EnumAllele.Yield.LOWER).setSappiness(EnumAllele.Sappiness.LOW).setGirth(2);
        RainbowGum.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOWER);
        PinkIvory.addFamily(familyNuts).addFamily(familyJungle).setHeight(EnumAllele.Height.SMALLEST);
        Blackcurrant.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FASTER);
        Redcurrant.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.AVERAGE).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FASTER);
        Blackberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FASTER);
        Raspberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FASTER);
        Blueberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.AVERAGE).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FASTER);
        Cranberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.AVERAGE).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FASTER);
        Juniper.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setLeafType(LeafType.CONIFER).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOW).setMaturation(EnumAllele.Maturation.FASTER);
        Gooseberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.HIGH).setYield(EnumAllele.Yield.HIGH).setMaturation(EnumAllele.Maturation.FASTER);
        GoldenRaspberry.addFamily(familyPrune).addFamily(familyNuts).addFamily(familyBerry).setSaplingType(SaplingType.SHRUB).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FASTEST);
        Cinnamon.addFamily(familyNuts).setLeafType(LeafType.JUNGLE).addFamily(familyJungle).setHeight(EnumAllele.Height.AVERAGE).setYield(EnumAllele.Yield.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        Coconut.addFamily(familyJungle).setLeafType(LeafType.PALM).setHeight(EnumAllele.Height.LARGER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        Cashew.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setYield(EnumAllele.Yield.LOW);
        Avacado.addFamily(familyPrune).addFamily(familyCitrus).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLEST).setYield(EnumAllele.Yield.AVERAGE);
        Nutmeg.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLER).setYield(EnumAllele.Yield.HIGH).setSappiness(EnumAllele.Sappiness.LOW);
        Allspice.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.HIGH);
        Chilli.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLER).setYield(EnumAllele.Yield.HIGHER).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        StarAnise.addFamily(familyNuts).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.AVERAGE).setYield(EnumAllele.Yield.HIGH);
        Mango.addFamily(familyPome).addFamily(familyPrune).addFamily(familyCitrus).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setYield(EnumAllele.Yield.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FAST);
        Starfruit.addFamily(familyPrune).addFamily(familyCitrus).addFamily(familyJungle).setLeafType(LeafType.JUNGLE).setYield(EnumAllele.Yield.AVERAGE).setMaturation(EnumAllele.Maturation.FAST);
        Candlenut.addFamily(familyNuts).addFamily(familyJungle).setHeight(EnumAllele.Height.SMALLEST).setFertility(EnumAllele.Saplings.LOWEST).setYield(EnumAllele.Yield.LOW).setSappiness(EnumAllele.Sappiness.LOW);
        DwarfHazel.addFamily(familyPrune).addFamily(familyNuts).setSaplingType(SaplingType.SHRUB).setFertility(EnumAllele.Saplings.AVERAGE).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.FASTER);
        Yew.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.LARGE).setSappiness(EnumAllele.Sappiness.LOWER);
        Cypress.setLeafType(LeafType.CONIFER).setSaplingType(SaplingType.POPLAR).setHeight(EnumAllele.Height.LARGER).setFertility(EnumAllele.Saplings.LOW).setSappiness(EnumAllele.Sappiness.LOWER).setMaturation(EnumAllele.Maturation.SLOW);
        DouglasFir.setLeafType(LeafType.CONIFER).setHeight(EnumAllele.Height.SMALLER).setFertility(EnumAllele.Saplings.LOW).setMaturation(EnumAllele.Maturation.SLOWER).setGirth(2);
        Hemlock.setLeafType(LeafType.CONIFER).setGirth(2).setHeight(EnumAllele.Height.AVERAGE).setFertility(EnumAllele.Saplings.LOW).setMaturation(EnumAllele.Maturation.SLOWER);
    }

    static ItemStack getEBXLStack(String name) {
        try {
            Class<?> elements = Class.forName("extrabiomes.lib.Element");
            Method getElementMethod = elements.getMethod("valueOf", String.class);
            Method getItemStack = elements.getMethod("get", new Class[0]);
            Object element = getElementMethod.invoke(null, "SAPLING_AUTUMN_YELLOW");
            return (ItemStack)getItemStack.invoke(element, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ExtraTreeSpecies addFamily(IFruitFamily family) {
        this.families.add(family);
        return this;
    }

    private ExtraTreeSpecies setWorldGen(Class<? extends WorldGenerator> gen) {
        this.gen = gen;
        return this;
    }

    private ExtraTreeSpecies setGirth(int girth) {
        this.template[EnumTreeChromosome.GIRTH.ordinal()] = AlleleHelper.getAllele(girth);
        return this;
    }

    public void preInit() {
        this.template = Binnie.Genetics.getTreeRoot().getDefaultTemplate();
        this.template[0] = this;
        if (this.fruit != null) {
            this.template[EnumTreeChromosome.FRUITS.ordinal()] = this.fruit;
        }
        this.template[EnumTreeChromosome.GIRTH.ordinal()] = AlleleHelper.getAllele(this.girth);
        IClassification clas = AlleleManager.alleleRegistry.getClassification("trees." + this.branch);
        if (clas != null) {
            clas.addMemberSpecies((IAlleleSpecies)this);
            this.branch = clas;
        }
    }

    public String getName() {
        return I18N.localise("extratrees.species." + this.name().toLowerCase() + ".name");
    }

    public String getDescription() {
        return I18N.localiseOrBlank("extratrees.species." + this.name().toLowerCase() + ".desc");
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public String getUID() {
        return "extratrees.species." + this.uid;
    }

    public boolean isDominant() {
        return true;
    }

    public EnumPlantType getPlantType() {
        return EnumPlantType.Plains;
    }

    public ITreeGenerator getGenerator() {
        return new DefaultTreeGenerator(this);
    }

    public WorldGenerator getGenerator(ITreeGenData tree) {
        if (this.gen != null) {
            try {
                return this.gen.getConstructor(ITreeGenData.class).newInstance(tree);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new WorldGenDefault(tree);
    }

    protected ExtraTreeSpecies setLeafType(LeafType type) {
        this.leafType = type;
        if (this.leafType == LeafType.CONIFER) {
            this.saplingType = SaplingType.CONIFER;
        } else if (this.leafType == LeafType.JUNGLE) {
            this.saplingType = SaplingType.JUNGLE;
        } else if (this.leafType == LeafType.PALM) {
            this.saplingType = SaplingType.PALM;
        }
        return this;
    }

    protected ExtraTreeSpecies setSaplingType(SaplingType saplingType) {
        this.saplingType = saplingType;
        return this;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public ArrayList<IFruitFamily> getSuitableFruit() {
        return this.families;
    }

    public ILogType getLog() {
        return this.wood;
    }

    public ExtraTreeSpecies setHeight(EnumAllele.Height height) {
        IAllele allele = AlleleHelper.getAllele(height);
        if (allele != null) {
            this.template[EnumTreeChromosome.HEIGHT.ordinal()] = allele;
        }
        return this;
    }

    public ExtraTreeSpecies setSappiness(EnumAllele.Sappiness sappiness) {
        IAllele allele = AlleleHelper.getAllele(sappiness);
        if (allele != null) {
            this.template[EnumTreeChromosome.SAPPINESS.ordinal()] = allele;
        }
        return this;
    }

    public ExtraTreeSpecies setMaturation(EnumAllele.Maturation maturation) {
        IAllele allele = AlleleHelper.getAllele(maturation);
        if (allele != null) {
            this.template[EnumTreeChromosome.MATURATION.ordinal()] = allele;
        }
        return this;
    }

    public ExtraTreeSpecies setYield(EnumAllele.Yield yield) {
        IAllele allele = AlleleHelper.getAllele(yield);
        if (allele != null) {
            this.template[EnumTreeChromosome.YIELD.ordinal()] = allele;
        }
        return this;
    }

    public ExtraTreeSpecies setFertility(EnumAllele.Saplings saplings) {
        IAllele allele = AlleleHelper.getAllele(saplings);
        if (allele != null) {
            this.template[EnumTreeChromosome.FERTILITY.ordinal()] = allele;
        }
        return this;
    }

    public int getLeafColor(ITree tree) {
        return this.color;
    }

    public int getIconColour(int renderPass) {
        return renderPass == 0 ? this.color : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getGermlingIcon(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return PluginArboriculture.items.pollenFertile.getIcon(PluginArboriculture.items.pollenFertile.getItemStack(), renderPass);
        }
        return renderPass == 0 ? this.saplingType.icon[1] : this.saplingType.icon[0];
    }

    public IIconProvider getIconProvider() {
        return this;
    }

    public IIcon getIcon(short texUID) {
        return TextureManager.getInstance().getIcon(texUID);
    }

    public void registerIcons(IIconRegister register) {
        for (SaplingType type : SaplingType.values()) {
            type.icon = new IIcon[2];
            type.icon[0] = ExtraTrees.proxy.getIcon(register, "saplings/" + type.toString().toLowerCase() + ".trunk");
            type.icon[1] = ExtraTrees.proxy.getIcon(register, "saplings/" + type.toString().toLowerCase() + ".leaves");
        }
    }

    public ITreeRoot getRoot() {
        return Binnie.Genetics.getTreeRoot();
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (this.template[EnumTreeChromosome.FRUITS.ordinal()] instanceof ExtraTreeFruitGene) {
            ExtraTreeFruitGene fruit = (ExtraTreeFruitGene)this.template[EnumTreeChromosome.FRUITS.ordinal()];
            for (ItemStack stack : fruit.products.keySet()) {
                if (!stack.func_77969_a(itemstack)) continue;
                return 1.0f;
            }
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("honeyDrop")) {
            return 0.5f;
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("honeydew")) {
            return 0.7f;
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("beeCombs")) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        Collection combinations;
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            bounty.add(research);
        }
        if (this.template[EnumTreeChromosome.FRUITS.ordinal()] instanceof ExtraTreeFruitGene) {
            ExtraTreeFruitGene fruit = (ExtraTreeFruitGene)this.template[EnumTreeChromosome.FRUITS.ordinal()];
            for (ItemStack stack : fruit.products.keySet()) {
                ItemStack stack2 = stack.func_77946_l();
                stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
                bounty.add(stack2);
            }
        }
        return bounty.toArray(new ItemStack[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.SAPLING) {
            if (renderPass == 0) {
                return this.getLeafColor(null);
            }
            if (this.getLog() == null) {
                return 0xFFFFFF;
            }
            return this.getLog().getColour();
        }
        return this.getLeafColor(null);
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, (IChromosomeType)EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    public String getUnlocalizedName() {
        return "extratrees.species." + this.toString().toLowerCase() + ".name";
    }

    public int getLeafColour(boolean pollinated) {
        return pollinated ? this.colorPollineted : this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getLeafIcon(boolean pollinated, boolean fancy) {
        try {
            EnumLeafType leaf = EnumLeafType.valueOf((String)this.leafType.description.toUpperCase());
            TextureLeaves texture = TextureLeaves.get((EnumLeafType)leaf);
            if (pollinated) {
                return texture.getPollinated();
            }
            if (fancy) {
                return texture.getFancy();
            }
            return texture.getPlain();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(EnumGermlingType type, int renderPass) {
        return this.getGermlingIcon(type, renderPass);
    }
}

