/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GT_Utility;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;

public class ResultWrongSievert
implements CheckRecipeResult {
    private NeededSievertType type;
    private int required;

    public ResultWrongSievert(int required, NeededSievertType type) {
        this.required = required;
        this.type = type;
    }

    public String getID() {
        return "wrong_sievert";
    }

    public boolean wasSuccessful() {
        return false;
    }

    public String getDisplayString() {
        switch (this.type) {
            case EXACTLY: {
                return StatCollector.func_74837_a((String)"GT5U.gui.text.wrong_sievert_exactly", (Object[])new Object[]{GT_Utility.formatNumbers((long)this.required)});
            }
            case MINIMUM: {
                return StatCollector.func_74837_a((String)"GT5U.gui.text.wrong_sievert_min", (Object[])new Object[]{GT_Utility.formatNumbers((long)this.required)});
            }
        }
        return "";
    }

    public CheckRecipeResult newInstance() {
        return new ResultWrongSievert(0, NeededSievertType.EXACTLY);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.required);
        buffer.func_150787_b(this.type.ordinal());
    }

    public void decode(PacketBuffer buffer) {
        this.required = buffer.func_150792_a();
        this.type = NeededSievertType.values()[buffer.func_150792_a()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultWrongSievert that = (ResultWrongSievert)o;
        return this.required == that.required;
    }

    public static CheckRecipeResult insufficientSievert(int required) {
        return new ResultWrongSievert(required, NeededSievertType.MINIMUM);
    }

    public static CheckRecipeResult wrongSievert(int required) {
        return new ResultWrongSievert(required, NeededSievertType.EXACTLY);
    }

    public static enum NeededSievertType {
        EXACTLY,
        MINIMUM;

    }
}

