/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.system.oredict.OreDictHandler;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet;
import java.nio.ByteBuffer;
import java.util.HashSet;
import net.minecraft.world.IBlockAccess;

public class OreDictCachePacket
extends GT_Packet {
    private HashSet<Pair<Integer, Short>> hashSet = new HashSet();

    public OreDictCachePacket() {
        super(true);
    }

    public OreDictCachePacket(HashSet<Pair<Integer, Short>> set) {
        super(false);
        this.hashSet = set;
    }

    public byte getPacketID() {
        return 3;
    }

    public byte[] encode() {
        int size = this.hashSet.size();
        ByteBuffer buff = ByteBuffer.allocate(4 + size * 4 + size * 2).putInt(size);
        for (Pair<Integer, Short> p : this.hashSet) {
            buff.putInt(p.getKey()).putShort(p.getValue());
        }
        return buff.array();
    }

    public GT_Packet decode(ByteArrayDataInput byteArrayDataInput) {
        int size = byteArrayDataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.hashSet.add(new Pair<Integer, Short>(byteArrayDataInput.readInt(), byteArrayDataInput.readShort()));
        }
        return new OreDictCachePacket(this.hashSet);
    }

    public void process(IBlockAccess iBlockAccess) {
        OreDictHandler.getNonBWCache().clear();
        OreDictHandler.getNonBWCache().addAll(this.hashSet);
    }
}

