/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.ASM;

import com.github.bartimaeusnek.bartworks.ASM.ASMUtils;
import com.github.bartimaeusnek.bartworks.ASM.BWCore;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BWCoreTransformer
implements IClassTransformer {
    public static final String[] DESCRIPTIONFORCONFIG = new String[]{"REMOVING RAIN FROM LAST MILLENIUM (EXU)", "REMVOING CREATURES FROM LAST MILLENIUM (EXU)", "PATCHING GLOBAL RENDERER FOR USE WITH MY GALACTIC DIMS", "PATCHING THAUMCRAFT WAND PEDESTAL TO PREVENT VIS DUPLICATION", "[UNUSED] PLACING MY GLASS-BLOCK RUNNABLE INTO THE GT_API", "DUCTTAPING RWG WORLDEN FAILS", "PATCHING CRAFTING MANAGER FOR CACHING RECIPES"};
    public static final String[] CLASSESBEEINGTRANSFORMED = new String[]{"com.rwtema.extrautils.worldgen.endoftime.WorldProviderEndOfTime", "com.rwtema.extrautils.worldgen.endoftime.ChunkProviderEndOfTime", "net.minecraft.client.renderer.RenderGlobal", "thaumcraft.common.tiles.TileWandPedestal", "gregtech.GT_Mod", "rwg.world.ChunkGeneratorRealistic", "net.minecraft.item.crafting.CraftingManager"};
    static boolean obfs;
    public static boolean[] shouldTransform;

    private static MethodNode transformThaumcraftWandPedestal(MethodNode method) {
        InsnList nu = new InsnList();
        for (int j = 0; j < method.instructions.size(); ++j) {
            AbstractInsnNode instruction = method.instructions.get(j);
            nu.add(instruction);
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode invokevirtual = (MethodInsnNode)instruction;
            if (!invokevirtual.name.equals("addVis")) continue;
            AbstractInsnNode beginning = method.instructions.get(j - 7);
            LabelNode label = new LabelNode();
            nu.insertBefore(beginning, (AbstractInsnNode)new VarInsnNode(25, 0));
            nu.insertBefore(beginning, (AbstractInsnNode)new FieldInsnNode(180, "thaumcraft/common/tiles/TileWandPedestal", obfs ? "field_145850_b" : "worldObj", "Lnet/minecraft/world/World;"));
            nu.insertBefore(beginning, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", obfs ? "field_72995_K" : "isRemote", "Z"));
            nu.insertBefore(beginning, (AbstractInsnNode)new JumpInsnNode(154, label));
            nu.add((AbstractInsnNode)new InsnNode(87));
            nu.add((AbstractInsnNode)label);
            ++j;
        }
        method.instructions = nu;
        return method;
    }

    public static byte[] transform(int id, byte[] basicClass) {
        if (!shouldTransform[id]) {
            BWCore.BWCORE_LOG.info("Patch: " + DESCRIPTIONFORCONFIG[id] + " is disabled, will not patch!");
            return basicClass;
        }
        if (id < CLASSESBEEINGTRANSFORMED.length) {
            BWCore.BWCORE_LOG.info(DESCRIPTIONFORCONFIG[id]);
            ClassReader classReader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 4);
            List methods = classNode.methods;
            block0 : switch (id) {
                case 0: {
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    String name_deObfs = "canDoRainSnowIce";
                    String dsc_deObfs = "(Lnet/minecraft/world/chunk/Chunk;)Z";
                    String dsc_Obfs = "(Lapx;)Z";
                    for (int i = 0; i < methods.size(); ++i) {
                        if (!((MethodNode)methods.get((int)i)).name.equalsIgnoreCase(name_deObfs)) continue;
                        BWCore.BWCORE_LOG.info("Found " + name_deObfs + "! Removing!");
                        methods.remove(i);
                        break;
                    }
                    BWCore.BWCORE_LOG.info("Creating new " + name_deObfs + "!");
                    MethodNode nu = new MethodNode(1, name_deObfs, dsc_deObfs, null, new String[0]);
                    InsnList insnList = new InsnList();
                    insnList.add((AbstractInsnNode)new InsnNode(3));
                    insnList.add((AbstractInsnNode)new InsnNode(172));
                    nu.instructions = insnList;
                    nu.maxLocals = 1;
                    nu.maxStack = 1;
                    methods.add(nu);
                    break;
                }
                case 1: {
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    String name_deObfs = "getPossibleCreatures";
                    Object name_src = "func_73155_a";
                    String name_Obfs = "a";
                    String dsc_deObfs = "(Lnet/minecraft/entity/EnumCreatureType;III)Ljava/util/List;";
                    String dsc_Obfs = "(Lsx;III)Ljava/util/List;";
                    for (int i = 0; i < methods.size(); ++i) {
                        if (!ASMUtils.isCorrectMethod((MethodNode)methods.get(i), new String[]{name_deObfs, name_Obfs, name_src}) || !ASMUtils.isCorrectMethod((MethodNode)methods.get(i), dsc_deObfs, dsc_Obfs)) continue;
                        BWCore.BWCORE_LOG.info("Found " + name_deObfs + "! Patching!");
                        MethodNode toPatch = (MethodNode)methods.get(i);
                        InsnList insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new InsnNode(1));
                        insnList.add((AbstractInsnNode)new InsnNode(176));
                        toPatch.instructions = insnList;
                        toPatch.maxStack = 1;
                        toPatch.maxLocals = 5;
                        methods.set(i, toPatch);
                        break block0;
                    }
                }
                case 2: {
                    String name_deObfs = "renderSky";
                    Object name_src = "func_72714_a";
                    String name_Obfs = "a";
                    String dsc_universal = "(F)V";
                    String field_deObfs = "locationSunPng";
                    String field_src = "field_110928_i";
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    for (MethodNode toPatch : methods) {
                        if (!ASMUtils.isCorrectMethod(toPatch, new String[]{name_deObfs, name_Obfs, name_src}) || !ASMUtils.isCorrectMethod(toPatch, dsc_universal)) continue;
                        BWCore.BWCORE_LOG.info("Found " + name_deObfs + "! Patching!");
                        InsnList nu = new InsnList();
                        LabelNode[] LabelNodes = new LabelNode[]{new LabelNode(), new LabelNode()};
                        String theWorld_src = "field_72769_h";
                        String renderEngine_src = "field_72770_i";
                        String provider_src = "field_73011_w";
                        String bindTexture_src = "func_110577_a";
                        for (int j = 0; j < toPatch.instructions.size(); ++j) {
                            String nameFieldToPatch;
                            if (toPatch.instructions.get(j) instanceof FieldInsnNode && toPatch.instructions.get(j).getOpcode() == 178 && !(nameFieldToPatch = ASMUtils.matchAny(((FieldInsnNode)toPatch.instructions.get((int)j)).name, field_deObfs, field_src)).isEmpty()) {
                                boolean useSrc = nameFieldToPatch.equals(field_src);
                                if (useSrc) {
                                    BWCore.BWCORE_LOG.info("Found either Optifine or Fastcraft... this patch was annoying to make compatible to them...");
                                }
                                nu.add((AbstractInsnNode)new VarInsnNode(25, 0));
                                nu.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/RenderGlobal", useSrc ? theWorld_src : "theWorld", "Lnet/minecraft/client/multiplayer/WorldClient;"));
                                nu.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/multiplayer/WorldClient", useSrc ? provider_src : "provider", "Lnet/minecraft/world/WorldProvider;"));
                                nu.add((AbstractInsnNode)new TypeInsnNode(193, "com/github/bartimaeusnek/crossmod/galacticraft/planets/AbstractWorldProviderSpace"));
                                nu.add((AbstractInsnNode)new JumpInsnNode(153, LabelNodes[0]));
                                nu.add((AbstractInsnNode)new VarInsnNode(25, 0));
                                nu.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/RenderGlobal", useSrc ? renderEngine_src : "renderEngine", "Lnet/minecraft/client/renderer/texture/TextureManager;"));
                                nu.add((AbstractInsnNode)new FieldInsnNode(178, "com/github/bartimaeusnek/crossmod/galacticraft/planets/ross128b/SkyProviderRoss128b", "sunTex", "Lnet/minecraft/util/ResourceLocation;"));
                                nu.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/renderer/texture/TextureManager", useSrc ? bindTexture_src : "bindTexture", "(Lnet/minecraft/util/ResourceLocation;)V", false));
                                nu.add((AbstractInsnNode)new JumpInsnNode(167, LabelNodes[1]));
                                nu.add((AbstractInsnNode)LabelNodes[0]);
                                nu.add((AbstractInsnNode)new VarInsnNode(25, 0));
                                nu.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/RenderGlobal", useSrc ? renderEngine_src : "renderEngine", "Lnet/minecraft/client/renderer/texture/TextureManager;"));
                                nu.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/client/renderer/RenderGlobal", useSrc ? field_src : "locationSunPng", "Lnet/minecraft/util/ResourceLocation;"));
                                nu.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/renderer/texture/TextureManager", useSrc ? bindTexture_src : "bindTexture", "(Lnet/minecraft/util/ResourceLocation;)V", false));
                                nu.add((AbstractInsnNode)LabelNodes[1]);
                                ++j;
                                continue;
                            }
                            if (j < toPatch.instructions.size() - 2 && (toPatch.instructions.get(j + 2) instanceof FieldInsnNode && toPatch.instructions.get(j + 2).getOpcode() == 178 && !ASMUtils.matchAny(((FieldInsnNode)toPatch.instructions.get((int)(j + 2))).name, field_deObfs, field_src).isEmpty() || toPatch.instructions.get(j + 1) instanceof FieldInsnNode && toPatch.instructions.get(j + 1).getOpcode() == 178 && !ASMUtils.matchAny(((FieldInsnNode)toPatch.instructions.get((int)(j + 1))).name, field_deObfs, field_src).isEmpty())) continue;
                            nu.add(toPatch.instructions.get(j));
                        }
                        toPatch.instructions = nu;
                        break block0;
                    }
                }
                case 3: {
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    String name_deObfs = "updateEntity";
                    Object name_src = "func_145845_h";
                    String name_Obfs = "h";
                    String dsc_universal = "()V";
                    for (int i = 0; i < methods.size(); ++i) {
                        if (!ASMUtils.isCorrectMethod((MethodNode)methods.get(i), new String[]{name_deObfs, name_Obfs, name_src}) || !ASMUtils.isCorrectMethod((MethodNode)methods.get(i), dsc_universal, dsc_universal)) continue;
                        BWCore.BWCORE_LOG.info("Found " + name_deObfs + "! Patching!");
                        methods.set(i, BWCoreTransformer.transformThaumcraftWandPedestal((MethodNode)methods.get(i)));
                        break block0;
                    }
                }
                case 4: {
                    break;
                }
                case 5: {
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    String name_deObfs = "getNewNoise";
                    for (MethodNode toPatch : methods) {
                        if (!ASMUtils.isCorrectMethod(toPatch, name_deObfs)) continue;
                        BWCore.BWCORE_LOG.info("Found " + name_deObfs + "! Patching!");
                        LabelNode[] LabelNodes = new LabelNode[]{new LabelNode(), new LabelNode()};
                        InsnList nu = new InsnList();
                        nu.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        nu.add((AbstractInsnNode)new IntInsnNode(17, -28675));
                        nu.add((AbstractInsnNode)new JumpInsnNode(162, LabelNodes[0]));
                        nu.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        nu.add((AbstractInsnNode)new LdcInsnNode((Object)-28675));
                        nu.add((AbstractInsnNode)new InsnNode(112));
                        nu.add((AbstractInsnNode)new VarInsnNode(54, 2));
                        nu.add((AbstractInsnNode)LabelNodes[0]);
                        nu.add((AbstractInsnNode)new VarInsnNode(21, 3));
                        nu.add((AbstractInsnNode)new IntInsnNode(17, -28675));
                        nu.add((AbstractInsnNode)new JumpInsnNode(162, LabelNodes[1]));
                        nu.add((AbstractInsnNode)new VarInsnNode(21, 3));
                        nu.add((AbstractInsnNode)new LdcInsnNode((Object)-28675));
                        nu.add((AbstractInsnNode)new InsnNode(112));
                        nu.add((AbstractInsnNode)new VarInsnNode(54, 3));
                        nu.add((AbstractInsnNode)LabelNodes[1]);
                        for (int j = 1; j < toPatch.instructions.size(); ++j) {
                            nu.add(toPatch.instructions.get(j));
                        }
                        toPatch.instructions = nu;
                        break block0;
                    }
                }
                case 6: {
                    BWCore.BWCORE_LOG.info("Could find: " + CLASSESBEEINGTRANSFORMED[id]);
                    String name_deObfs = "findMatchingRecipe";
                    String name_Obfs = "a";
                    String name_src = "func_82787_a";
                    for (MethodNode toPatch : methods) {
                        if (!ASMUtils.isCorrectMethod(toPatch, name_deObfs, name_Obfs, name_src)) continue;
                        toPatch.instructions = new InsnList();
                        toPatch.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        toPatch.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        toPatch.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/bartimaeusnek/bartworks/ASM/BWCoreStaticReplacementMethodes", "findCachedMatchingRecipe", "(Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Lnet/minecraft/item/ItemStack;", false));
                        toPatch.instructions.add((AbstractInsnNode)new InsnNode(176));
                        toPatch.localVariables.clear();
                        toPatch.maxStack = 2;
                        toPatch.maxLocals = 3;
                        break block0;
                    }
                }
                default: {
                    BWCore.BWCORE_LOG.info("Could not find: " + CLASSESBEEINGTRANSFORMED[id]);
                    return basicClass;
                }
            }
            classNode.methods = methods;
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            byte[] ret = classWriter.toByteArray();
            if (Arrays.hashCode(basicClass) == Arrays.hashCode(ret)) {
                BWCore.BWCORE_LOG.warn("Could not patch: " + CLASSESBEEINGTRANSFORMED[id]);
            }
            return ret;
        }
        return basicClass;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        for (int i = 0; i < CLASSESBEEINGTRANSFORMED.length; ++i) {
            if (!name.equalsIgnoreCase(CLASSESBEEINGTRANSFORMED[i]) && !transformedName.equalsIgnoreCase(CLASSESBEEINGTRANSFORMED[i])) continue;
            return BWCoreTransformer.transform(i, basicClass);
        }
        return basicClass;
    }

    static {
        shouldTransform = new boolean[CLASSESBEEINGTRANSFORMED.length];
    }
}

