/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.ASM;

import com.github.bartimaeusnek.bartworks.ASM.BWCoreTransformer;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import gregtech.api.enums.Mods;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BWCore
extends DummyModContainer {
    public static final String BWCORE_NAME = "BartWorks ASM Core";
    public static final Logger BWCORE_LOG = LogManager.getLogger((String)"BartWorks ASM Core");

    public BWCore() {
        super(new ModMetadata());
        ModMetadata metadata = this.getMetadata();
        metadata.modId = "BWCore";
        metadata.name = BWCORE_NAME;
        metadata.version = "0.0.1";
        metadata.authorList.add("bartimaeusnek");
        metadata.dependants = this.getDependants();
        metadata.parent = "bartworks";
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        BWCoreTransformer.shouldTransform[0] = ConfigHandler.enabledPatches[0];
        BWCoreTransformer.shouldTransform[1] = ConfigHandler.enabledPatches[1];
        BWCoreTransformer.shouldTransform[3] = ConfigHandler.enabledPatches[3];
        BWCoreTransformer.shouldTransform[4] = false;
        BWCoreTransformer.shouldTransform[5] = ConfigHandler.enabledPatches[5];
        BWCoreTransformer.shouldTransform[6] = ConfigHandler.enabledPatches[6];
        BWCORE_LOG.info("Extra Utilities found and ASM Patch enabled? " + BWCoreTransformer.shouldTransform[0]);
        BWCORE_LOG.info("Thaumcraft found and ASM Patch enabled? " + BWCoreTransformer.shouldTransform[3]);
        BWCORE_LOG.info("RWG found and ASM Patch enabled? " + BWCoreTransformer.shouldTransform[5]);
    }

    public List<ArtifactVersion> getDependants() {
        ArrayList<ArtifactVersion> ret = new ArrayList<ArtifactVersion>();
        ret.add((ArtifactVersion)new DefaultArtifactVersion(Mods.ExtraUtilities.ID, true));
        ret.add((ArtifactVersion)new DefaultArtifactVersion(Mods.Thaumcraft.ID, true));
        ret.add((ArtifactVersion)new DefaultArtifactVersion(Mods.GTPlusPlus.ID, true));
        ret.add((ArtifactVersion)new DefaultArtifactVersion(Mods.RWG.ID, true));
        ret.add((ArtifactVersion)new DefaultArtifactVersion("bartworks", true));
        ret.add((ArtifactVersion)new DefaultArtifactVersion("bartworkscrossmod", true));
        return ret;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }
}

