/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.factory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.factory.AbstractFactory;
import de.eydamos.backpack.gui.GuiWorkbenchBackpack;
import de.eydamos.backpack.inventory.AbstractInventoryBackpack;
import de.eydamos.backpack.inventory.InventoryCraftingGrid;
import de.eydamos.backpack.inventory.InventoryRecipes;
import de.eydamos.backpack.inventory.container.Boundaries;
import de.eydamos.backpack.inventory.container.ContainerAdvanced;
import de.eydamos.backpack.inventory.container.ContainerWorkbenchBackpack;
import de.eydamos.backpack.inventory.slot.SlotBackpack;
import de.eydamos.backpack.inventory.slot.SlotCraftingAdvanced;
import de.eydamos.backpack.inventory.slot.SlotPhantom;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.guiadvanced.form.Button;
import de.eydamos.guiadvanced.form.Label;
import de.eydamos.guiadvanced.subpart.GuiSlot;
import de.eydamos.guiadvanced.subpart.Icon;
import de.eydamos.guiadvanced.util.Alignment;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class FactoryWorkbenchBackpack
extends AbstractFactory<BackpackSave> {
    protected final int BIG_X_SPACING = 30;

    @Override
    public ContainerAdvanced getContainer(BackpackSave backpack, IInventory[] inventories, EntityPlayer entityPlayer) {
        int row;
        int col;
        int row2;
        int x;
        int xSpacing;
        IInventory[] containerInventories = new IInventory[4];
        InventoryCraftingGrid craftingGrid = new InventoryCraftingGrid(inventories[1]);
        InventoryRecipes recipes = null;
        if (backpack.isIntelligent()) {
            recipes = new InventoryRecipes((IInventory)craftingGrid);
        }
        containerInventories[0] = inventories[0];
        containerInventories[1] = inventories[1];
        containerInventories[2] = craftingGrid;
        containerInventories[3] = recipes;
        ContainerWorkbenchBackpack container = inventories[1] instanceof AbstractInventoryBackpack ? new ContainerWorkbenchBackpack(containerInventories, backpack) : new ContainerWorkbenchBackpack(craftingGrid);
        container.setWidth(178);
        if (backpack.isIntelligent()) {
            xSpacing = 8;
            x = xSpacing + 72;
        } else {
            xSpacing = 30;
            x = xSpacing + 95;
        }
        int y = 17;
        container.addBoundary(Boundaries.EXTRA);
        container.addSlot((Slot)new SlotCraftingAdvanced(entityPlayer, container, 0, x, y + 18, containerInventories));
        x = xSpacing;
        container.addBoundary(Boundaries.EXTRA_END);
        container.addBoundary(Boundaries.CRAFTING);
        for (row2 = 0; row2 < 3; ++row2) {
            for (col = 0; col < 3; ++col) {
                container.addSlot(new SlotPhantom((IInventory)craftingGrid, col + row2 * 3, x, y));
                x += 18;
            }
            y += 18;
            x = xSpacing;
        }
        container.addBoundary(Boundaries.CRAFTING_END);
        if (backpack.isIntelligent()) {
            y = 17;
            x += 108;
            for (row2 = 0; row2 < 3; ++row2) {
                for (col = 0; col < 3; ++col) {
                    container.addSlot(new SlotPhantom(recipes, col + row2 * 3, x, y));
                    x += 18;
                }
                y += 18;
                x = xSpacing + 108;
            }
        }
        x = 8;
        y += 5;
        container.addBoundary(Boundaries.BACKPACK);
        int remainingSlots = inventories[1].func_70302_i_();
        for (row = 0; row < inventories[1].func_70302_i_() / backpack.getSlotsPerRow(); ++row) {
            int cols = remainingSlots - 9 >= 9 ? 9 : remainingSlots;
            remainingSlots -= cols;
            if (cols * 18 < 162) {
                x += (int)Math.round(81.0 - (double)(cols * 18) / 2.0) + 1;
            }
            for (int col2 = 0; col2 < cols; ++col2) {
                container.addSlot(new SlotBackpack(inventories[1], col2 + row * 9, x, y));
                x += 18;
            }
            y += 18;
            x = 8;
        }
        container.addBoundary(Boundaries.BACKPACK_END);
        container.addBoundary(Boundaries.INVENTORY);
        y += 14;
        for (row = 0; row < 3; ++row) {
            for (int col3 = 0; col3 < 9; ++col3) {
                container.addSlot(new Slot(inventories[0], col3 + row * 9 + 9, x, y));
                x += 18;
            }
            y += 18;
            x = 8;
        }
        container.addBoundary(Boundaries.INVENTORY_END);
        container.addBoundary(Boundaries.HOTBAR);
        y += 6;
        for (col = 0; col < 9; ++col) {
            container.addSlot(new Slot(inventories[0], col, x, y));
            x += 18;
        }
        container.addBoundary(Boundaries.HOTBAR_END);
        y += 18;
        container.setHeight(y += 7);
        return container;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiContainer(BackpackSave backpack, IInventory[] inventories, EntityPlayer entityPlayer) {
        Button btn_clear;
        ContainerAdvanced container = this.getContainer(backpack, inventories, entityPlayer);
        GuiWorkbenchBackpack guiBackpack = new GuiWorkbenchBackpack(container);
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            Slot slot = (Slot)container.field_75151_b.get(i);
            GuiSlot guiSlot = i == 0 ? new GuiSlot(slot.field_75223_e - 5, slot.field_75221_f - 5, 26) : new GuiSlot(slot.field_75223_e - 1, slot.field_75221_f - 1);
            guiBackpack.addSubPart(guiSlot);
        }
        if (!backpack.isIntelligent()) {
            guiBackpack.addSubPart(new Icon(0, 238, 90, 35, 22, 15));
            btn_clear = new Button(0, 88, 16, 11, 11, "c");
            guiBackpack.addSubPart(btn_clear);
        } else {
            btn_clear = new Button(0, 66, 16, 11, 11, "c");
            Button btn_save = new Button(1, 81, 16, 11, 11, "s");
            guiBackpack.addSubPart(btn_clear);
            guiBackpack.addSubPart(btn_save);
        }
        int textPositionX = 28;
        Alignment alignment = Alignment.LEFT;
        if (backpack.isIntelligent()) {
            textPositionX = guiBackpack.getWidth() / 2;
            alignment = Alignment.CENTER;
        }
        int textPositionY = 6;
        int slotsPerRow = backpack.getSlotsPerRow();
        int inventoryRows = (int)Math.ceil((float)inventories[1].func_70302_i_() / (float)slotsPerRow);
        int textPositionY2 = textPositionY + inventoryRows * 18 + 54 + 19;
        guiBackpack.addSubPart(new Label(textPositionX, textPositionY, 0x404040, "container.crafting", alignment));
        guiBackpack.addSubPart(new Label(8, textPositionY2, 0x404040, "container.inventory"));
        return guiBackpack;
    }
}

