/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.tile.AEBaseInvTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class WrapperInventoryRange
implements IInventory {
    private final IInventory src;
    private boolean ignoreValidItems = false;
    private int[] slots;

    public WrapperInventoryRange(IInventory a, int[] s, boolean ignoreValid) {
        this.src = a;
        this.setSlots(s);
        if (this.getSlots() == null) {
            this.setSlots(new int[0]);
        }
        this.setIgnoreValidItems(ignoreValid);
    }

    public WrapperInventoryRange(IInventory a, int min, int size, boolean ignoreValid) {
        this.src = a;
        this.setSlots(new int[size]);
        for (int x = 0; x < size; ++x) {
            this.getSlots()[x] = min + x;
        }
        this.setIgnoreValidItems(ignoreValid);
    }

    public static String concatLines(int[] s, String separator) {
        if (s.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int value : s) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return "";
    }

    public int func_70302_i_() {
        return this.getSlots().length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.src.func_70301_a(this.getSlots()[var1]);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.src.func_70298_a(this.getSlots()[var1], var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.src.func_70304_b(this.getSlots()[var1]);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.src.func_70299_a(this.getSlots()[var1], var2);
    }

    public String func_145825_b() {
        return this.src.func_145825_b();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        if (this.src instanceof AEBaseInvTile) {
            IInventory internalInv = ((AEBaseInvTile)this.src).getInternalInventory();
            return internalInv.func_70297_j_();
        }
        return this.src.func_70297_j_();
    }

    public void func_70296_d() {
        this.src.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.src.func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.src.func_70295_k_();
    }

    public void func_70305_f() {
        this.src.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.isIgnoreValidItems()) {
            return true;
        }
        return this.src.func_94041_b(this.getSlots()[i], itemstack);
    }

    boolean isIgnoreValidItems() {
        return this.ignoreValidItems;
    }

    private void setIgnoreValidItems(boolean ignoreValidItems) {
        this.ignoreValidItems = ignoreValidItems;
    }

    int[] getSlots() {
        return this.slots;
    }

    private void setSlots(int[] slots) {
        this.slots = slots;
    }
}

