/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version;

import appeng.core.AELog;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public final class VersionCheckerConfig {
    private static final int DEFAULT_INTERVAL_HOURS = 24;
    private static final int MIN_INTERVAL_HOURS = 0;
    private static final int MAX_INTERVAL_HOURS = 168;
    @Nonnull
    private final Configuration config;
    private final boolean isEnabled;
    @Nonnull
    private final String lastCheck;
    private final int interval;
    @Nonnull
    private final String level;
    private final boolean shouldNotifyPlayer;
    private final boolean shouldPostChangelog;

    public VersionCheckerConfig(@Nonnull File file) {
        AELog.warn("The version checker has been removed, you should not use it !", new Object[0]);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkState((!file.isDirectory() ? 1 : 0) != 0);
        this.config = new Configuration(file);
        this.isEnabled = this.config.getBoolean("enabled", "general", true, "If true, the version checker is enabled. Acts as a master switch.");
        this.lastCheck = this.config.getString("lastCheck", "cache", "0", "The number of milliseconds since January 1, 1970, 00:00:00 GMT of the last successful check.");
        this.interval = this.config.getInt("interval", "cache", 24, 0, 168, "Waits as many hours, until it checks again.");
        this.level = this.config.getString("level", "channel", "Beta", "Determines the channel level which should be checked for updates. Can be either Stable, Beta or Alpha.");
        this.shouldNotifyPlayer = this.config.getBoolean("notify", "client", true, "If true, the player is getting a notification, that a new version is available.");
        this.shouldPostChangelog = this.config.getBoolean("changelog", "client", true, "If true, the player is getting a notification including changelog. Only happens if notification are enabled.");
    }

    public boolean isVersionCheckingEnabled() {
        return false;
    }

    public String lastCheck() {
        return this.lastCheck;
    }

    public void updateLastCheck() {
        Date now = new Date();
        long nowInMs = now.getTime();
        String nowAsString = Long.toString(nowInMs);
        this.config.get("cache", "lastCheck", "0").set(nowAsString);
        this.config.save();
    }

    public int interval() {
        return this.interval;
    }

    public String level() {
        return this.level;
    }

    public boolean shouldNotifyPlayer() {
        return this.shouldNotifyPlayer;
    }

    public boolean shouldPostChangelog() {
        return this.shouldPostChangelog;
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

