/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.IStackSrc;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public final class DamagedItemDefinition
implements IItemDefinition {
    private static final ItemTransformer ITEM_TRANSFORMER = new ItemTransformer();
    private final Optional<IStackSrc> source;

    public DamagedItemDefinition(@Nonnull IStackSrc source) {
        Preconditions.checkNotNull((Object)source);
        this.source = source.isEnabled() ? Optional.of((Object)source) : Optional.absent();
    }

    @Override
    public Optional<Item> maybeItem() {
        return this.source.transform((Function)ITEM_TRANSFORMER);
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.source.transform((Function)new ItemStackTransformer(stackSize));
    }

    @Override
    public boolean isEnabled() {
        return this.source.isPresent();
    }

    @Override
    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack == null) {
            return false;
        }
        return this.isEnabled() && comparableStack.func_77973_b() == ((IStackSrc)this.source.get()).getItem() && comparableStack.func_77960_j() == ((IStackSrc)this.source.get()).getDamage();
    }

    @Override
    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    private static class ItemTransformer
    implements Function<IStackSrc, Item> {
        private ItemTransformer() {
        }

        public Item apply(IStackSrc input) {
            return input.getItem();
        }
    }

    private static class ItemStackTransformer
    implements Function<IStackSrc, ItemStack> {
        private final int stackSize;

        public ItemStackTransformer(int stackSize) {
            Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
            this.stackSize = stackSize;
        }

        public ItemStack apply(IStackSrc input) {
            return input.stack(this.stackSize);
        }
    }
}

