/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.PatternHelper;
import appeng.util.item.AEItemStack;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class FluidPatternDetails
implements ICraftingPatternDetails,
Comparable<FluidPatternDetails> {
    private final ItemStack patternStack;
    private IAEItemStack patternStackAe;
    private IAEItemStack[] inputs = null;
    private IAEItemStack[] inputsCond = null;
    private IAEItemStack[] outputs = null;
    private IAEItemStack[] outputsCond = null;
    private int priority = 0;
    private int combine = 0;
    private int beSubstitute = 0;

    public FluidPatternDetails(ItemStack stack) {
        this.patternStack = stack;
        this.patternStackAe = (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)stack));
    }

    public boolean canBeSubstitute() {
        return this.beSubstitute != 0;
    }

    public void setCanBeSubstitute(int beSubstitute) {
        this.beSubstitute = beSubstitute;
    }

    public ItemStack getPattern() {
        return this.patternStack;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setCombine(int combine) {
        this.combine = combine;
    }

    public int getCombine() {
        return this.combine;
    }

    public boolean isCraftable() {
        return false;
    }

    public boolean canSubstitute() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return FluidPatternDetails.checkInitialized(this.inputs);
    }

    public IAEItemStack[] getCondensedInputs() {
        return FluidPatternDetails.checkInitialized(this.inputsCond);
    }

    public boolean setInputs(IAEItemStack[] inputs) {
        IAEItemStack[] condensed = FluidPatternDetails.condenseStacks(inputs);
        if (condensed.length == 0) {
            return false;
        }
        this.inputs = inputs;
        this.inputsCond = condensed;
        return true;
    }

    public IAEItemStack[] getOutputs() {
        return FluidPatternDetails.checkInitialized(this.outputs);
    }

    public IAEItemStack[] getCondensedOutputs() {
        return FluidPatternDetails.checkInitialized(this.outputsCond);
    }

    public boolean setOutputs(IAEItemStack[] outputs) {
        IAEItemStack[] condensed = FluidPatternDetails.condenseStacks(outputs);
        if (condensed.length == 0) {
            return false;
        }
        this.outputs = (IAEItemStack[])Arrays.stream(outputs).filter(Objects::nonNull).toArray(IAEItemStack[]::new);
        this.outputsCond = condensed;
        return true;
    }

    private static IAEItemStack[] condenseStacks(IAEItemStack[] stacks) {
        return PatternHelper.convertToCondensedList((IAEItemStack[])stacks);
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    private static <T> T checkInitialized(@Nullable T value) {
        if (value == null) {
            throw new IllegalStateException("Pattern is not initialized!");
        }
        return value;
    }

    public int hashCode() {
        return this.patternStackAe.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FluidPatternDetails && this.patternStackAe.equals(((FluidPatternDetails)obj).patternStackAe);
    }

    @Override
    public int compareTo(FluidPatternDetails o) {
        return Integer.compare(o.priority, this.priority);
    }

    public ItemStack writeToStack() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Inputs", (NBTBase)FluidPatternDetails.writeStackArray(FluidPatternDetails.checkInitialized(this.inputs)));
        tag.func_74782_a("Outputs", (NBTBase)FluidPatternDetails.writeStackArray(FluidPatternDetails.checkInitialized(this.outputs)));
        tag.func_74782_a("in", (NBTBase)FluidPatternDetails.writeStackArray(FluidPatternDetails.checkInitialized(this.inputs)));
        tag.func_74782_a("out", (NBTBase)FluidPatternDetails.writeStackArray(FluidPatternDetails.checkInitialized(this.outputs)));
        tag.func_74768_a("combine", this.getCombine());
        tag.func_74757_a("beSubstitute", this.canBeSubstitute());
        this.patternStack.func_77982_d(tag);
        this.patternStackAe = (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)this.patternStack));
        return this.patternStack;
    }

    public static NBTTagList writeStackArray(IAEItemStack[] stacks) {
        NBTTagList listTag = new NBTTagList();
        for (IAEItemStack stack : stacks) {
            NBTTagCompound stackTag = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(stackTag);
            }
            listTag.func_74742_a((NBTBase)stackTag);
        }
        return listTag;
    }

    public boolean readFromStack() {
        if (!this.patternStack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = Objects.requireNonNull(this.patternStack.func_77978_p());
        return this.setInputs(FluidPatternDetails.readStackArray(tag.func_150295_c("in", 10))) && this.setOutputs(FluidPatternDetails.readStackArray(tag.func_150295_c("out", 10)));
    }

    public static IAEItemStack[] readStackArray(NBTTagList listTag) {
        IAEItemStack[] stacks = new IAEItemStack[listTag.func_74745_c()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = AEItemStack.loadItemStackFromNBT((NBTTagCompound)listTag.func_150305_b(i));
        }
        return stacks;
    }
}

