/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.InventoryAdventure;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidTank;

public class InventoryCoalJetpack
extends InventoryAdventure {
    private final FluidTank waterTank = new FluidTank(6000);
    private final FluidTank steamTank = new FluidTank(12000);
    private boolean inUse = false;
    private boolean status = false;
    private boolean boiling = false;
    private boolean leaking = false;
    private int temperature = 25;
    private int burnTicks = 0;
    private int coolTicks = 5000;
    private int currentItemBurnTime = 0;

    public InventoryCoalJetpack(ItemStack jetpack) {
        super(jetpack, 3);
        this.detectAndConvertFromOldNBTFormat(this.containerStack.field_77990_d);
        this.func_70295_k_();
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getSteamTank() {
        return this.steamTank;
    }

    @Override
    public FluidTank[] getTanksArray() {
        return new FluidTank[]{this.waterTank, this.steamTank};
    }

    @Override
    public int[] getSlotsOnClosing() {
        return new int[]{0, 1};
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        NBTTagCompound jetpackTag = compound.func_74775_l("wearableData");
        this.setInventoryFromTagList(jetpackTag.func_150295_c("inventory", 10));
        this.waterTank.readFromNBT(jetpackTag.func_74775_l("waterTank"));
        this.steamTank.readFromNBT(jetpackTag.func_74775_l("steamTank"));
        this.inUse = jetpackTag.func_74767_n("inUse");
        this.status = jetpackTag.func_74767_n("status");
        this.boiling = jetpackTag.func_74767_n("boiling");
        this.leaking = jetpackTag.func_74767_n("leaking");
        this.temperature = jetpackTag.func_74762_e("temperature");
        this.burnTicks = jetpackTag.func_74762_e("burnTicks");
        this.coolTicks = jetpackTag.func_74762_e("coolTicks");
        this.currentItemBurnTime = jetpackTag.func_74762_e("currentBurn");
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound jetpackTag = new NBTTagCompound();
        jetpackTag.func_74782_a("inventory", (NBTBase)this.getInventoryTagList());
        jetpackTag.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        jetpackTag.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        jetpackTag.func_74757_a("inUse", this.inUse);
        jetpackTag.func_74757_a("status", this.status);
        jetpackTag.func_74757_a("boiling", this.boiling);
        jetpackTag.func_74757_a("leaking", this.leaking);
        jetpackTag.func_74768_a("temperature", this.temperature);
        jetpackTag.func_74768_a("burnTicks", this.burnTicks);
        jetpackTag.func_74768_a("coolTicks", this.coolTicks);
        jetpackTag.func_74768_a("currentBurn", this.currentItemBurnTime);
        compound.func_74782_a("wearableData", (NBTBase)jetpackTag);
    }

    @Override
    public boolean updateTankSlots() {
        boolean changesMade = false;
        while (InventoryActions.transferContainerTank(this, this.getWaterTank(), 0)) {
            changesMade = true;
        }
        return changesMade;
    }

    @Override
    public void dirtyTanks() {
        this.getWearableCompound().func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        this.getWearableCompound().func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
    }

    public void dirtyBoiler() {
        NBTTagCompound jetpackTag = this.getWearableCompound();
        jetpackTag.func_74757_a("boiling", this.boiling);
        jetpackTag.func_74757_a("leaking", this.leaking);
        jetpackTag.func_74768_a("temperature", this.temperature);
        jetpackTag.func_74768_a("burnTicks", this.burnTicks);
        jetpackTag.func_74768_a("coolTicks", this.coolTicks);
        jetpackTag.func_74768_a("currentBurn", this.currentItemBurnTime);
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTicks * scale / this.currentItemBurnTime;
    }

    public int consumeFuel() {
        int result = 0;
        if (this.isFuel(this.inventory[2])) {
            result = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[2]);
            --this.inventory[2].field_77994_a;
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = this.inventory[2].func_77973_b().getContainerItem(this.inventory[2]);
            }
            this.dirtyInventory();
        }
        return result;
    }

    private boolean isFuel(ItemStack stack) {
        return TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public int getIncreasingFactor() {
        if (this.temperature < 50) {
            return 20;
        }
        if (this.temperature < 100) {
            return 15;
        }
        if (this.temperature < 150) {
            return 10;
        }
        return 5;
    }

    public int getDecreasingFactor() {
        if (this.temperature > 150) {
            return 40;
        }
        if (this.temperature > 100) {
            return 80;
        }
        if (this.temperature > 50) {
            return 120;
        }
        return 5;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public boolean isBoiling() {
        return this.boiling;
    }

    public void setBoiling(boolean boiling) {
        this.boiling = boiling;
    }

    public boolean isLeaking() {
        return this.leaking;
    }

    public void setLeaking(boolean leaking) {
        this.leaking = leaking;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getBurnTicks() {
        return this.burnTicks;
    }

    public void setBurnTicks(int burnTicks) {
        this.burnTicks = burnTicks;
    }

    public int getCoolTicks() {
        return this.coolTicks;
    }

    public void setCoolTicks(int coolTicks) {
        this.coolTicks = coolTicks;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    private void detectAndConvertFromOldNBTFormat(NBTTagCompound compound) {
        if (compound == null || !compound.func_74764_b("jetpackData")) {
            return;
        }
        NBTTagCompound oldJetpackTag = compound.func_74775_l("jetpackData");
        NBTTagList oldItems = oldJetpackTag.func_150295_c("inventory", 10);
        this.waterTank.readFromNBT(oldJetpackTag.func_74775_l("waterTank"));
        this.steamTank.readFromNBT(oldJetpackTag.func_74775_l("steamTank"));
        NBTTagCompound newJetpackTag = new NBTTagCompound();
        newJetpackTag.func_74782_a("inventory", (NBTBase)oldItems);
        newJetpackTag.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        newJetpackTag.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("wearableData", (NBTBase)newJetpackTag);
        compound.func_82580_o("jetpackData");
    }
}

