/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.common.Constants;
import com.darkona.adventurebackpack.inventory.ContainerAdventure;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.InventoryCoalJetpack;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.inventory.SlotFluidWater;
import com.darkona.adventurebackpack.inventory.SlotFuel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidTank;

public class ContainerJetpack
extends ContainerAdventure {
    private static final int JETPACK_INV_START = 36;
    private static final int JETPACK_FUEL_START = 38;
    private ItemStack fuelStack;

    public ContainerJetpack(EntityPlayer player, InventoryCoalJetpack jetpack, Constants.Source source) {
        super(player, jetpack, source);
        this.makeSlots(player.field_71071_by);
        this.inventory.func_70295_k_();
    }

    private void makeSlots(InventoryPlayer invPlayer) {
        this.bindPlayerInventory(invPlayer, 8, 84);
        this.func_75146_a(new SlotFluidWater(this.inventory, 0, 30, 22));
        this.func_75146_a(new SlotFluidWater(this.inventory, 1, 30, 52));
        this.func_75146_a(new SlotFuel(this.inventory, 2, 77, 64));
    }

    @Override
    protected boolean detectItemChanges() {
        ItemStack[] inv = this.inventory.getInventory();
        if (inv[2] != this.fuelStack) {
            this.fuelStack = inv[2];
            return true;
        }
        return false;
    }

    @Override
    public boolean transferStackToPack(ItemStack stack) {
        if (SlotFluid.isContainer(stack)) {
            FluidTank waterTank = ((InventoryCoalJetpack)this.inventory).getWaterTank();
            ItemStack stackOut = this.func_75139_a(37).func_75211_c();
            boolean isWaterTankEmpty = SlotFluid.isEmpty(waterTank);
            boolean suitableToTank = SlotFluid.isEqualAndCanFit(stack, waterTank);
            boolean areSameType = InventoryActions.areContainersOfSameType(stack, stackOut);
            if (SlotFluid.isFilled(stack) ? !(stackOut != null && !areSameType || !SlotFluidWater.isValidItem(stack) || !isWaterTankEmpty && !suitableToTank) : SlotFluid.isEmpty(stack) && (stackOut == null || areSameType) && SlotFluidWater.isValidItem(stack) && !isWaterTankEmpty) {
                return this.mergeBucket(stack);
            }
        } else if (SlotFuel.isValidItem(stack)) {
            return this.mergeFuel(stack);
        }
        return true;
    }

    private boolean mergeBucket(ItemStack stack) {
        return this.func_75135_a(stack, 36, 37, false);
    }

    private boolean mergeFuel(ItemStack stack) {
        return this.func_75135_a(stack, 38, 39, false);
    }
}

