/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

abstract class TileAdventure
extends TileEntity
implements IInventoryTanks {
    protected final ItemStack[] inventory;

    protected TileAdventure(int inventorySize) {
        this.inventory = new ItemStack[inventorySize];
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Nullable
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= quantity) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(quantity);
                this.dirtyInventory();
            }
        }
        return stack;
    }

    @Nullable
    public ItemStack func_70304_b(int slot) {
        for (int s : this.getSlotsOnClosing()) {
            if (slot != s) continue;
            return this.inventory[slot];
        }
        return null;
    }

    public void func_70299_a(int slot, @Nullable ItemStack stack) {
        this.setInventorySlotContentsNoSave(slot, stack);
        this.dirtyInventory();
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return this.func_145825_b() != null && !this.func_145825_b().isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        this.dirtyInventory();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public ItemStack decrStackSizeNoSave(int slot, int quantity) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= quantity) {
                this.setInventorySlotContentsNoSave(slot, null);
            } else {
                stack = stack.func_77979_a(quantity);
            }
        }
        return stack;
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, @Nullable ItemStack stack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        if (stack != null) {
            if (stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            if (stack.field_77994_a == 0) {
                stack = null;
            }
        }
        this.inventory[slot] = stack;
    }

    @Override
    public void dirtyInventory() {
        this.updateTankSlots();
        this.func_70296_d();
    }

    @Override
    @Deprecated
    public void dirtyTanks() {
        this.dirtyInventory();
    }

    protected void setInventoryFromTagList(NBTTagList items) {
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    protected NBTTagList getInventoryTagList() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        return items;
    }
}

