/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui.backgrounds;

import eu.usrv.yamcore.client.dynamicgui.elements.IGuiElement;
import eu.usrv.yamcore.client.dynamicgui.skins.BackgroundSkin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public abstract class GUIBackgroundProvider
implements IGuiElement {
    protected final List<IGuiElement> components = new ArrayList<IGuiElement>();
    protected final int width;
    protected final int height;
    protected final BackgroundSkin skin;

    public GUIBackgroundProvider(BackgroundSkin skin, int width, int height) {
        this.width = width;
        this.height = height;
        this.skin = skin;
        this.addComponents();
    }

    public GUIBackgroundProvider(int width, int height) {
        this(BackgroundSkin.defualt, width, height);
    }

    protected abstract void addComponents();

    @Override
    public final int getElementHeight() {
        return this.height;
    }

    @Override
    public final int getElementWidth() {
        return this.width;
    }

    @Override
    public final int getElementY() {
        return 0;
    }

    @Override
    public final int getElementX() {
        return 0;
    }

    @Override
    public void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        for (IGuiElement el : this.components) {
            el.drawBackground(mc, mouseX, mouseY);
        }
    }

    @Override
    public void drawForeground(Minecraft mc, int mouseX, int mouseY) {
        for (IGuiElement el : this.components) {
            el.drawForeground(mc, mouseX, mouseY);
        }
    }
}

