/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.NameMetaPair;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpSwamp
extends IWorldTickWarpEvent {
    public WarpSwamp(int minWarp) {
        super("biomeSwamp", minWarp, world -> 256 + world.field_73012_v.nextInt(256));
    }

    @Override
    public boolean canDo(World world, EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        BlockCoord target = RandomBlockHelper.randomBlock(world, player, 8, block -> MiscHelper.hasNonSolidNeighbor(world, block));
        if (target == null) {
            return 0;
        }
        boolean grown = false;
        if (target.getBlock(world) == Blocks.field_150355_j) {
            if (target.offset(1).isAir((IBlockAccess)world) && world.func_147465_d(target.x, target.y, target.z, Blocks.field_150392_bi, 0, 3)) {
                grown = true;
            }
        } else if (target.getBlock(world) == Blocks.field_150345_g) {
            ((BlockSapling)target.getBlock(world)).func_149878_d(world, target.x, target.y, target.z, world.field_73012_v);
            grown = true;
        } else if (target.getBlock(world).func_149688_o() == Material.field_151584_j || target.getBlock(world) == Blocks.field_150364_r || target.getBlock(world) == Blocks.field_150363_s) {
            for (int j = 0; j < 6; ++j) {
                int side = 2 + world.field_73012_v.nextInt(4);
                if (!Blocks.field_150395_bd.func_149707_d(world, target.x, target.y, target.z, side) || !target.offset(side).isAir((IBlockAccess)world)) continue;
                world.func_147465_d(target.x, target.y, target.z, Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[side]], 3);
                grown = true;
                break;
            }
        } else if (world.field_73012_v.nextBoolean() && target.getBlock(world).canSustainPlant((IBlockAccess)world, target.x, target.y, target.z, ForgeDirection.UP, (IPlantable)Blocks.field_150345_g)) {
            if (world.field_73012_v.nextBoolean()) {
                if (target.offset(1).isAir((IBlockAccess)world) || target.getBlock(world) instanceof IPlantable && target.getBlock(world) != Blocks.field_150345_g) {
                    world.func_147465_d(target.x, target.y, target.z, Blocks.field_150345_g, world.field_73012_v.nextInt(6), 3);
                }
            } else if (world.field_73012_v.nextBoolean()) {
                if (target.offset(1).isAir((IBlockAccess)world) && target.offset(0).getBlock(world) instanceof IGrowable) {
                    ((IGrowable)target.getBlock(world)).func_149853_b(world, world.field_73012_v, target.x, target.y, target.z);
                }
            } else if (target.offset(1).isAir((IBlockAccess)world) && target.offset(0).getBlock(world) == Blocks.field_150349_c) {
                world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 2, 3);
            }
            grown = true;
        } else if (world.field_73012_v.nextBoolean() && MiscHelper.canTurnToSwampWater(world, target)) {
            if (target.copy().offset(1).getBlock(world) == Blocks.field_150364_r || target.copy().offset(1).getBlock(world) == Blocks.field_150363_s) {
                world.func_147465_d(target.x, target.y, target.z, target.copy().offset(1).getBlock(world), target.copy().offset(1).getMeta(world), 3);
            } else {
                world.func_147465_d(target.x, target.y, target.z, Blocks.field_150355_j, 0, 3);
            }
            grown = true;
        } else if (WarpHandler.decayMappings.containsKey(new NameMetaPair(target.getBlock(world), target.getMeta(world))) && target.getBlock(world).func_149662_c() && target.getBlock(world) != Blocks.field_150364_r && target.getBlock(world) != Blocks.field_150363_s && target.getBlock(world) != Blocks.field_150346_d && target.getBlock(world) != Blocks.field_150349_c) {
            if (target.copy().offset(1).getBlock(world).func_149662_c()) {
                world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 0, 3);
            } else if (world.field_73012_v.nextBoolean()) {
                world.func_147465_d(target.x, target.y, target.z, (Block)Blocks.field_150349_c, 0, 3);
            } else {
                world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 2, 3);
            }
            grown = true;
        }
        if (grown) {
            return 1;
        }
        return 0;
    }
}

