/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFDarkForestBiomeDecorator;
import twilightforest.entity.EntityTFKingSpider;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMistWolf;
import twilightforest.entity.EntityTFSkeletonDruid;

public class TFBiomeDarkForest
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 20;
    Random monsterRNG;
    ArrayList<BiomeGenBase.SpawnListEntry> emptyList = new ArrayList();

    public TFBiomeDarkForest(int i) {
        super(i);
        this.field_76750_F = 0.7f;
        this.field_76751_G = 0.8f;
        this.getTFBiomeDecorator().canopyPerChunk = 5.5f;
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(-99);
        this.getTFBiomeDecorator().setFlowersPerChunk(-99);
        this.getTFBiomeDecorator().setMushroomsPerChunk(2);
        this.getTFBiomeDecorator().setDeadBushPerChunk(10);
        this.field_76748_D = 0.05f;
        this.field_76749_E = 0.05f;
        this.monsterRNG = new Random();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 5, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 5, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTFMistWolf.class, 10, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTFSkeletonDruid.class, 10, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTFKingSpider.class, 10, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 1, 1, 1));
        this.field_76760_I.field_76808_K = false;
    }

    @Override
    public BiomeDecorator func_76729_a() {
        return new TFDarkForestBiomeDecorator();
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return new WorldGenShrub(3, 0);
        }
        if (random.nextInt(8) == 0) {
            return this.birchGen;
        }
        return this.field_76757_N;
    }

    public int func_150558_b(int x, int y, int z) {
        double var1 = MathHelper.func_76131_a((float)this.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerGrass.func_77480_a((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public int func_150571_c(int x, int y, int z) {
        double var1 = MathHelper.func_76131_a((float)this.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerFoliage.func_77470_a((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public List<BiomeGenBase.SpawnListEntry> func_76747_a(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            return this.monsterRNG.nextInt(20) == 0 ? this.field_76761_J : this.emptyList;
        }
        return par1EnumCreatureType == EnumCreatureType.creature ? this.field_76762_K : (par1EnumCreatureType == EnumCreatureType.waterCreature ? this.field_76755_L : (par1EnumCreatureType == EnumCreatureType.ambient ? this.field_82914_M : null));
    }

    public boolean func_76736_e() {
        return true;
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressHydra;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.field_72995_K && world.func_72820_D() % 60L == 0L) {
            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
            if (world.field_73012_v.nextInt(4) == 0) {
                TFFeature.tfStronghold.trySpawnHintMonster(world, player);
            }
        }
    }
}

