/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.common.CommonProxy;

public class MessageSlotSync
implements IMessage {
    int dim;
    int playerid;
    boolean[] hidden;

    public MessageSlotSync() {
    }

    public MessageSlotSync(EntityPlayer player, boolean ... hide) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.hidden = hide;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.playerid);
        buf.writeInt(this.hidden.length);
        for (boolean b : this.hidden) {
            buf.writeBoolean(b);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.playerid = buf.readInt();
        int l = buf.readInt();
        this.hidden = new boolean[l];
        for (int b = 0; b < l; ++b) {
            this.hidden[b] = buf.readBoolean();
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageSlotSync, IMessage> {
        public IMessage onMessage(MessageSlotSync message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerid);
            if (player instanceof EntityPlayer) {
                CommonProxy.hiddenSlots.put(player.func_70005_c_(), message.hidden);
            }
            return null;
        }
    }
}

