/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data.chest;

import com.google.common.collect.Lists;
import dmillerw.tml.TooMuchLoot;
import dmillerw.tml.data.LootLoadingMode;
import dmillerw.tml.data.chest.ChestLootItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ChestLootCategory {
    public String category;
    public LootLoadingMode loading_mode = LootLoadingMode.OVERRIDE;
    public int count_min;
    public int count_max;
    public ChestLootItem[] loot;

    public static ChestLootCategory fromChestGenHooks(String category) {
        ChestGenHooks chestGenHooks = ChestGenHooks.getInfo((String)category);
        ChestLootCategory lootCategory = new ChestLootCategory();
        lootCategory.category = category;
        lootCategory.count_min = chestGenHooks.getMin();
        lootCategory.count_max = chestGenHooks.getMax();
        ArrayList lootList = Lists.newArrayList();
        try {
            for (WeightedRandomChestContent item : (List)TooMuchLoot.contents.get(chestGenHooks)) {
                lootList.add(ChestLootItem.fromChestContent(item));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        lootCategory.loot = lootList.toArray(new ChestLootItem[lootList.size()]);
        return lootCategory;
    }

    public ChestLootCategory checkCountValues() {
        if (this.count_min == -1 && this.count_max == -1) {
            this.count_min = 1;
            this.count_max = 1;
        } else if (this.count_min == -1) {
            this.count_min = this.count_max;
        } else if (this.count_max == -1) {
            this.count_max = this.count_min;
        }
        return this;
    }

    public ChestGenHooks toChestGenHooks() {
        WeightedRandomChestContent[] chestContents = new WeightedRandomChestContent[this.loot.length];
        for (int i = 0; i < this.loot.length; ++i) {
            chestContents[i] = this.loot[i].toChestContent();
        }
        return new ChestGenHooks(this.category, chestContents, this.count_min, this.count_max);
    }
}

