/*
 * Decompiled with CFR 0.152.
 */
package tb.api;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.IExtendedEntityProperties;
import tb.utils.TBUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.research.ScanManager;

public class RevolverUpgrade {
    public static RevolverUpgrade[] allUpgrades = new RevolverUpgrade[24];
    public static Hashtable<String, Integer> textToIntMapping = new Hashtable();
    public static Hashtable<Integer, String> intToTextMapping = new Hashtable();
    public int maxLevel;
    public final int id;
    public final String text_id;
    public int instability;
    public static final ResourceLocation eldritchTextures = new ResourceLocation("thaumicbases", "textures/items/revolver/revolverDarkMetalEldritch.png");
    public static final ResourceLocation primalTextures = new ResourceLocation("thaumicbases", "textures/items/revolver/revolverGunPrimalUV.png");
    public static final ResourceLocation taintedTextures = new ResourceLocation("thaumicbases", "textures/items/revolver/revolverGunTaintedUV.png");
    public static final ResourceLocation voidTextures = new ResourceLocation("thaumicbases", "textures/items/revolver/revolverHandleVoidUV.png");
    public final ArrayList<RevolverUpgrade> conflicts = new ArrayList();
    public static final RevolverUpgrade power = new RevolverUpgrade(0, "POWER").setMaxLevel(5).setInstabilityPerLevel(2);
    public static final RevolverUpgrade accuracy = new RevolverUpgrade(1, "ACCURACY").setMaxLevel(3).setInstabilityPerLevel(1);
    public static final RevolverUpgrade silver = new RevolverUpgrade(2, "SILVER").setMaxLevel(5).setInstabilityPerLevel(3);
    public static final RevolverUpgrade poisoned = new RevolverUpgrade(3, "POISONED").setMaxLevel(3).setInstabilityPerLevel(1);
    public static final RevolverUpgrade atropodsBane = new RevolverUpgrade(4, "BANE_OF_ATROPODS").setMaxLevel(5).setInstabilityPerLevel(3);
    public static final RevolverUpgrade eldritchBane = new RevolverUpgrade(5, "BANE_OF_ELDRITCH").setMaxLevel(5).setInstabilityPerLevel(3);
    public static final RevolverUpgrade piercig = new RevolverUpgrade(6, "PIERCING").setMaxLevel(1).setInstabilityPerLevel(12);
    public static final RevolverUpgrade dueling = new RevolverUpgrade(7, "DUELING").setMaxLevel(5).setInstabilityPerLevel(3);
    public static final RevolverUpgrade tainted = new RevolverUpgrade(8, "TAINTED").setMaxLevel(3).setInstabilityPerLevel(5);
    public static final RevolverUpgrade primal = new RevolverUpgrade(9, "PRIMAL").setMaxLevel(1).setInstabilityPerLevel(12);
    public static final RevolverUpgrade speed = new RevolverUpgrade(10, "SPEED").setMaxLevel(5).setInstabilityPerLevel(2);
    public static final RevolverUpgrade efficiency = new RevolverUpgrade(11, "EFFICIENCY").setMaxLevel(5).setInstabilityPerLevel(4);
    public static final RevolverUpgrade eldritch = new RevolverUpgrade(12, "ELDRITCH").setMaxLevel(2).setInstabilityPerLevel(7);
    public static final RevolverUpgrade uvoid = new RevolverUpgrade(13, "VOID").setMaxLevel(3).setInstabilityPerLevel(4);
    public static final RevolverUpgrade knowledge = new RevolverUpgrade(14, "KNOWLEDGE").setMaxLevel(5).setInstabilityPerLevel(1);
    public static final RevolverUpgrade heavy = new RevolverUpgrade(15, "HEAVY").setMaxLevel(5).setInstabilityPerLevel(1);

    public RevolverUpgrade(int id, String name) {
        this.text_id = name;
        this.id = id;
        if (id < allUpgrades.length && allUpgrades[id] != null) {
            FMLLog.warning((String)("[TB]Attempting to register revolver upgrade " + name + "[" + id + "], but the ID is already occupied by " + RevolverUpgrade.allUpgrades[id].text_id + "[" + RevolverUpgrade.allUpgrades[id].id + "], ignoring."), (Object[])new Object[0]);
            return;
        }
        if (id >= allUpgrades.length) {
            RevolverUpgrade[] copied = new RevolverUpgrade[allUpgrades.length + 1];
            System.arraycopy(allUpgrades, 0, copied, 0, allUpgrades.length);
            allUpgrades = copied;
        }
        RevolverUpgrade.allUpgrades[id] = this;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("revolverUpgrade." + this.text_id + ".name"));
    }

    public int getID() {
        return this.id;
    }

    public String getTextID() {
        return this.text_id;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public RevolverUpgrade setMaxLevel(int i) {
        this.maxLevel = i;
        return this;
    }

    public boolean conflictsWith(RevolverUpgrade upgrade) {
        return this.conflicts.contains(upgrade);
    }

    public RevolverUpgrade addConflict(RevolverUpgrade ... upgrade) {
        for (RevolverUpgrade rUpgr : upgrade) {
            if (!this.conflicts.contains(rUpgr)) {
                this.conflicts.add(rUpgr);
            }
            if (rUpgr.conflicts.contains(this)) continue;
            rUpgr.conflicts.add(this);
        }
        return this;
    }

    public int getInstabilityForLevel(int level) {
        return this.instability * level;
    }

    public RevolverUpgrade setInstabilityPerLevel(int newValue) {
        this.instability = newValue;
        return this;
    }

    public float modifyDamage_start(EntityLivingBase base, ItemStack revolver, float currentModification, int modLevel) {
        if (base != null) {
            if (this == power) {
                return (float)((double)currentModification * Math.pow(1.1f, modLevel));
            }
            if (this == silver && (base.func_70668_bt() == EnumCreatureAttribute.UNDEAD || this.isBMEntity(base) || base instanceof EntityPlayer && this.isWerewolf((EntityPlayer)EntityPlayer.class.cast(base)))) {
                return (float)((double)currentModification * Math.pow(1.2f, modLevel));
            }
            if (this == atropodsBane && base.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                return (float)((double)currentModification * Math.pow(1.2f, modLevel));
            }
            if (this == eldritchBane && (base instanceof IEldritchMob || base instanceof EntityEnderman)) {
                return (float)((double)currentModification * Math.pow(1.2f, modLevel));
            }
            if (this == dueling && base instanceof EntityPlayer) {
                return (float)((double)currentModification * Math.pow(1.2f, modLevel));
            }
            if (this == eldritch) {
                if (base instanceof IBossDisplayData) {
                    return (float)((double)currentModification * Math.pow(1.3f, modLevel));
                }
                return currentModification / 1.2f;
            }
            if (this == piercig) {
                return currentModification * 1.1f;
            }
            if (this == tainted) {
                if (base instanceof ITaintedMob) {
                    return currentModification / 1.6f;
                }
                return (float)((double)currentModification * Math.pow(1.2f, modLevel));
            }
        }
        return currentModification;
    }

    public float modifyDamage_end(EntityLivingBase base, ItemStack revolver, float currentModification, int modLevel) {
        if (this == primal) {
            return currentModification * 2.0f;
        }
        return currentModification;
    }

    public boolean afterhit(EntityLivingBase base, EntityPlayer user, ItemStack revolver, float damageDealt, int modLevel) {
        AspectList aspectsCompound;
        if (this == tainted && base.field_70170_p.field_73012_v.nextDouble() <= 0.1) {
            base.func_70690_d(new PotionEffect(Config.potionTaintPoisonID, 200, 1, true));
        }
        if (this == poisoned) {
            base.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1, true));
        }
        if (this == knowledge && base.func_110143_aJ() <= 0.0f && user != null && user.field_70170_p.field_73012_v.nextInt(Math.max(1, 7 - modLevel)) == 0 && (aspectsCompound = ScanManager.generateEntityAspects((Entity)base)) != null && aspectsCompound.size() > 0) {
            Aspect[] al = aspectsCompound.getAspects();
            for (int i = 0; i < al.length; ++i) {
                TBUtils.addAspectToKnowledgePool(user, al[i], (short)1);
                if (user.field_70170_p.field_73012_v.nextBoolean()) break;
            }
        }
        return this != piercig;
    }

    public boolean bulletNoclip(EntityPlayer user, ItemStack revolver, int modLevel) {
        return this == primal;
    }

    public int modifyShots(EntityPlayer user, ItemStack revolver, int modLevel, int originalLevel, boolean hasPrimal) {
        if (this == primal) {
            return -1;
        }
        if (this == efficiency) {
            return hasPrimal ? (modLevel == 5 ? 1 : -1) : originalLevel + modLevel;
        }
        return originalLevel;
    }

    public double modifySpeed(EntityPlayer user, ItemStack revolver, float origSpeed, int modLevel) {
        if (this == speed) {
            return (double)origSpeed * Math.pow(1.09f, modLevel);
        }
        return origSpeed;
    }

    public ResourceLocation getOverridePartTexture(ItemStack revolver, int part, int level) {
        if (this == eldritch && part == 2) {
            return eldritchTextures;
        }
        if (this == primal && part == 3) {
            return primalTextures;
        }
        if (this == tainted && part == 3) {
            return taintedTextures;
        }
        if (this == uvoid && part == 0) {
            return voidTextures;
        }
        return null;
    }

    public boolean isBMEntity(EntityLivingBase base) {
        if (Loader.isModLoaded((String)"AWWayofTime")) {
            try {
                Class<?> demonClass = Class.forName("WayofTime.alchemicalWizardry.common.IDemon");
                if (demonClass.isInstance(base)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isWerewolf(EntityPlayer p) {
        if (Loader.isModLoaded((String)"witchery") && p.getExtendedProperties("WitcheryExtendedPlayer") != null) {
            IExtendedEntityProperties props = p.getExtendedProperties("WitcheryExtendedPlayer");
            NBTTagCompound tag = new NBTTagCompound();
            props.saveNBTData(tag);
            return tag.func_74775_l("WitcheryExtendedPlayer").func_74762_e("WerewolfLevel") > 0 || tag.func_74762_e("WerewolfLevel") > 0;
        }
        return false;
    }

    public static void initConflictingMappings() {
        power.addConflict(silver, atropodsBane, eldritchBane, dueling, eldritch);
        silver.addConflict(atropodsBane, eldritchBane, dueling, eldritch);
        atropodsBane.addConflict(eldritchBane, dueling, eldritch);
        eldritchBane.addConflict(dueling, eldritch);
        dueling.addConflict(eldritch);
        accuracy.addConflict(speed, efficiency);
        speed.addConflict(efficiency);
        poisoned.addConflict(primal, tainted, knowledge);
        primal.addConflict(tainted, knowledge);
        tainted.addConflict(knowledge);
    }
}

