/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.util;

import java.util.Arrays;

public class DoubleCount {
    public static double[] distribute(double count, double ... probabilities) throws ArithmeticException {
        if (probabilities == null || Double.isNaN(count)) {
            return null;
        }
        if (count == 0.0) {
            return new double[probabilities.length];
        }
        if (Double.isInfinite(count)) {
            double[] doubles = new double[probabilities.length];
            Arrays.fill(doubles, count);
            return doubles;
        }
        switch (probabilities.length) {
            default: {
                int size = probabilities.length;
                double[] output = new double[size];
                double remaining = count;
                double previous = probabilities[--size];
                for (int i = size - 1; i >= 0; --i) {
                    double probability = probabilities[i];
                    double out = count * probability;
                    out -= DoubleCount.ulpSigned(out);
                    remaining -= out;
                    output[i] = out;
                    if (previous < probability) {
                        throw new ArithmeticException("Malformed probability order: " + Arrays.toString(probabilities));
                    }
                    previous = probability;
                    if (probability >= 1.0) break;
                }
                if (remaining * count < 0.0) {
                    DoubleCount.finishIt(size, output, remaining);
                } else {
                    output[size] = remaining;
                }
                return output;
            }
            case 1: {
                return new double[]{count};
            }
            case 0: 
        }
        return probabilities;
    }

    public static double ulpSigned(double number) {
        if (number == 0.0) {
            return 0.0;
        }
        return number > 0.0 ? Math.ulp(number) : -Math.ulp(number);
    }

    private static void finishIt(int size, double[] output, double remaining) {
        for (int i = size - 1; i >= 0; --i) {
            if (Math.abs(output[i]) >= Math.abs(remaining)) {
                int n = i;
                output[n] = output[n] - remaining;
                break;
            }
            remaining += output[i];
            output[i] = 0.0;
        }
    }

    public static double div(double count, double divisor) {
        if (count == 0.0 || Math.abs(divisor) == 1.0 || Math.abs(count) == Math.abs(divisor)) {
            return count / divisor;
        }
        double result = count / divisor;
        return result - DoubleCount.ulpSigned(result);
    }

    public static double mul(double count, double multiplier) {
        if (count == 0.0 || multiplier == 0.0 || Math.abs(multiplier) == 1.0 || Math.abs(count) == 1.0) {
            return count * multiplier;
        }
        double result = count * multiplier;
        return result - DoubleCount.ulpSigned(result);
    }

    public static double sub(double count, double value) {
        if (count == 0.0 || value == 0.0 || count == value) {
            return count - value;
        }
        double result = count - value;
        if (result == count || result == value) {
            return result;
        }
        return result - DoubleCount.ulpSigned(result);
    }

    public static double add(double count, double value) {
        if (count == 0.0 || value == 0.0 || count == -value) {
            return count + value;
        }
        double result = count + value;
        if (result == count || result == value) {
            return result;
        }
        return result - DoubleCount.ulpSigned(result);
    }
}

