/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.mechanics.dataTransport.QuantumDataPacket;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Rack;
import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_EM_switch;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_EM_computer
extends GT_MetaTileEntity_MultiblockBase_EM
implements ISurvivalConstructable {
    private final ArrayList<GT_MetaTileEntity_Hatch_Rack> eRacks = new ArrayList();
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static final String[] description;
    private static final IStructureDefinition<GT_MetaTileEntity_EM_computer> STRUCTURE_DEFINITION;
    protected Parameters.Group.ParameterIn overclock;
    protected Parameters.Group.ParameterIn overvolt;
    protected Parameters.Group.ParameterOut maxCurrentTemp;
    protected Parameters.Group.ParameterOut availableData;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> OC_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> OV_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> MAX_TEMP_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> COMPUTE_NAME;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> OC_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> OV_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> MAX_TEMP_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> COMPUTE_STATUS;

    public GT_MetaTileEntity_EM_computer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public GT_MetaTileEntity_EM_computer(String aName) {
        super(aName);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_computer(this.mName);
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.overclock = hatch_0.makeInParameter(0, 1.0, OC_NAME, OC_STATUS);
        this.overvolt = hatch_0.makeInParameter(1, 1.0, OV_NAME, OV_STATUS);
        this.maxCurrentTemp = hatch_0.makeOutParameter(0, 0.0, MAX_TEMP_NAME, MAX_TEMP_STATUS);
        this.availableData = hatch_0.makeOutParameter(1, 0.0, COMPUTE_NAME, COMPUTE_STATUS);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int offset;
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eRacks.clear();
        if (!this.structureCheck_EM("front", 1, 2, 0)) {
            return false;
        }
        if (!this.structureCheck_EM("cap", 1, 2, -1)) {
            return false;
        }
        int totalLen = 4;
        for (offset = -2; offset > -16 && this.structureCheck_EM("slice", 1, 2, offset); offset = (int)((byte)(offset - 1))) {
            totalLen = (byte)(totalLen + 1);
        }
        if (totalLen > 17) {
            return false;
        }
        if (!this.structureCheck_EM("cap", 1, 2, offset = (int)((byte)(offset + 1)))) {
            return false;
        }
        if (!this.structureCheck_EM("back", 1, 2, offset = (int)((byte)(offset - 1)))) {
            return false;
        }
        this.eCertainMode = (byte)Math.min(totalLen / 3, 5);
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eUncertainHatches.size() == 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("computation", this.availableData.get());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.availableData != null) {
            this.availableData.set(aNBT.func_74769_h("computation"));
            this.eAvailableData = (long)this.availableData.get();
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mMachine && !aBaseMetaTileEntity.isActive() && aTick % 20L == 12L) {
            double maxTemp = 0.0;
            for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack) || !((double)rack.heat > maxTemp)) continue;
                maxTemp = rack.heat;
            }
            this.maxCurrentTemp.set(maxTemp);
        }
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.parametrization.setToDefaults(false, true);
        this.eAvailableData = 0L;
        double maxTemp = 0.0;
        double overClockRatio = this.overclock.get();
        double overVoltageRatio = this.overvolt.get();
        if (Double.isNaN(overClockRatio) || Double.isNaN(overVoltageRatio)) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_computing");
        }
        if (this.overclock.getStatus((boolean)true).isOk && this.overvolt.getStatus((boolean)true).isOk) {
            float eut = (float)CommonValues.V[8] * (float)overVoltageRatio * (float)overClockRatio;
            if (!(eut < 2.1474836E9f)) {
                this.mEUt = -((int)CommonValues.V[8]);
                return CheckRecipeResultRegistry.POWER_OVERFLOW;
            }
            this.mEUt = -((int)eut);
            int thingsActive = 0;
            for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
                int rackComputation;
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
                if ((double)rack.heat > maxTemp) {
                    maxTemp = rack.heat;
                }
                if ((rackComputation = rack.tickComponents((float)overClockRatio, (float)overVoltageRatio)) > 0) {
                    this.eAvailableData += (long)rackComputation;
                    thingsActive = (short)(thingsActive + 4);
                }
                rack.getBaseMetaTileEntity().setActive(true);
            }
            for (GT_MetaTileEntity_Hatch_InputData di : this.eInputData) {
                if (di.q == null) continue;
                thingsActive = (short)(thingsActive + 1);
            }
            if (thingsActive > 0 && this.eCertainStatus == 0) {
                thingsActive = (short)(thingsActive + this.eOutputData.size());
                this.eAmpereFlow = 1 + (thingsActive >> 2);
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                this.maxCurrentTemp.set(maxTemp);
                this.availableData.set(this.eAvailableData);
                return SimpleCheckRecipeResult.ofSuccess((String)"computing");
            }
            this.eAvailableData = 0L;
            this.mEUt = -((int)CommonValues.V[8]);
            this.eAmpereFlow = 1L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.maxCurrentTemp.set(maxTemp);
            this.availableData.set(this.eAvailableData);
            return SimpleCheckRecipeResult.ofSuccess((String)"no_computing");
        }
        return SimpleCheckRecipeResult.ofFailure((String)"no_computing");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            QuantumDataPacket pack = new QuantumDataPacket(this.eAvailableData / (long)this.eOutputData.size()).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (GT_MetaTileEntity_Hatch_InputData hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            for (GT_MetaTileEntity_Hatch_OutputData o : this.eOutputData) {
                o.q = pack;
            }
        }
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.1")).addInfo(StatCollector.func_74838_a((String)"tt.keyword.Structure.StructureTooComplex")).addSeparator().beginVariableStructureBlock(2, 2, 4, 4, 5, 16, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.certain.tier.07.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), new int[]{1}).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataConnector"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), new int[]{1}).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.rack.tier.08.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyAdvComputerCasingExceptOuter"), new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.param.tier.05.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.Optional") + " " + StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), new int[]{2}).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), new int[]{1}).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), new int[]{1}).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return GT_MetaTileEntity_EM_switch.activitySound;
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eRacks) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(CommonValues.V[9]);
        }
    }

    @Override
    protected long getAvailableData_EM() {
        return this.eAvailableData;
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.eAvailableData = 0L;
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void afterRecipeCheckFailed() {
        super.afterRecipeCheckFailed();
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    public final boolean addRackToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Rack) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eRacks.add((GT_MetaTileEntity_Hatch_Rack)aMetaTileEntity);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("front", 1, 2, 0, stackSize, hintsOnly);
        this.structureBuild_EM("cap", 1, 2, -1, stackSize, hintsOnly);
        int offset = -2;
        for (int rackSlices = Math.min(stackSize.field_77994_a, 12); rackSlices > 0; --rackSlices) {
            int n = offset;
            offset = (byte)(offset - 1);
            this.structureBuild_EM("slice", 1, 2, n, stackSize, hintsOnly);
        }
        int n = offset;
        offset = (byte)(offset - 1);
        this.structureBuild_EM("cap", 1, 2, n, stackSize, hintsOnly);
        this.structureBuild_EM("back", 1, 2, offset, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece("front", stackSize, 1, 2, 0, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        built = this.survivialBuildPiece("cap", stackSize, 1, 2, -1, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        int offset = -2;
        for (int rackSlices = Math.min(stackSize.field_77994_a, 12); rackSlices > 0; --rackSlices) {
            int n = offset;
            offset = (byte)(offset - 1);
            built = this.survivialBuildPiece("slice", stackSize, 1, 2, n, elementBudget, source, actor, false, true);
            if (built < 0) continue;
            return built;
        }
        int n = offset;
        offset = (byte)(offset - 1);
        built = this.survivialBuildPiece("cap", stackSize, 1, 2, n, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        return this.survivialBuildPiece("back", stackSize, 1, 2, offset, elementBudget, source, actor, false, true);
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_computer> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.1")};
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("front", StructureUtility.transpose((String[][])new String[][]{{" AA"}, {" AA"}, {" ~A"}, {" AA"}})).addShape("cap", StructureUtility.transpose((String[][])new String[][]{{"-CB"}, {" DD"}, {" DD"}, {"-CB"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"-CB"}, {" ED"}, {" ED"}, {"-CB"}})).addShape("back", StructureUtility.transpose((String[][])new String[][]{{" AA"}, {" AA"}, {" AA"}, {" AA"}})).addElement('B', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)1)).addElement('C', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)2)).addElement('D', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)3)).addElement('A', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_EM_computer.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy.or((IHatchElement)GT_MetaTileEntity_MultiblockBase_EM.HatchElement.EnergyMulti), GT_HatchElement.Maintenance, GT_MetaTileEntity_MultiblockBase_EM.HatchElement.Uncertainty, GT_MetaTileEntity_MultiblockBase_EM.HatchElement.OutputData}).casingIndex(1025).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)1)})).addElement('E', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{RackHatchElement.INSTANCE.newAny(1027, 2), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)3)})).build();
        OC_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.0");
        OV_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.1");
        MAX_TEMP_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.0");
        COMPUTE_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.1");
        OC_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.0, 1.0, 1.0, 3.0, new double[0]);
        OV_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.7, 0.8, 1.2, 2.0, new double[0]);
        MAX_TEMP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), -10000.0, 0.0, 0.0, 5000.0, new double[0]);
        COMPUTE_STATUS = (base, p) -> {
            if (base.eAvailableData < 0L) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (base.eAvailableData == 0L) {
                return LedStatus.STATUS_NEUTRAL;
            }
            return LedStatus.STATUS_OK;
        };
    }

    private static enum RackHatchElement implements IHatchElement<GT_MetaTileEntity_EM_computer>
    {
        INSTANCE;


        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(GT_MetaTileEntity_Hatch_Rack.class);
        }

        public IGT_HatchAdder<? super GT_MetaTileEntity_EM_computer> adder() {
            return GT_MetaTileEntity_EM_computer::addRackToMachineList;
        }

        public long count(GT_MetaTileEntity_EM_computer t) {
            return t.eRacks.size();
        }
    }
}

