/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions;

import com.github.technus.tectech.shadow.com.github.technus.avrClone.AvrCore;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.compiler.ProgramCompiler;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.ExecutionEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.IInstruction;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.OperandLimit;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.exceptions.DebugEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.exceptions.DelayEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.exceptions.ReadEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.exceptions.WatchdogEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.instructions.exceptions.WriteEvent;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.ProgramMemory;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidMnemonic;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidOperand0;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidOperand1;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidOperands;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.memory.program.exceptions.ProgramException;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerFile.RegisterFileSingles;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerPackages.CPU_Registers;
import com.github.technus.tectech.shadow.jpsam3hklam9.des.DES;
import java.util.ArrayList;
import java.util.Random;

public abstract class Instruction
implements IInstruction {
    public static Random random = new Random();
    public static final ArrayList<Instruction> INSTRUCTIONS_OP = new ArrayList();
    public static final ArrayList<Instruction> INSTRUCTIONS_IMMERSIVE = new ArrayList();
    public static final Instruction NULL = new Instruction("NULL", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter++, this, new DebugEvent("NULL!"), new int[0]);
        }
    };
    public static final Instruction ADC = new Instruction("ADC", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = ((long)Rdi & 0xFFFFFFFFL) + ((long)Rri & 0xFFFFFFFFL) + (long)Cb;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = R > 0xFFFFFFFFL;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi + (long)Rri + (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Md + Mr + Cb > mask;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Md = Rdi & mask;
                    Mr = Rri & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Md + Mr + Cb > mask);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction ADCI = new Instruction("ADCI", false, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = ((long)Rdi & 0xFFFFFFFFL) + ((long)Rri & 0xFFFFFFFFL) + (long)Cb;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = R > 0xFFFFFFFFL;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi + (long)Rri + (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Md + Mr + Cb > mask;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Md = Rdi & mask;
                    Mr = Rri & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Md + Mr + Cb > mask);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction ADD = new Instruction("ADD", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            long R = ((long)Rdi & 0xFFFFFFFFL) + ((long)Rri & 0xFFFFFFFFL);
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = R > 0xFFFFFFFFL;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi + (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Md + Mr > mask;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Md = Rdi & mask;
                    Mr = Rri & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Md + Mr > mask);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction ADDI = new Instruction("ADDI", false, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            long R = ((long)Rdi & 0xFFFFFFFFL) + ((long)Rri & 0xFFFFFFFFL);
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = R > 0xFFFFFFFFL;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi + (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Md + Mr > mask;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Md = Rdi & mask;
                    Mr = Rri & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Md + Mr > mask);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction AND = new Instruction("AND", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.andRegisterValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ANDI = new Instruction("ANDI", true, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.andRegisterValue(core.getOperand0(), core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ASR = new Instruction("ASR", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            boolean C = (R & 1) != 0;
            core.setStatusBits(CPU_Registers.C, C);
            core.setRegisterValue(core.getOperand0(), R >>>= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            boolean V = N ^ C;
            core.setStatusBits(CPU_Registers.N, N);
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ASRD = new Instruction("ASRD", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R >>>= core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ASRI = new Instruction("ASRI", false, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R >>>= core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BCLR = new Instruction("BCLR", true, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(core.getOperand0());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BLD = new Instruction("BLD", true, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterBits(core.getOperand0(), core.getOperand1(), core.getStatusBitsAnd(CPU_Registers.T));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRBC = new Instruction("BRBC", true, OperandLimit.b, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(core.getOperand0()) ? ++core.programCounter : (core.programCounter += core.getOperand1());
            return null;
        }
    };
    public static final Instruction BRBS = new Instruction("BRBS", true, OperandLimit.b, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(core.getOperand0()) ? (core.programCounter += core.getOperand1()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRCC = new Instruction("BRCC", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.C) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRCS = new Instruction("BRCS", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.C) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BREAK = new Instruction("BREAK", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter++, this, new DebugEvent("BREAK!"), new int[0]);
        }
    };
    public static final Instruction BREQ = new Instruction("BREQ", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.Z) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRGE = new Instruction("BRGE", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.S) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRHC = new Instruction("BRHC", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.H) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRHS = new Instruction("BRHS", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.H) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRID = new Instruction("BRID", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.I) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRIE = new Instruction("BRIE", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.I) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRLO = new Instruction("BRLO", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.C) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRLT = new Instruction("BRLT", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.S) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRMI = new Instruction("BRMI", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.N) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRNE = new Instruction("BRNE", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.Z) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRPL = new Instruction("BRPL", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.N) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRSH = new Instruction("BRSH", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.C) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRTC = new Instruction("BRTC", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.T) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRTS = new Instruction("BRTS", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.T) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BRVC = new Instruction("BRVC", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.V) ? ++core.programCounter : (core.programCounter += core.getOperand0());
            return null;
        }
    };
    public static final Instruction BRVS = new Instruction("BRVS", true, OperandLimit.S7){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getStatusBitsAnd(CPU_Registers.V) ? (core.programCounter += core.getOperand0()) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BSET = new Instruction("BSET", true, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(core.getOperand0());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction BST = new Instruction("BST", true, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.T, core.getRegisterBitsOr(core.getOperand0(), core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CALL = new Instruction("CALL", true, OperandLimit.P22){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.pushValue(core.programCounter);
            core.programCounter = core.getOperand0();
            return null;
        }
    };
    public static final Instruction CBI = new Instruction("CBI", true, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearDataBits(core.getOperand0(), core.getOperand1());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CBR = new Instruction("CBR", true, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearRegisterBits(core.getOperand0(), core.getOperand1());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLC = new Instruction("CLC", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.C);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLH = new Instruction("CLH", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.H);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLI = new Instruction("CLI", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.I);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLN = new Instruction("CLN", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.N);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLR = new Instruction("CLR", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLS = new Instruction("CLS", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.S);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLT = new Instruction("CLT", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.T);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLV = new Instruction("CLV", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CLZ = new Instruction("CLZ", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearStatusBits(CPU_Registers.Z);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction COM = new Instruction("COM", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.notRegisterValue(core.getOperand0());
            core.setStatusBits(CPU_Registers.V, false);
            core.setStatusBits(CPU_Registers.C, true);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            core.setStatusBits(CPU_Registers.S, N);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CP = new Instruction("CP", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            long R = Rdl - Rrl;
            boolean C = Rrl > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction CPC = new Instruction("CPC", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = Rdl - Rrl - (long)Cb;
            boolean C = Rrl + (long)Cb > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri - (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr + Cb > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr + Cb > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction CPCI = new Instruction("CPCI", false, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = Rdl - Rrl - (long)Cb;
            boolean C = Rrl + (long)Cb > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri - (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr + Cb > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr + Cb > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction CPI = new Instruction("CPI", true, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            long R = Rdl - Rrl;
            boolean C = Rrl > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction CPSE = new Instruction("CPSE", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterValue(core.getOperand0()) == core.getRegisterValue(core.getOperand1()) ? (core.programCounter += 2) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction CPSNE = new Instruction("CPSNE", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterValue(core.getOperand0()) == core.getRegisterValue(core.getOperand1()) ? ++core.programCounter : (core.programCounter += 2);
            return null;
        }
    };
    public static final Instruction DEC = new Instruction("DEC", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0()) - 1;
            core.setRegisterValue(core.getOperand0(), Rdi);
            core.setStatusBits(CPU_Registers.Z, Rdi == 0);
            boolean N = Rdi < 0;
            core.setStatusBits(CPU_Registers.N, N);
            boolean V = Rdi == Integer.MAX_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction DIVS = new Instruction("DIVS", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) / (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction DIV = new Instruction("DIV", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) / ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction DIVSU = new Instruction("DIVSU", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) / ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction DIVUS = new Instruction("DIVUS", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) / (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction EOR = new Instruction("EOR", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.xorRegisterValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction EORI = new Instruction("EORI", false, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.xorRegisterValue(core.getOperand0(), core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FMUL = new Instruction("FMUL", true, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) * ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R <<= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FMULS = new Instruction("FMULS", true, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) * (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R <<= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FMULSU = new Instruction("FMULSU", true, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) * ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R <<= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ICALL = new Instruction("ICALL", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.pushValue(core.programCounter);
            core.programCounter = core.getZ();
            return null;
        }
    };
    public static final Instruction IJMP = new Instruction("IJMP", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getZ();
            return null;
        }
    };
    public static final Instruction IN = new Instruction("IN", true, OperandLimit.R, OperandLimit.IO6){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.getDataValue(core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction INC = new Instruction("INC", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0()) + 1;
            core.setRegisterValue(core.getOperand0(), Rdi);
            core.setStatusBits(CPU_Registers.Z, Rdi == 0);
            boolean N = Rdi < 0;
            core.setStatusBits(CPU_Registers.N, N);
            boolean V = Rdi == Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction JMP = new Instruction("JMP", true, OperandLimit.P22){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getOperand0();
            return null;
        }
    };
    public static final Instruction LAC = new Instruction("LAC", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.clearDataBits(core.getZ(), core.getOperand0());
            core.setRegisterValue(core.getOperand0(), core.getDataValue(core.getZ()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LAS = new Instruction("LAS", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setDataBits(core.getZ(), core.getOperand0());
            core.setRegisterValue(core.getOperand0(), core.getDataValue(core.getZ()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LAT = new Instruction("LAT", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.xorDataValue(core.getZ(), core.getOperand0());
            core.setRegisterValue(core.getOperand0(), core.getDataValue(core.getZ()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LD = new Instruction("LD", true){

        @Override
        public void compileInstruction(ProgramMemory programMemory, int address, boolean immersive, int[] operandsReturn, String[] values) throws InvalidMnemonic {
            throw new InvalidMnemonic("This LD is only a dummy!");
        }

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter, this, new InvalidMnemonic("This LD is only a dummy! " + core.programCounter), new int[0]);
        }
    };
    public static final Instruction LDX = new Instruction("LDX", true, OperandLimit.R, OperandLimit.K1pointer){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Xd = core.getOperand1();
            int X = core.getX();
            if (Xd == Integer.MIN_VALUE) {
                core.setX(--X);
                core.setRegisterValue(core.getOperand0(), core.getDataValue(X));
            } else {
                core.setRegisterValue(core.getOperand0(), core.getDataValue(X + Xd));
            }
            if (Xd == Integer.MAX_VALUE) {
                core.setX(X + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LDY = new Instruction("LDY", true, OperandLimit.R, OperandLimit.K6pointer){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Yd = core.getOperand1();
            int Y = core.getY();
            if (Yd == Integer.MIN_VALUE) {
                core.setY(--Y);
                core.setRegisterValue(core.getOperand0(), core.getDataValue(Y));
            } else {
                core.setRegisterValue(core.getOperand0(), core.getDataValue(Y + Yd));
            }
            if (Yd == Integer.MAX_VALUE) {
                core.setY(Y + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LDZ = new Instruction("LDZ", true, OperandLimit.R, OperandLimit.K6pointer){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Zd = core.getOperand1();
            int Z = core.getZ();
            if (Zd == Integer.MIN_VALUE) {
                core.setZ(--Z);
                core.setRegisterValue(core.getOperand0(), core.getDataValue(Z));
            } else {
                core.setRegisterValue(core.getOperand0(), core.getDataValue(Z + Zd));
            }
            if (Zd == Integer.MAX_VALUE) {
                core.setZ(Z + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LDI = new Instruction("LDI", true, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.getOperand1());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LDS = new Instruction("LDS", true, OperandLimit.R, OperandLimit.D16){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.getDataValue(core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LPM = new Instruction("LPM", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Zd = core.getOperand1();
            int Z = core.getZ();
            if (Zd < 0) {
                core.setX(Z += Zd);
            }
            core.setRegisterValue(core.getOperand0(), core.getInstructionID(Z));
            if (Zd > 0) {
                core.setX(Z + Zd);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LPO = new Instruction("LPO", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Zd = core.getOperand1();
            int Z = core.getZ();
            if (Zd < 0) {
                core.setX(Z += Zd);
            }
            core.setRegisterValue(core.getOperand0(), core.getOperand0(Z));
            if (Zd > 0) {
                core.setX(Z + Zd);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LPQ = new Instruction("LPQ", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Zd = core.getOperand1();
            int Z = core.getZ();
            if (Zd < 0) {
                core.setX(Z += Zd);
            }
            core.setRegisterValue(core.getOperand0(), core.getOperand1(Z));
            if (Zd > 0) {
                core.setX(Z + Zd);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LSL = new Instruction("LSL", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            boolean C = R < 0;
            core.setStatusBits(CPU_Registers.C, C);
            core.setRegisterValue(core.getOperand0(), R <<= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            boolean V = N ^ C;
            core.setStatusBits(CPU_Registers.N, N);
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                core.setStatusBits(CPU_Registers.H7, R >> 27 != 0);
                core.setStatusBits(CPU_Registers.H6, R >> 23 != 0);
                core.setStatusBits(CPU_Registers.H5, R >> 19 != 0);
                core.setStatusBits(CPU_Registers.H4, R >> 15 != 0);
                core.setStatusBits(CPU_Registers.H3, R >> 11 != 0);
                core.setStatusBits(CPU_Registers.H2, R >> 7 != 0);
                C = R >> 3 != 0;
                core.setStatusBits(CPU_Registers.H1, C);
                core.setStatusBits(CPU_Registers.H, C);
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction LSLD = new Instruction("LSLD", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R <<= core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LSLI = new Instruction("LSLI", false, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R <<= core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LSR = new Instruction("LSR", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            boolean C = (R & 1) != 0;
            core.setStatusBits(CPU_Registers.C, C);
            core.setRegisterValue(core.getOperand0(), R >>= 1);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            boolean V = N ^ C;
            core.setStatusBits(CPU_Registers.N, N);
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LSRD = new Instruction("LSRD", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R >>= core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction LSRI = new Instruction("LSRI", false, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setRegisterValue(core.getOperand0(), R >>= core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.N, R < 0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MODS = new Instruction("MODS", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) % (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MODUS = new Instruction("MODUS", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) % (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.clearStatusBits(CPU_Registers.S | CPU_Registers.N | CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MODSU = new Instruction("MODSU", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) % ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0L);
            core.clearStatusBits(CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MOD = new Instruction("MOD", false, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) % ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            core.clearStatusBits(CPU_Registers.S | CPU_Registers.N | CPU_Registers.V);
            core.setRegisterValue(core.getOperand0(), (int)R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MOV = new Instruction("MOV", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MOVW = new Instruction("MOVW", true, OperandLimit.Rpmov, OperandLimit.Rpmov){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            core.setRegisterValue(core.getOperand0() + 1, core.getRegisterValue(core.getOperand1() + 1));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MUL = new Instruction("MUL", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = ((long)core.getRegisterValue(core.getOperand0()) & 0xFFFFFFFFL) * ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MULS = new Instruction("MULS", true, OperandLimit.Rh, OperandLimit.Rh){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) * (long)core.getRegisterValue(core.getOperand1());
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction MULSU = new Instruction("MULSU", true, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            long R = (long)core.getRegisterValue(core.getOperand0()) * ((long)core.getRegisterValue(core.getOperand1()) & 0xFFFFFFFFL);
            core.setStatusBits(CPU_Registers.C, (R & Long.MIN_VALUE) != 0L);
            core.setRegisterPairValue(RegisterFileSingles.R0.offset, R);
            core.setStatusBits(CPU_Registers.Z, R == 0L);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction NEG = new Instruction("NEG", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int R = core.negRegisterValue(core.getOperand0());
            core.setStatusBits(CPU_Registers.V, false);
            boolean C = R != 0;
            core.setStatusBits(CPU_Registers.Z, !C);
            core.setStatusBits(CPU_Registers.C, C);
            boolean N = R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            boolean V = R == Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                C = Md > 0;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Md > 0);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction NOP = new Instruction("NOP", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction NOPT = new Instruction("NOPT", false, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.awoken = false;
            return new ExecutionEvent(core.programCounter++, this, new DelayEvent("NOPT!"), core.getRegisterValue(core.getOperand0()));
        }
    };
    public static final Instruction NOPTI = new Instruction("NOPTI", false, OperandLimit.K32){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.awoken = false;
            return new ExecutionEvent(core.programCounter++, this, new DelayEvent("NOPTI!"), core.getOperand0());
        }
    };
    public static final Instruction OR = new Instruction("OR", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.orRegisterValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction ORI = new Instruction("ORI", true, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.orRegisterValue(core.getOperand0(), core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction OUT = new Instruction("OUT", true, OperandLimit.IO6, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setDataValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction POP = new Instruction("POP", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), core.popValue());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction PUSH = new Instruction("PUSH", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.pushValue(core.getRegisterValue(core.getOperand0()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction RCALL = new Instruction("RCALL", true, OperandLimit.S12){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.pushValue(core.programCounter);
            core.programCounter += core.getOperand0();
            return null;
        }
    };
    public static final Instruction RET = new Instruction("RET", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.popValue() + 1;
            return null;
        }
    };
    public static final Instruction RETI = new Instruction("RETI", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.I);
            core.programCounter = core.popValue() + 1;
            return null;
        }
    };
    public static final Instruction RJMP = new Instruction("RJMP", true, OperandLimit.S12){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter += core.getOperand0();
            return null;
        }
    };
    public static final Instruction ROL = new Instruction("ROL", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            boolean C = (R & Integer.MIN_VALUE) != 0;
            boolean C_ = core.getStatusBitsAnd(CPU_Registers.C);
            R = R << 1 | (C_ ? 1 : 0);
            core.setRegisterValue(core.getOperand0(), R);
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            boolean V = N ^ C;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                core.setStatusBits(CPU_Registers.H7, R >> 27 != 0);
                core.setStatusBits(CPU_Registers.H6, R >> 23 != 0);
                core.setStatusBits(CPU_Registers.H5, R >> 19 != 0);
                core.setStatusBits(CPU_Registers.H4, R >> 15 != 0);
                core.setStatusBits(CPU_Registers.H3, R >> 11 != 0);
                core.setStatusBits(CPU_Registers.H2, R >> 7 != 0);
                C = R >> 3 != 0;
                core.setStatusBits(CPU_Registers.H1, C);
                core.setStatusBits(CPU_Registers.H, C);
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction ROR = new Instruction("ROR", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            boolean C = (R & 1) != 0;
            boolean C_ = core.getStatusBitsAnd(CPU_Registers.C);
            R = R >> 1 | (C_ ? Integer.MIN_VALUE : 0);
            core.setRegisterValue(core.getOperand0(), R);
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, R == 0);
            boolean N = R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            boolean V = N ^ C;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBC = new Instruction("SBC", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = Rdl - Rrl - (long)Cb;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = Rrl + (long)Cb > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri - (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr + Cb > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr + Cb > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction SBCI = new Instruction("SBCI", true, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            int Cb = core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0;
            long R = Rdl - Rrl - (long)Cb;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = Rrl + (long)Cb > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri - (long)Cb;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr + Cb > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr + Cb > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction SBI = new Instruction("SBI", true, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setDataBits(core.getOperand0(), core.getOperand1());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBIC = new Instruction("SBIC", true, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getDataBitsAnd(core.getOperand0(), core.getOperand1()) ? ++core.programCounter : (core.programCounter += 2);
            return null;
        }
    };
    public static final Instruction SBIS = new Instruction("SBIS", true, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getDataBitsOr(core.getOperand0(), core.getOperand1()) ? (core.programCounter += 2) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBICC = new Instruction("SBICC", false, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getDataBitsOr(core.getOperand0(), core.getOperand1()) ? ++core.programCounter : (core.programCounter += 2);
            return null;
        }
    };
    public static final Instruction SBISS = new Instruction("SBISS", false, OperandLimit.IO5, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getDataBitsAnd(core.getOperand0(), core.getOperand1()) ? (core.programCounter += 2) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBR = new Instruction("SBR", true, OperandLimit.Rh, OperandLimit.K8b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterBits(core.getOperand0(), core.getOperand1());
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBRC = new Instruction("SBRC", true, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterBitsAnd(core.getOperand0(), core.getOperand1()) ? ++core.programCounter : (core.programCounter += 2);
            return null;
        }
    };
    public static final Instruction SBRS = new Instruction("SBRS", true, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterBitsOr(core.getOperand0(), core.getOperand1()) ? (core.programCounter += 2) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SBRCC = new Instruction("SBRCC", false, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterBitsOr(core.getOperand0(), core.getOperand1()) ? ++core.programCounter : (core.programCounter += 2);
            return null;
        }
    };
    public static final Instruction SBRSS = new Instruction("SBRSS", false, OperandLimit.R, OperandLimit.b){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.programCounter = core.getRegisterBitsAnd(core.getOperand0(), core.getOperand1()) ? (core.programCounter += 2) : ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEC = new Instruction("SEC", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.C);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEH = new Instruction("SEH", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.H);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEI = new Instruction("SEI", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.I);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEN = new Instruction("SEN", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.N);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SER = new Instruction("SER", true, OperandLimit.Rh){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand0(), -1);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SES = new Instruction("SES", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.S);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SET = new Instruction("SET", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.T);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEV = new Instruction("SEV", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SEZ = new Instruction("SEZ", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setStatusBits(CPU_Registers.Z);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SLEEP = new Instruction("SLEEP", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.awoken = false;
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SPM = new Instruction("SPM", true){

        @Override
        public void compileInstruction(ProgramMemory programMemory, int address, boolean immersive, int[] operandsReturn, String[] values) throws InvalidMnemonic {
            throw new InvalidMnemonic("This SPM is only a dummy!");
        }

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter, this, new InvalidMnemonic("This SPM is only a dummy! " + core.programCounter++), new int[0]);
        }
    };
    public static final Instruction ST = new Instruction("ST", true){

        @Override
        public void compileInstruction(ProgramMemory programMemory, int address, boolean immersive, int[] operandsReturn, String[] values) throws InvalidMnemonic {
            throw new InvalidMnemonic("This ST is only a dummy!");
        }

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter, this, new InvalidMnemonic("This ST is only a dummy! " + core.programCounter++), new int[0]);
        }
    };
    public static final Instruction STX = new Instruction("STX", true, OperandLimit.K1pointer, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Xd = core.getOperand0();
            int X = core.getX();
            if (Xd == Integer.MIN_VALUE) {
                core.setX(--X);
                core.setDataValue(X, core.getRegisterValue(core.getOperand1()));
            } else {
                core.setDataValue(X + Xd, core.getRegisterValue(core.getOperand1()));
            }
            if (Xd == Integer.MAX_VALUE) {
                core.setX(X + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction STY = new Instruction("STY", true, OperandLimit.K6pointer, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Yd = core.getOperand0();
            int Y = core.getY();
            if (Yd == Integer.MIN_VALUE) {
                core.setY(--Y);
                core.setDataValue(Y, core.getRegisterValue(core.getOperand1()));
            } else {
                core.setDataValue(Y + Yd, core.getRegisterValue(core.getOperand1()));
            }
            if (Yd == Integer.MAX_VALUE) {
                core.setY(Y + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction STZ = new Instruction("STZ", true, OperandLimit.K6pointer, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Zd = core.getOperand0();
            int Z = core.getZ();
            if (Zd == Integer.MIN_VALUE) {
                core.setZ(--Z);
                core.setDataValue(Z, core.getRegisterValue(core.getOperand1()));
            } else {
                core.setDataValue(Z + Zd, core.getRegisterValue(core.getOperand1()));
            }
            if (Zd == Integer.MAX_VALUE) {
                core.setZ(Z + 1);
            }
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction STS = new Instruction("STS", true, OperandLimit.D16, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setDataValue(core.getOperand0(), core.getRegisterValue(core.getOperand1()));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SUB = new Instruction("SUB", true, OperandLimit.R, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getRegisterValue(core.getOperand1());
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            long R = Rdl - Rrl;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = Rrl > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction SUBI = new Instruction("SUBI", true, OperandLimit.Rh, OperandLimit.K8s){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int Rdi = core.getRegisterValue(core.getOperand0());
            int Rri = core.getOperand1();
            long Rdl = (long)Rdi & 0xFFFFFFFFL;
            long Rrl = (long)Rri & 0xFFFFFFFFL;
            long R = Rdl - Rrl;
            core.setRegisterValue(core.getOperand0(), (int)R);
            boolean C = Rrl > Rdl;
            core.setStatusBits(CPU_Registers.C, C);
            core.setStatusBits(CPU_Registers.Z, (int)R == 0);
            boolean N = (int)R < 0;
            core.setStatusBits(CPU_Registers.N, N);
            R = (long)Rdi - (long)Rri;
            boolean V = R > Integer.MAX_VALUE || R < Integer.MIN_VALUE;
            core.setStatusBits(CPU_Registers.V, V);
            core.setStatusBits(CPU_Registers.S, N ^ V);
            if (core.getStatusBitsAnd(CPU_Registers.U)) {
                core.setStatusBits(CPU_Registers.H8, C);
                int mask = 15;
                int Md = Rdi & mask;
                int Mr = Rri & mask;
                C = Mr > Md;
                core.setStatusBits(CPU_Registers.H, C);
                core.setStatusBits(CPU_Registers.H1, C);
                for (int i = 0; i < 6; ++i) {
                    mask = 0xFFFFFFF >> (i << 2);
                    Mr = Rri & mask;
                    Md = Rdi & mask;
                    core.setStatusBits(CPU_Registers.H7 >> i, Mr > Md);
                }
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return core.getStatusBitsAnd(CPU_Registers.U) ? 4 : 1;
        }
    };
    public static final Instruction SWAP = new Instruction("SWAP", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            int R_ = R >> 4;
            R <<= 4;
            R = R & 0xF0F0F0F0 | R_ & 0xF0F0F0F;
            core.setRegisterValue(core.getOperand0(), R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SWAPP = new Instruction("SWAPP", false, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            int R_ = R >> 2;
            R <<= 2;
            R = R & 0xCCCCCCCC | R_ & 0x33333333;
            core.setRegisterValue(core.getOperand0(), R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SWAPB = new Instruction("SWAPB", false, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            int R_ = R >> 8;
            R <<= 8;
            R = R & 0xFF00FF00 | R_ & 0xFF00FF;
            core.setRegisterValue(core.getOperand0(), R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction SWAPS = new Instruction("SWAPS", false, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            R = R >>> 16 | R << 16;
            core.setRegisterValue(core.getOperand0(), R);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction TST = new Instruction("TST", true, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int R = core.getRegisterValue(core.getOperand0());
            core.setStatusBits(CPU_Registers.Z, R == 0);
            core.setStatusBits(CPU_Registers.S | CPU_Registers.N, R < 0);
            core.clearStatusBits(CPU_Registers.V);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction WDR = new Instruction("WDR", true){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter++, this, new WatchdogEvent("WDR!"), new int[0]);
        }
    };
    public static final Instruction XCH = new Instruction("XCH", true, OperandLimit.Z, OperandLimit.R){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int T = core.getRegisterValue(core.getOperand1());
            core.setRegisterValue(core.getOperand1(), core.getDataValue(core.getZ()));
            core.setDataValue(core.getZ(), T);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPADD = new Instruction("FPADD", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            float Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd += Rr) == 0.0f);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0f);
            core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(Rd));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPSUB = new Instruction("FPSUB", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            float Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd -= Rr) == 0.0f);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0f);
            core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(Rd));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPMUL = new Instruction("FPMUL", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            float Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd *= Rr) == 0.0f);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0f);
            core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(Rd));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPDIV = new Instruction("FPDIV", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            float Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd /= Rr) == 0.0f);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0f);
            core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(Rd));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPMOD = new Instruction("FPMOD", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            float Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd %= Rr) == 0.0f);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0f);
            core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(Rd));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPCP = new Instruction("FPCP", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            double Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            core.setStatusBits(CPU_Registers.Z, (Rd -= (double)Rr) == 0.0);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPCPI = new Instruction("FPCPI", false, OperandLimit.Rq, OperandLimit.K32){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            double Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getOperand1());
            core.setStatusBits(CPU_Registers.Z, (Rd -= (double)Rr) == 0.0);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPCPC = new Instruction("FPCPC", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            double Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getRegisterValue(core.getOperand1()));
            Rd = Rd - (double)Rr - (double)(core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0);
            core.setStatusBits(CPU_Registers.Z, Rd == 0.0);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPCPCI = new Instruction("FPCPCI", false, OperandLimit.Rq, OperandLimit.K32){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            double Rd = Float.intBitsToFloat(core.getRegisterValue(core.getOperand0()));
            float Rr = Float.intBitsToFloat(core.getOperand1());
            Rd = Rd - (double)Rr - (double)(core.getStatusBitsAnd(CPU_Registers.C) ? 1 : 0);
            core.setStatusBits(CPU_Registers.Z, Rd == 0.0);
            core.setStatusBits(CPU_Registers.N | CPU_Registers.S, Rd < 0.0);
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction FPINT = new Instruction("FPINT", false, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand1(), (int)Float.intBitsToFloat(core.getRegisterValue(core.getOperand0())));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction INTFP = new Instruction("INTFP", false, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterValue(core.getOperand1(), Float.floatToIntBits(core.getRegisterValue(core.getOperand0())));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction COPYD = new Instruction("COPYD", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            if (core.isDataBlockValid(core.getX(), core.getY()) && core.isDataBlockValid(core.getZ(), core.getY())) {
                System.arraycopy(core.dataMemory, core.getX(), core.dataMemory, core.getZ(), core.getY());
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 16;
        }
    };
    public static final Instruction COPYP = new Instruction("COPYP", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            if (core.isDataBlockValid(core.getZ(), core.getY())) {
                System.arraycopy(core.getProgramMemory().instructions, core.getX(), core.dataMemory, core.getZ(), core.getY());
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 16;
        }
    };
    public static final Instruction COPYO = new Instruction("COPYO", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            if (core.isDataBlockValid(core.getZ(), core.getY())) {
                System.arraycopy(core.getProgramMemory().param0, core.getX(), core.dataMemory, core.getZ(), core.getY());
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 16;
        }
    };
    public static final Instruction COPYQ = new Instruction("COPYQ", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            if (core.isDataBlockValid(core.getZ(), core.getY())) {
                System.arraycopy(core.getProgramMemory().param1, core.getX(), core.dataMemory, core.getZ(), core.getY());
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 16;
        }
    };
    public static final Instruction CLEAR = new Instruction("CLEAR", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            if (core.isDataBlockValid(core.getZ(), core.getY())) {
                System.arraycopy(new int[core.getOperand1()], 0, core.dataMemory, core.getOperand0(), core.getOperand1());
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 8;
        }
    };
    public static final Instruction RAND = new Instruction("RAND", false, OperandLimit.Rq, OperandLimit.Rq){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int bound = core.getOperand1();
            if (bound > 0) {
                core.setRegisterValue(core.getOperand0(), random.nextInt(bound));
            } else if (bound == 0) {
                core.setRegisterValue(core.getOperand0(), random.nextInt());
            } else {
                core.setRegisterValue(core.getOperand0(), Float.floatToIntBits((float)random.nextGaussian()));
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 4;
        }
    };
    public static final Instruction RANDI = new Instruction("RANDI", false, OperandLimit.Rq, OperandLimit.K32){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            int bound = core.getRegisterValue(core.getOperand1());
            if (bound > 0) {
                core.setRegisterValue(core.getOperand0(), random.nextInt(bound));
            } else if (bound == 0) {
                core.setRegisterValue(core.getOperand0(), random.nextInt());
            } else {
                core.setRegisterValue(core.getOperand0(), Float.floatToIntBits(random.nextFloat()));
            }
            ++core.programCounter;
            return null;
        }

        @Override
        public int getCost(AvrCore core) {
            return 4;
        }
    };
    public static final Instruction WRITE = new Instruction("WRITE", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter++, this, new WriteEvent("WRITE!"), new int[0]);
        }

        @Override
        public int getCost(AvrCore core) {
            return 32;
        }
    };
    public static final Instruction READ = new Instruction("READ", false){

        @Override
        public ExecutionEvent execute(AvrCore core) {
            return new ExecutionEvent(core.programCounter++, this, new ReadEvent("READ!"), new int[0]);
        }

        @Override
        public int getCost(AvrCore core) {
            return 32;
        }
    };
    public static final Instruction DES = new Instruction("DES", false){
        private final DES des = new DES();

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterPairValue(core.getOperand0(), this.des.cipher(core.getRegisterPairValue(0), core.getRegisterPairValue(8), core.getStatusBitsNotAnd(CPU_Registers.H)));
            ++core.programCounter;
            return null;
        }
    };
    public static final Instruction DESR = new Instruction("DESR", false, OperandLimit.Rpair, OperandLimit.Rpair){
        private final DES des = new DES();

        @Override
        public ExecutionEvent execute(AvrCore core) {
            core.setRegisterPairValue(core.getOperand0(), this.des.cipher(core.getRegisterPairValue(core.getOperand0()), core.getRegisterPairValue(core.getOperand1()), core.getStatusBitsNotAnd(CPU_Registers.H)));
            ++core.programCounter;
            return null;
        }
    };
    private final String name;
    private final OperandLimit limit0;
    private final OperandLimit limit1;
    private final boolean immersive;
    private final int operandCount;

    protected Instruction(String name, boolean immersive) {
        this(name, immersive, null, null);
    }

    protected Instruction(String name, boolean immersive, OperandLimit operand0) {
        this(name, immersive, operand0, null);
    }

    protected Instruction(String name, boolean immersive, OperandLimit operand0, OperandLimit operand1) {
        this.limit0 = operand0;
        this.limit1 = operand1;
        this.name = name;
        this.immersive = immersive;
        if (this.isImmersive()) {
            INSTRUCTIONS_IMMERSIVE.add(this);
        }
        INSTRUCTIONS_OP.add(this);
        this.operandCount = this.limit0 == null ? 0 : (this.limit1 == null ? 1 : 2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isImmersive() {
        return this.immersive;
    }

    @Override
    public void compileInstruction(ProgramMemory programMemory, int address, boolean immersive, int[] operandsReturn, String[] values) throws ProgramException {
        Number temp = 0;
        InvalidOperand0 err0 = null;
        if (values.length > 0) {
            if (this.limit0 == null) {
                err0 = new InvalidOperand0("Does not require operand 0");
            }
            if (err0 == null) {
                try {
                    temp = ProgramCompiler.parseNumberAdvanced(values[0]);
                    if (this.limit0.isRelativePreffered()) {
                        temp = temp.doubleValue() - (double)address;
                    }
                    if (this.limit0.isFloatingPointPreffered()) {
                        temp = Float.floatToIntBits(temp.floatValue());
                    }
                }
                catch (Exception e) {
                    err0 = new InvalidOperand0("Cannot Parse " + values[0]);
                }
                if (err0 == null) {
                    operandsReturn[0] = this.limit0.clamp(temp.intValue(), address, immersive);
                    if (temp.intValue() != operandsReturn[0]) {
                        err0 = new InvalidOperand0("Out of range " + temp + " clamped to: " + operandsReturn[0]);
                    }
                }
            }
        }
        if (values.length > 1) {
            if (this.limit1 == null) {
                if (err0 == null) {
                    throw new InvalidOperand1("Instruction " + this.name + " At line " + address + " Does not require operand 1");
                }
                throw new InvalidOperands("Instruction " + this.name + " At line " + address + "    OP0: " + err0.getMessage() + "    OP1: Does not require operand 1");
            }
            try {
                temp = ProgramCompiler.parseNumberAdvanced(values[1]);
                if (this.limit1.isRelativePreffered()) {
                    temp = temp.doubleValue() - (double)address;
                }
                if (this.limit1.isFloatingPointPreffered()) {
                    temp = Float.floatToIntBits(temp.floatValue());
                }
            }
            catch (Exception e) {
                if (err0 == null) {
                    throw new InvalidOperand1("Instruction " + this.name + " At line " + address + " Cannot Parse " + values[1]);
                }
                throw new InvalidOperands("Instruction " + this.name + " At line " + address + "    OP0: " + err0.getMessage() + "    OP1: Cannot Parse " + values[1]);
            }
            operandsReturn[1] = this.limit1.clamp(temp.intValue(), address, immersive);
            if (temp.intValue() != operandsReturn[1]) {
                if (err0 == null) {
                    throw new InvalidOperand1("Instruction " + this.name + " At line " + address + " Out of range " + temp + " clamped to: " + operandsReturn[1]);
                }
                throw new InvalidOperands("Instruction " + this.name + " At line " + address + "    OP0: " + err0.getMessage() + "    OP1: Out of range " + temp + " clamped to: " + operandsReturn[1]);
            }
        }
        if (err0 != null) {
            throw new InvalidOperand0("Instruction " + this.name + " At line " + address + ' ' + err0.getMessage());
        }
    }

    @Override
    public int getOperandCount() {
        return this.operandCount;
    }

    @Override
    public OperandLimit getLimit0() {
        return this.limit0;
    }

    @Override
    public OperandLimit getLimit1() {
        return this.limit1;
    }

    @Override
    public String getNotes() {
        return "";
    }
}

