/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.maps;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import java.util.Map;

public interface IEMMapWriteExact<T extends IEMStack>
extends IEMMapRead<T> {
    default public void cleanUp() {
        this.entrySet().removeIf(entry -> ((IEMStack)entry.getValue()).isInvalidAmount());
    }

    default public void clear() {
        this.getBackingMap().clear();
    }

    @Override
    public IEMMapWriteExact<T> clone();

    default public T removeKey(IEMDefinition def) {
        return (T)((IEMStack)this.getBackingMap().remove(def));
    }

    default public boolean removeKeys(IEMDefinition ... definitions) {
        boolean hadAll = true;
        for (IEMDefinition def : definitions) {
            hadAll &= this.removeKey(def) != null;
        }
        return hadAll;
    }

    default public boolean removeKeys(IEMStack ... hasElementalDefinition) {
        boolean hadAll = true;
        for (IEMStack has : hasElementalDefinition) {
            hadAll &= this.removeKey(has.getDefinition()) != null;
        }
        return hadAll;
    }

    default public boolean removeAllKeys(IEMDefinition ... definitions) {
        boolean hadAll = this.containsAllKeys(definitions);
        if (hadAll) {
            for (IEMDefinition def : definitions) {
                this.removeKey(def);
            }
        }
        return hadAll;
    }

    default public boolean removeAllKeys(IEMStack ... hasElementalDefinition) {
        boolean hadAll = this.containsAllKeys(hasElementalDefinition);
        if (hadAll) {
            for (IEMStack stack : hasElementalDefinition) {
                this.removeKey(stack.getDefinition());
            }
        }
        return hadAll;
    }

    default public void putReplace(T defStackUnsafe) {
        this.getBackingMap().put(defStackUnsafe.getDefinition(), defStackUnsafe);
    }

    default public void putReplaceAll(T ... defStacksUnsafe) {
        for (T defStack : defStacksUnsafe) {
            this.putReplace(defStack);
        }
    }

    default public void putReplaceAll(IEMMapRead<T> inContainerUnsafe) {
        this.getBackingMap().putAll(inContainerUnsafe.getBackingMap());
    }

    default public boolean removeAmountExact(IEMStack def) {
        return this.removeAmountExact(def.getDefinition(), def.getAmount());
    }

    default public boolean removeAmountExact(IEMDefinition def, double amountToConsume) {
        double newAmount;
        Object current = this.get(def);
        if (current != null && (newAmount = current.getAmount() - amountToConsume) >= 0.0) {
            if (current.isValidAmount()) {
                current = current.mutateAmount(newAmount);
                this.putReplace(current);
            } else {
                this.removeKey(current.getDefinition());
            }
            return true;
        }
        return false;
    }

    default public boolean removeAllAmountsExact(IEMStack ... stacks) {
        boolean test = true;
        for (IEMStack stack : stacks) {
            test &= this.containsAmountExact(stack);
        }
        if (!test) {
            return test;
        }
        for (IEMStack stack : stacks) {
            this.removeAmountExact(stack);
        }
        return true;
    }

    default public boolean removeAllAmountsExact(IEMMapRead<? extends IEMStack> map) {
        boolean test = true;
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : map.entrySet()) {
            test &= this.containsAmountExact(entry.getValue());
        }
        if (!test) {
            return test;
        }
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : map.entrySet()) {
            this.removeAmountExact(entry.getValue());
        }
        return true;
    }

    default public T putUnifyExact(T stack) {
        Object target = this.get(stack.getDefinition());
        if (target == null) {
            this.putReplace(stack);
            return stack;
        }
        double newAmount = target.getAmount() + stack.getAmount();
        if (IEMStack.isValidAmount(newAmount)) {
            stack = target.mutateAmount(newAmount);
            this.putReplace(stack);
            return stack;
        }
        this.removeKey(stack.getDefinition());
        return null;
    }

    default public void putUnifyAllExact(T ... defs) {
        for (T def : defs) {
            this.putUnifyExact(def);
        }
    }

    default public void putUnifyAllExact(IEMMapRead<T> inTreeUnsafe) {
        for (Map.Entry<IEMDefinition, T> in : inTreeUnsafe.entrySet()) {
            this.putUnifyExact((IEMStack)in.getValue());
        }
    }
}

