/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityTaintBubble;
import taintedmagic.common.handler.ConfigHandler;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;

public class ItemFocusTaint
extends ItemFocusBasic {
    public static FocusUpgradeType tainturgy = new FocusUpgradeType(55, new ResourceLocation("taintedmagic", "textures/foci/IconTainturgy.png"), "focus.upgrade.tainturgy.name", "focus.upgrade.tainturgy.text", new AspectList().add(Aspect.TAINT, 1).add(Aspect.HEAL, 1));
    public static FocusUpgradeType corrosive = new FocusUpgradeType(56, new ResourceLocation("taintedmagic", "textures/foci/IconCorrosive.png"), "focus.upgrade.corrosive.name", "focus.upgrade.corrosive.text", new AspectList().add(Aspect.TAINT, 1).add(Aspect.POISON, 1));
    IIcon depthIcon = null;
    private final AspectList costBase = new AspectList().add(Aspect.AIR, 80).add(Aspect.WATER, 80);
    private final AspectList costTainturgy = new AspectList().add(Aspect.ORDER, 60);
    private final AspectList costCorrosive = new AspectList().add(Aspect.ENTROPY, 60).add(Aspect.FIRE, 60);
    private final AspectList costEnlarge = new AspectList().add(Aspect.AIR, 60).add(Aspect.WATER, 60);

    public ItemFocusTaint() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusTaint");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusTaint");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusTaint_depth");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "TAINT" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 8073200;
    }

    public AspectList getVisCost(ItemStack stack) {
        AspectList list = this.costBase.copy();
        if (TaintedMagicHelper.hasFocusUpgrade(stack, tainturgy)) {
            list.add(this.costTainturgy);
        }
        if (TaintedMagicHelper.hasFocusUpgrade(stack, corrosive)) {
            list.add(this.costCorrosive);
        }
        if (TaintedMagicHelper.hasFocusUpgrade(stack, FocusUpgradeType.enlarge)) {
            list.add(this.costEnlarge);
        }
        return list;
    }

    public int getActivationCooldown(ItemStack stack) {
        return -1;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return true;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        player.func_71008_a(stack, Integer.MAX_VALUE);
        WandManager.setCooldown((EntityLivingBase)player, (int)-1);
        return stack;
    }

    public void onUsingFocusTick(ItemStack stack, EntityPlayer player, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, player, this.getVisCost(stack), false, false)) {
            player.func_71034_by();
            return;
        }
        if (!player.field_70170_p.field_72995_K && (player.field_70173_aa + 6) % 5 == 0) {
            player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:bubble", 0.33f, 5.0f * (float)Math.random());
            wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false);
        }
        if (!player.field_70170_p.field_72995_K) {
            float scatter = this.isUpgradedWith(wand.getFocusItem(stack), FocusUpgradeType.enlarge) ? 15.0f : 8.0f;
            for (int a = 0; a < 2 + wand.getFocusPotency(stack); ++a) {
                Random rand;
                int randomInt;
                EntityTaintBubble orb = new EntityTaintBubble(player.field_70170_p, (EntityLivingBase)player, scatter, this.isUpgradedWith(wand.getFocusItem(stack), corrosive));
                orb.field_70165_t += orb.field_70159_w;
                orb.field_70163_u += orb.field_70181_x;
                orb.field_70161_v += orb.field_70179_y;
                orb.damage = TaintedMagicHelper.getFocusDamageWithPotency(stack, ConfigHandler.taintStormBaseDamage, ConfigHandler.taintStormStaffMultiple);
                player.field_70170_p.func_72838_d((Entity)orb);
                if (TaintedMagicHelper.hasFocusUpgrade(stack, tainturgy) || (randomInt = (rand = new Random()).nextInt(150)) != 9) continue;
                try {
                    player.func_70690_d(new PotionEffect(Config.potionVisExhaustID, 1000, 2));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (ConfigHandler.taintStormStaffMultiple != 1.0f) {
            list = TaintedMagicHelper.addTooltipDamageAndStaffMultiplier(list, ConfigHandler.taintStormBaseDamage, stack, ConfigHandler.taintStormStaffMultiple);
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: 
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, tainturgy};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, corrosive};
            }
        }
        return null;
    }
}

