/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Upgrades;

import java.util.ArrayList;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Containers.ContainerCartAssembler;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.TransferHandler;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.Slots.SlotCart;
import vswe.stevescarts.Slots.SlotModule;
import vswe.stevescarts.TileEntities.TileEntityCartAssembler;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;
import vswe.stevescarts.Upgrades.BaseEffect;
import vswe.stevescarts.Upgrades.InventoryEffect;

public class Disassemble
extends InventoryEffect {
    @Override
    public int getInventorySize() {
        return 31;
    }

    @Override
    public int getSlotX(int id) {
        if (id == 0) {
            return 178;
        }
        return 38 + (id - 1) % 10 * 18;
    }

    @Override
    public int getSlotY(int id) {
        int y = id == 0 ? 0 : (id - 1) / 10 + 2;
        return 8 + y * 18;
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        if (i == 0) {
            return SlotCart.class;
        }
        return SlotModule.class;
    }

    @Override
    public void load(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        this.setLastCart(upgrade, upgrade.func_70301_a(0));
    }

    @Override
    public String getName() {
        return Localization.UPGRADES.DISASSEMBLE.translate(new String[0]);
    }

    @Override
    public void onInventoryChanged(TileEntityUpgrade upgrade) {
        ItemStack cart = upgrade.func_70301_a(0);
        if (!this.updateCart(upgrade, cart)) {
            boolean needsToPuke = true;
            for (int i = 1; i < this.getInventorySize(); ++i) {
                if (upgrade.func_70301_a(i) != null) continue;
                ItemStack item = upgrade.func_70301_a(0);
                upgrade.func_70299_a(0, null);
                upgrade.func_70299_a(i, item);
                needsToPuke = false;
                break;
            }
            if (needsToPuke) {
                if (!upgrade.func_145831_w().field_72995_K) {
                    upgrade.getMaster().puke(upgrade.func_70301_a(0).func_77946_l());
                }
                upgrade.func_70299_a(0, null);
            }
        }
    }

    @Override
    public void removed(TileEntityUpgrade upgrade) {
        this.updateCart(upgrade, null);
    }

    private void resetMaster(TileEntityCartAssembler master, boolean full) {
        for (int i = 0; i < master.func_70302_i_() - master.nonModularSlots(); ++i) {
            if (master.func_70301_a(i) == null) continue;
            if (master.func_70301_a((int)i).field_77994_a <= 0) {
                master.func_70299_a(i, null);
                continue;
            }
            if (!full) continue;
            if (!master.func_145831_w().field_72995_K) {
                master.puke(master.func_70301_a(i).func_77946_l());
            }
            master.func_70299_a(i, null);
        }
    }

    private void setLastCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (cart == null) {
            upgrade.getCompound().func_74777_a("id", (short)0);
        } else {
            cart.func_77955_b(upgrade.getCompound());
        }
    }

    private ItemStack getLastCart(TileEntityUpgrade upgrade) {
        return ItemStack.func_77949_a((NBTTagCompound)upgrade.getCompound());
    }

    private boolean updateCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (upgrade.getMaster() != null) {
            if (cart == null || cart.func_77973_b() != ModItems.carts || cart.func_77978_p() == null || cart.func_77978_p().func_74764_b("maxTime")) {
                this.resetMaster(upgrade.getMaster(), false);
                this.setLastCart(upgrade, null);
                if (cart != null) {
                    upgrade.getMaster().puke(cart);
                    upgrade.func_70299_a(0, null);
                }
            } else {
                ItemStack last = this.getLastCart(upgrade);
                this.setLastCart(upgrade, cart);
                int result = this.canDisassemble(upgrade);
                boolean reset = false;
                if (result > 0 && last != null && !ItemStack.func_77989_b((ItemStack)cart, (ItemStack)last)) {
                    result = 2;
                    reset = true;
                }
                if (result != 2) {
                    return result == 1 && upgrade.getMaster().func_70301_a(0) != null;
                }
                if (reset) {
                    this.resetMaster(upgrade.getMaster(), true);
                }
                boolean addedHull = false;
                ArrayList<ItemStack> modules = ModuleData.getModularItems(cart);
                for (ItemStack item : modules) {
                    item.field_77994_a = 0;
                    TransferHandler.TransferItem(item, upgrade.getMaster(), new ContainerCartAssembler(null, upgrade.getMaster()), 1);
                    if (addedHull) continue;
                    addedHull = true;
                    upgrade.getMaster().updateSlots();
                }
            }
        }
        return true;
    }

    public int canDisassemble(TileEntityUpgrade upgrade) {
        int i;
        int disassembleCount = 0;
        for (BaseEffect effect : upgrade.getMaster().getEffects()) {
            if (!(effect instanceof Disassemble)) continue;
            ++disassembleCount;
        }
        if (disassembleCount != 1) {
            return 0;
        }
        for (i = 0; i < upgrade.getMaster().func_70302_i_() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().func_70301_a(i) == null || upgrade.getMaster().func_70301_a((int)i).field_77994_a > 0) continue;
            return 1;
        }
        for (i = 0; i < upgrade.getMaster().func_70302_i_() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().func_70301_a(i) == null) continue;
            return 0;
        }
        return 2;
    }
}

