/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vswe.stevescarts.Blocks.BlockCartAssembler;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerCartAssembler;
import vswe.stevescarts.Containers.ContainerUpgrade;
import vswe.stevescarts.Helpers.DropDownMenuItem;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ManagerTransfer;
import vswe.stevescarts.Helpers.NBTHelper;
import vswe.stevescarts.Helpers.SimulationInfo;
import vswe.stevescarts.Helpers.TitleBox;
import vswe.stevescarts.Helpers.TransferHandler;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Interfaces.GuiCartAssembler;
import vswe.stevescarts.Items.ItemCarts;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.ModuleData.ModuleDataHull;
import vswe.stevescarts.Slots.SlotAssembler;
import vswe.stevescarts.Slots.SlotAssemblerFuel;
import vswe.stevescarts.Slots.SlotHull;
import vswe.stevescarts.Slots.SlotOutput;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityBase;
import vswe.stevescarts.TileEntities.TileEntityManager;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;
import vswe.stevescarts.Upgrades.AssemblerUpgrade;
import vswe.stevescarts.Upgrades.BaseEffect;
import vswe.stevescarts.Upgrades.CombustionFuel;
import vswe.stevescarts.Upgrades.Deployer;
import vswe.stevescarts.Upgrades.Disassemble;
import vswe.stevescarts.Upgrades.FuelCapacity;
import vswe.stevescarts.Upgrades.FuelCost;
import vswe.stevescarts.Upgrades.Manager;
import vswe.stevescarts.Upgrades.TimeFlat;
import vswe.stevescarts.Upgrades.TimeFlatCart;
import vswe.stevescarts.Upgrades.TimeFlatRemoved;
import vswe.stevescarts.Upgrades.WorkEfficiency;

public class TileEntityCartAssembler
extends TileEntityBase
implements IInventory,
ISidedInventory {
    private int maxAssemblingTime;
    private float currentAssemblingTime = -1.0f;
    protected ItemStack outputItem;
    protected ArrayList<ItemStack> spareModules;
    private boolean isAssembling;
    public boolean isErrorListOutdated;
    private ArrayList<TitleBox> titleBoxes;
    private ArrayList<DropDownMenuItem> dropDownItems;
    private SimulationInfo info;
    private boolean shouldSpin = true;
    private MinecartModular placeholder;
    private float yaw = 0.0f;
    private float roll = 0.0f;
    private boolean rolldown = false;
    private ArrayList<SlotAssembler> slots;
    private ArrayList<SlotAssembler> engineSlots;
    private ArrayList<SlotAssembler> addonSlots;
    private ArrayList<SlotAssembler> chestSlots;
    private ArrayList<SlotAssembler> funcSlots;
    private SlotHull hullSlot;
    private SlotAssembler toolSlot;
    private SlotOutput outputSlot;
    private SlotAssemblerFuel fuelSlot;
    private final int[] topbotSlots;
    private final int[] sideSlots;
    private ItemStack lastHull;
    private float fuelLevel;
    private ArrayList<TileEntityUpgrade> upgrades = new ArrayList();
    public boolean isDead;
    private boolean loaded;
    ItemStack[] inventoryStacks;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiCartAssembler(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerCartAssembler((IInventory)inv, this);
    }

    public TileEntityCartAssembler() {
        SlotAssembler slot;
        int i;
        this.spareModules = new ArrayList();
        this.dropDownItems = new ArrayList();
        this.slots = new ArrayList();
        this.engineSlots = new ArrayList();
        this.addonSlots = new ArrayList();
        this.chestSlots = new ArrayList();
        this.funcSlots = new ArrayList();
        this.titleBoxes = new ArrayList();
        int slotID = 0;
        this.hullSlot = new SlotHull(this, slotID++, 18, 25);
        this.slots.add(this.hullSlot);
        TitleBox engineBox = new TitleBox(0, 65, 16225309);
        TitleBox toolBox = new TitleBox(1, 100, 6696337);
        TitleBox attachBox = new TitleBox(2, 135, 23423);
        TitleBox storageBox = new TitleBox(3, 170, 10357518);
        TitleBox addonBox = new TitleBox(4, 205, 22566);
        TitleBox infoBox = new TitleBox(5, 375, 30, 13417984);
        this.titleBoxes.add(engineBox);
        this.titleBoxes.add(toolBox);
        this.titleBoxes.add(attachBox);
        this.titleBoxes.add(storageBox);
        this.titleBoxes.add(addonBox);
        this.titleBoxes.add(infoBox);
        for (i = 0; i < 5; ++i) {
            slot = new SlotAssembler(this, slotID++, engineBox.getX() + 2 + 18 * i, engineBox.getY(), 1, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.engineSlots.add(slot);
        }
        this.toolSlot = new SlotAssembler(this, slotID++, toolBox.getX() + 2, toolBox.getY(), 2, false, 0);
        this.slots.add(this.toolSlot);
        this.toolSlot.invalidate();
        for (i = 0; i < 6; ++i) {
            slot = new SlotAssembler(this, slotID++, attachBox.getX() + 2 + 18 * i, attachBox.getY(), -1, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.funcSlots.add(slot);
        }
        for (i = 0; i < 4; ++i) {
            slot = new SlotAssembler(this, slotID++, storageBox.getX() + 2 + 18 * i, storageBox.getY(), 3, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.chestSlots.add(slot);
        }
        for (i = 0; i < 12; ++i) {
            slot = new SlotAssembler(this, slotID++, addonBox.getX() + 2 + 18 * (i % 6), addonBox.getY() + 18 * (i / 6), 4, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.addonSlots.add(slot);
        }
        this.fuelSlot = new SlotAssemblerFuel(this, slotID++, 395, 220);
        this.slots.add(this.fuelSlot);
        this.outputSlot = new SlotOutput(this, slotID++, 450, 220);
        this.slots.add(this.outputSlot);
        this.info = new SimulationInfo();
        this.inventoryStacks = new ItemStack[this.slots.size()];
        this.topbotSlots = new int[]{this.func_70302_i_() - this.nonModularSlots()};
        this.sideSlots = new int[]{this.func_70302_i_() - this.nonModularSlots() + 1};
    }

    public void clearUpgrades() {
        this.upgrades.clear();
    }

    public void addUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.add(upgrade);
    }

    public void removeUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    public ArrayList<TileEntityUpgrade> getUpgradeTiles() {
        return this.upgrades;
    }

    public ArrayList<AssemblerUpgrade> getUpgrades() {
        ArrayList<AssemblerUpgrade> lst = new ArrayList<AssemblerUpgrade>();
        for (TileEntityUpgrade tile : this.upgrades) {
            lst.add(tile.getUpgrade());
        }
        return lst;
    }

    public ArrayList<BaseEffect> getEffects() {
        ArrayList<BaseEffect> lst = new ArrayList<BaseEffect>();
        for (TileEntityUpgrade tile : this.upgrades) {
            AssemblerUpgrade upgrade = tile.getUpgrade();
            if (upgrade == null) continue;
            for (BaseEffect effect : upgrade.getEffects()) {
                lst.add(effect);
            }
        }
        return lst;
    }

    public SimulationInfo getSimulationInfo() {
        return this.info;
    }

    public ArrayList<DropDownMenuItem> getDropDown() {
        return this.dropDownItems;
    }

    public ArrayList<TitleBox> getTitleBoxes() {
        return this.titleBoxes;
    }

    public static int getRemovedSize() {
        return -1;
    }

    public static int getKeepSize() {
        return 0;
    }

    public ArrayList<SlotAssembler> getSlots() {
        return this.slots;
    }

    public ArrayList<SlotAssembler> getEngines() {
        return this.engineSlots;
    }

    public ArrayList<SlotAssembler> getChests() {
        return this.chestSlots;
    }

    public ArrayList<SlotAssembler> getAddons() {
        return this.addonSlots;
    }

    public ArrayList<SlotAssembler> getFuncs() {
        return this.funcSlots;
    }

    public SlotAssembler getToolSlot() {
        return this.toolSlot;
    }

    public int getMaxAssemblingTime() {
        return this.maxAssemblingTime;
    }

    public int getAssemblingTime() {
        return (int)this.currentAssemblingTime;
    }

    private void setAssemblingTime(int val) {
        this.currentAssemblingTime = val;
    }

    public boolean getIsAssembling() {
        return this.isAssembling;
    }

    public void doAssemble() {
        if (!this.hasErrors()) {
            this.maxAssemblingTime = this.generateAssemblingTime();
            this.createCartFromModules();
            this.isAssembling = true;
            for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
                if (tile.getUpgrade() == null) continue;
                for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                    if (!(effect instanceof Disassemble)) continue;
                    ItemStack oldcart = tile.func_70301_a(0);
                    if (oldcart != null && oldcart.func_77973_b() instanceof ItemCarts && oldcart.func_82837_s()) {
                        this.outputItem.func_151001_c(oldcart.func_82833_r());
                    }
                    tile.func_70299_a(0, null);
                }
            }
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        SlotAssembler slot;
        byte slotId;
        if (id == 0) {
            this.doAssemble();
        } else if (id == 1 && (slotId = data[0]) >= 1 && slotId < this.getSlots().size() && (slot = this.getSlots().get(slotId)).func_75211_c() != null) {
            slot.func_75211_c().field_77994_a = slot.func_75211_c().field_77994_a == TileEntityCartAssembler.getKeepSize() ? TileEntityCartAssembler.getRemovedSize() : TileEntityCartAssembler.getKeepSize();
        }
    }

    public void onUpgradeUpdate() {
    }

    public int generateAssemblingTime() {
        return this.generateAssemblingTime(this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), TileEntityCartAssembler.getRemovedSize()}), this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), 1}));
    }

    private int generateAssemblingTime(ArrayList<ModuleData> modules, ArrayList<ModuleData> removed) {
        int timeRequired = 100;
        for (ModuleData module : modules) {
            timeRequired += this.getAssemblingTime(module, false);
        }
        for (ModuleData module : removed) {
            timeRequired += this.getAssemblingTime(module, true);
        }
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlatCart)) continue;
            timeRequired += ((TimeFlatCart)effect).getTicks();
        }
        return Math.max(0, timeRequired);
    }

    private int getAssemblingTime(ModuleData module, boolean isRemoved) {
        int time = (int)(5.0 * Math.pow(module.getCost(), 2.2));
        return Math.max(0, time += this.getTimeDecreased(isRemoved));
    }

    public ItemStack getCartFromModules(boolean isSimulated) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            if (item.field_77994_a != TileEntityCartAssembler.getRemovedSize()) {
                items.add(item);
                continue;
            }
            if (isSimulated) continue;
            ItemStack spare = item.func_77946_l();
            spare.field_77994_a = 1;
            this.spareModules.add(spare);
        }
        return ModuleData.createModularCartFromItems(items);
    }

    private void createCartFromModules() {
        this.spareModules.clear();
        this.outputItem = this.getCartFromModules(false);
        if (this.outputItem != null) {
            for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                this.func_70299_a(i, null);
            }
        } else {
            this.spareModules.clear();
        }
    }

    public ArrayList<ModuleData> getNonHullModules() {
        return this.getModules(false);
    }

    public ArrayList<ModuleData> getModules(boolean includeHull) {
        return this.getModules(includeHull, new int[]{TileEntityCartAssembler.getRemovedSize()});
    }

    public ArrayList<ModuleData> getModules(boolean includeHull, int[] invalid) {
        int i;
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        int n = i = includeHull ? 0 : 1;
        while (i < this.func_70302_i_() - this.nonModularSlots()) {
            ItemStack item = this.func_70301_a(i);
            if (item != null) {
                ModuleData module;
                boolean validSize = true;
                for (int j = 0; j < invalid.length; ++j) {
                    if (invalid[j] != item.field_77994_a && (invalid[j] <= 0 || item.field_77994_a <= 0)) continue;
                    validSize = false;
                    break;
                }
                if (validSize && (module = ModItems.modules.getModuleData(item, true)) != null) {
                    modules.add(module);
                }
            }
            ++i;
        }
        return modules;
    }

    public ModuleDataHull getHullModule() {
        ModuleData hulldata;
        if (this.func_70301_a(0) != null && (hulldata = ModItems.modules.getModuleData(this.func_70301_a(0))) instanceof ModuleDataHull) {
            return (ModuleDataHull)hulldata;
        }
        return null;
    }

    private boolean hasErrors() {
        return this.getErrors().size() > 0;
    }

    public ArrayList<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.hullSlot.func_75211_c() == null) {
            errors.add(Localization.GUI.ASSEMBLER.HULL_ERROR.translate(new String[0]));
        } else {
            ModuleData hulldata = ModItems.modules.getModuleData(this.func_70301_a(0));
            if (hulldata == null || !(hulldata instanceof ModuleDataHull)) {
                errors.add(Localization.GUI.ASSEMBLER.INVALID_HULL_SHORT.translate(new String[0]));
            } else {
                if (this.isAssembling) {
                    errors.add(Localization.GUI.ASSEMBLER.BUSY.translate(new String[0]));
                } else if (this.outputSlot != null && this.outputSlot.func_75211_c() != null) {
                    errors.add(Localization.GUI.ASSEMBLER.DEPARTURE_BAY.translate(new String[0]));
                }
                ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
                for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                    ModuleData data;
                    if (this.func_70301_a(i) == null || (data = ModItems.modules.getModuleData(this.func_70301_a(i))) == null) continue;
                    modules.add(data);
                }
                String error = ModuleData.checkForErrors((ModuleDataHull)hulldata, modules);
                if (error != null) {
                    errors.add(error);
                }
            }
        }
        return errors;
    }

    public int getTotalCost() {
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ModuleData data;
            if (this.func_70301_a(i) == null || (data = ModItems.modules.getModuleData(this.func_70301_a(i))) == null) continue;
            modules.add(data);
        }
        return ModuleData.getTotalCost(modules);
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
        this.updateGuiData(con, crafting, 0, this.getShortFromInt(true, this.maxAssemblingTime));
        this.updateGuiData(con, crafting, 1, this.getShortFromInt(false, this.maxAssemblingTime));
        this.updateGuiData(con, crafting, 2, this.getShortFromInt(true, this.getAssemblingTime()));
        this.updateGuiData(con, crafting, 3, this.getShortFromInt(false, this.getAssemblingTime()));
        this.updateGuiData(con, crafting, 4, (short)(this.isAssembling ? 1 : 0));
        this.updateGuiData(con, crafting, 5, this.getShortFromInt(true, this.getFuelLevel()));
        this.updateGuiData(con, crafting, 6, this.getShortFromInt(false, this.getFuelLevel()));
    }

    @Override
    public void checkGuiData(Container container, ICrafting crafting) {
        ContainerCartAssembler con = (ContainerCartAssembler)container;
        if (con.lastMaxAssemblingTime != this.maxAssemblingTime) {
            this.updateGuiData(con, crafting, 0, this.getShortFromInt(true, this.maxAssemblingTime));
            this.updateGuiData(con, crafting, 1, this.getShortFromInt(false, this.maxAssemblingTime));
            con.lastMaxAssemblingTime = this.maxAssemblingTime;
        }
        if (con.lastIsAssembling != this.isAssembling) {
            this.updateGuiData(con, crafting, 4, (short)(this.isAssembling ? 1 : 0));
            con.lastIsAssembling = this.isAssembling;
        }
        if (con.lastFuelLevel != this.getFuelLevel()) {
            this.updateGuiData(con, crafting, 5, this.getShortFromInt(true, this.getFuelLevel()));
            this.updateGuiData(con, crafting, 6, this.getShortFromInt(false, this.getFuelLevel()));
            con.lastFuelLevel = this.getFuelLevel();
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.maxAssemblingTime = this.getIntFromShort(true, this.maxAssemblingTime, data);
        } else if (id == 1) {
            this.maxAssemblingTime = this.getIntFromShort(false, this.maxAssemblingTime, data);
        } else if (id == 2) {
            this.setAssemblingTime(this.getIntFromShort(true, this.getAssemblingTime(), data));
        } else if (id == 3) {
            this.setAssemblingTime(this.getIntFromShort(false, this.getAssemblingTime(), data));
        } else if (id == 4) {
            boolean bl = this.isAssembling = data != 0;
            if (!this.isAssembling) {
                this.setAssemblingTime(0);
            }
        } else if (id == 5) {
            this.setFuelLevel(this.getIntFromShort(true, this.getFuelLevel(), data));
        } else if (id == 6) {
            this.setFuelLevel(this.getIntFromShort(false, this.getFuelLevel(), data));
        }
    }

    private void invalidateAll() {
        int i;
        for (i = 0; i < this.getEngines().size(); ++i) {
            this.getEngines().get(i).invalidate();
        }
        for (i = 0; i < this.getAddons().size(); ++i) {
            this.getAddons().get(i).invalidate();
        }
        for (i = 0; i < this.getChests().size(); ++i) {
            this.getChests().get(i).invalidate();
        }
        for (i = 0; i < this.getFuncs().size(); ++i) {
            this.getFuncs().get(i).invalidate();
        }
        this.getToolSlot().invalidate();
    }

    private void validateAll() {
        if (this.hullSlot == null) {
            return;
        }
        ArrayList<SlotAssembler> slots = this.getValidSlotFromHullItem(this.hullSlot.func_75211_c());
        if (slots != null) {
            for (SlotAssembler slot : slots) {
                slot.validate();
            }
        }
    }

    public ArrayList<SlotAssembler> getValidSlotFromHullItem(ItemStack hullitem) {
        ModuleData data;
        if (hullitem != null && (data = ModItems.modules.getModuleData(hullitem)) != null && data instanceof ModuleDataHull) {
            ModuleDataHull hull = (ModuleDataHull)data;
            return this.getValidSlotFromHull(hull);
        }
        return null;
    }

    private ArrayList<SlotAssembler> getValidSlotFromHull(ModuleDataHull hull) {
        int i;
        ArrayList<SlotAssembler> slots = new ArrayList<SlotAssembler>();
        for (i = 0; i < hull.getEngineMax(); ++i) {
            slots.add(this.getEngines().get(i));
        }
        for (i = 0; i < hull.getAddonMax(); ++i) {
            slots.add(this.getAddons().get(i));
        }
        for (i = 0; i < this.getChests().size(); ++i) {
            slots.add(this.getChests().get(i));
        }
        for (i = 0; i < this.getFuncs().size(); ++i) {
            slots.add(this.getFuncs().get(i));
        }
        slots.add(this.getToolSlot());
        return slots;
    }

    public int getMaxFuelLevel() {
        int capacity = 4000;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCapacity)) continue;
            capacity += ((FuelCapacity)effect).getFuelCapacity();
        }
        if (capacity > 200000) {
            capacity = 200000;
        } else if (capacity < 1) {
            capacity = 1;
        }
        return capacity;
    }

    public boolean isCombustionFuelValid() {
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof CombustionFuel)) continue;
            return true;
        }
        return false;
    }

    public int getFuelLevel() {
        return (int)this.fuelLevel;
    }

    public void setFuelLevel(int val) {
        this.fuelLevel = val;
    }

    private int getTimeDecreased(boolean isRemoved) {
        int timeDecr = 0;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlat) || effect instanceof TimeFlatRemoved) continue;
            timeDecr += ((TimeFlat)effect).getTicks();
        }
        if (isRemoved) {
            for (BaseEffect effect : this.getEffects()) {
                if (!(effect instanceof TimeFlatRemoved)) continue;
                timeDecr += ((TimeFlat)effect).getTicks();
            }
        }
        return timeDecr;
    }

    private float getFuelCost() {
        float cost = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCost)) continue;
            cost += ((FuelCost)effect).getCost();
        }
        if (cost < 0.05f) {
            // empty if block
        }
        return cost;
    }

    public float getEfficiency() {
        float efficiency = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof WorkEfficiency)) continue;
            efficiency += ((WorkEfficiency)effect).getEfficiency();
        }
        return efficiency;
    }

    private void deployCart() {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Deployer)) continue;
                int x = 2 * tile.field_145851_c - this.field_145851_c;
                int y = 2 * tile.field_145848_d - this.field_145848_d;
                int z = 2 * tile.field_145849_e - this.field_145849_e;
                if (tile.field_145848_d > this.field_145848_d) {
                    ++y;
                }
                if (!BlockRailBase.func_150049_b_((World)this.field_145850_b, (int)x, (int)y, (int)z)) continue;
                try {
                    NBTTagCompound info = this.outputItem.func_77978_p();
                    if (info == null) continue;
                    MinecartModular cart = new MinecartModular(this.field_145850_b, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, info, this.outputItem.func_82833_r());
                    this.field_145850_b.func_72838_d((Entity)cart);
                    cart.temppushX = tile.field_145851_c - this.field_145851_c;
                    cart.temppushZ = tile.field_145849_e - this.field_145849_e;
                    this.managerInteract(cart, true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.outputSlot.func_75215_d(this.outputItem);
    }

    public void managerInteract(MinecartModular cart, boolean toCart) {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                TileEntity managerentity;
                if (!(effect instanceof Manager)) continue;
                int x2 = 2 * tile.field_145851_c - this.field_145851_c;
                int y2 = 2 * tile.field_145848_d - this.field_145848_d;
                int z2 = 2 * tile.field_145849_e - this.field_145849_e;
                if (tile.field_145848_d > this.field_145848_d) {
                    ++y2;
                }
                if ((managerentity = this.field_145850_b.func_147438_o(x2, y2, z2)) == null || !(managerentity instanceof TileEntityManager)) continue;
                ManagerTransfer transfer = new ManagerTransfer();
                transfer.setCart(cart);
                if (tile.field_145848_d != this.field_145848_d) {
                    transfer.setSide(-1);
                } else if (tile.field_145851_c < this.field_145851_c) {
                    transfer.setSide(0);
                } else if (tile.field_145851_c > this.field_145851_c) {
                    transfer.setSide(3);
                } else if (tile.field_145849_e < this.field_145849_e) {
                    transfer.setSide(1);
                } else if (tile.field_145849_e > this.field_145849_e) {
                    transfer.setSide(2);
                }
                if (toCart) {
                    transfer.setFromCartEnabled(false);
                } else {
                    transfer.setToCartEnabled(false);
                }
                TileEntityManager manager = (TileEntityManager)managerentity;
                while (manager.exchangeItems(transfer)) {
                }
            }
        }
    }

    private void deploySpares() {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            if (tile.getUpgrade() == null) continue;
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Disassemble)) continue;
                for (ItemStack item : this.spareModules) {
                    TransferHandler.TransferItem(item, tile, new ContainerUpgrade(null, tile), 1);
                    if (item.field_77994_a <= 0) continue;
                    this.puke(item);
                }
                return;
            }
        }
    }

    public void puke(ItemStack item) {
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d + 0.25, (double)this.field_145849_e, item);
        entityitem.field_70159_w = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) / 10.0f;
        entityitem.field_70181_x = 0.15f;
        entityitem.field_70179_y = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) / 10.0f;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public void func_145845_h() {
        int fuel;
        NBTTagCompound info;
        ItemStack itemInSlot;
        if (!this.loaded) {
            ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).updateMultiBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.loaded = true;
        }
        if (!this.isAssembling && this.outputSlot != null && this.outputSlot.func_75211_c() != null && (itemInSlot = this.outputSlot.func_75211_c()).func_77973_b() == ModItems.carts && (info = itemInSlot.func_77978_p()) != null && info.func_74764_b("maxTime")) {
            ItemStack newItem = new ItemStack((Item)ModItems.carts);
            NBTTagCompound save = new NBTTagCompound();
            save.func_74773_a("Modules", info.func_74770_j("Modules"));
            newItem.func_77982_d(save);
            int modulecount = info.func_74770_j("Modules").length;
            this.maxAssemblingTime = info.func_74762_e("maxTime");
            this.setAssemblingTime(info.func_74762_e("currentTime"));
            this.spareModules.clear();
            if (info.func_74764_b("Spares")) {
                byte[] moduleIDs = info.func_74770_j("Spares");
                for (int i = 0; i < moduleIDs.length; ++i) {
                    byte id = moduleIDs[i];
                    ItemStack module = new ItemStack((Item)ModItems.modules, 1, (int)id);
                    ModItems.modules.addExtraDataToModule(module, info, i + modulecount);
                    this.spareModules.add(module);
                }
            }
            if (itemInSlot.func_82837_s()) {
                newItem.func_151001_c(itemInSlot.func_82833_r());
            }
            this.isAssembling = true;
            this.outputItem = newItem;
            this.outputSlot.func_75215_d(null);
        }
        if (this.getFuelLevel() > this.getMaxFuelLevel()) {
            this.setFuelLevel(this.getMaxFuelLevel());
        }
        if (this.isAssembling && this.outputSlot != null && (float)this.getFuelLevel() >= this.getFuelCost()) {
            this.currentAssemblingTime += this.getEfficiency();
            this.fuelLevel -= this.getFuelCost();
            if (this.getFuelLevel() <= 0) {
                this.setFuelLevel(0);
            }
            if (this.getAssemblingTime() >= this.maxAssemblingTime) {
                this.isAssembling = false;
                this.setAssemblingTime(0);
                if (!this.field_145850_b.field_72995_K) {
                    this.deployCart();
                    this.outputItem = null;
                    this.deploySpares();
                    this.spareModules.clear();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.fuelSlot != null && this.fuelSlot.func_75211_c() != null && (fuel = this.fuelSlot.getFuelLevel(this.fuelSlot.func_75211_c())) > 0 && this.getFuelLevel() + fuel <= this.getMaxFuelLevel()) {
            this.setFuelLevel(this.getFuelLevel() + fuel);
            if (this.fuelSlot.func_75211_c().func_77973_b().hasContainerItem(this.fuelSlot.func_75211_c())) {
                this.fuelSlot.func_75215_d(new ItemStack(this.fuelSlot.func_75211_c().func_77973_b().func_77668_q()));
            } else {
                --this.fuelSlot.func_75211_c().field_77994_a;
            }
            if (this.fuelSlot.func_75211_c().field_77994_a <= 0) {
                this.fuelSlot.func_75215_d(null);
            }
        }
        this.updateSlots();
        this.handlePlaceholder();
    }

    public void updateSlots() {
        if (this.hullSlot != null) {
            if (this.lastHull != null && this.hullSlot.func_75211_c() == null) {
                this.invalidateAll();
            } else if (this.lastHull == null && this.hullSlot.func_75211_c() != null) {
                this.validateAll();
            } else if (this.lastHull != this.hullSlot.func_75211_c()) {
                this.invalidateAll();
                this.validateAll();
            }
            this.lastHull = this.hullSlot.func_75211_c();
        }
        for (SlotAssembler slot : this.slots) {
            slot.update();
        }
    }

    public void resetPlaceholder() {
        this.placeholder = null;
    }

    public MinecartModular getPlaceholder() {
        return this.placeholder;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setYaw(float val) {
        this.yaw = val;
    }

    public void setRoll(float val) {
        this.roll = val;
    }

    public void setSpinning(boolean val) {
        this.shouldSpin = val;
    }

    public int nonModularSlots() {
        return 2;
    }

    private void handlePlaceholder() {
        if (this.field_145850_b.field_72995_K) {
            if (this.placeholder == null) {
                return;
            }
            if (!StevesCarts.freezeCartSimulation) {
                int minRoll = -5;
                int maxRoll = 25;
                if (this.shouldSpin) {
                    this.yaw += 2.0f;
                    this.roll %= 360.0f;
                    if (!this.rolldown) {
                        this.roll = this.roll < (float)(minRoll - 3) ? (this.roll += 5.0f) : (this.roll += 0.2f);
                        if (this.roll > (float)maxRoll) {
                            this.rolldown = true;
                        }
                    } else {
                        this.roll = this.roll > (float)(maxRoll + 3) ? (this.roll -= 5.0f) : (this.roll -= 0.2f);
                        if (this.roll < (float)minRoll) {
                            this.rolldown = false;
                        }
                    }
                }
            }
            this.placeholder.onCartUpdate();
            if (this.placeholder == null) {
                return;
            }
            this.placeholder.updateFuel();
        }
    }

    public void createPlaceholder() {
        if (this.placeholder == null) {
            this.placeholder = new MinecartModular(this.field_145850_b, this, this.getModularInfoBytes());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    public void updatePlaceholder() {
        if (this.placeholder != null) {
            this.placeholder.updateSimulationModules(this.getModularInfoBytes());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    private void updateRenderMenu() {
        ArrayList<DropDownMenuItem> list = this.info.getList();
        this.dropDownItems.clear();
        block0: for (DropDownMenuItem item : list) {
            if (item.getModuleClass() == null) {
                this.dropDownItems.add(item);
                continue;
            }
            for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                if (this.func_70301_a(i) == null || !ModuleData.isItemOfModularType(this.func_70301_a(i), item.getModuleClass()) || item.getExcludedClass() != null && ModuleData.isItemOfModularType(this.func_70301_a(i), item.getExcludedClass())) continue;
                this.dropDownItems.add(item);
                continue block0;
            }
        }
    }

    private byte[] getModularInfoBytes() {
        ArrayList<Byte> datalist = new ArrayList<Byte>();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ModuleData data;
            if (this.func_70301_a(i) == null || (data = ModItems.modules.getModuleData(this.func_70301_a(i))) == null) continue;
            datalist.add((byte)this.func_70301_a(i).func_77960_j());
        }
        byte[] bytes = new byte[datalist.size()];
        for (int i = 0; i < datalist.size(); ++i) {
            bytes[i] = (Byte)datalist.get(i);
        }
        return bytes;
    }

    public boolean getIsDisassembling() {
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a > 0) continue;
            return true;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks[i] != null) {
            if (this.inventoryStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventoryStacks[i];
                this.inventoryStacks[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.inventoryStacks[i].func_77979_a(j);
            if (this.inventoryStacks[i].field_77994_a == 0) {
                this.inventoryStacks[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "container.cartassembler";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
            if (item.field_77994_a == 0) {
                return null;
            }
            return item;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        ItemStack iStack;
        super.func_145839_a(tagCompound);
        NBTTagList items = tagCompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            iStack = ItemStack.func_77949_a((NBTTagCompound)item);
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, iStack);
        }
        NBTTagList spares = tagCompound.func_150295_c("Spares", NBTHelper.COMPOUND.getId());
        this.spareModules.clear();
        for (int i = 0; i < spares.func_74745_c(); ++i) {
            NBTTagCompound item = spares.func_150305_b(i);
            iStack = ItemStack.func_77949_a((NBTTagCompound)item);
            this.spareModules.add(iStack);
        }
        NBTTagCompound outputTag = (NBTTagCompound)tagCompound.func_74781_a("Output");
        if (outputTag != null) {
            this.outputItem = ItemStack.func_77949_a((NBTTagCompound)outputTag);
        }
        if (tagCompound.func_74764_b("Fuel")) {
            this.setFuelLevel(tagCompound.func_74765_d("Fuel"));
        } else {
            this.setFuelLevel(tagCompound.func_74762_e("IntFuel"));
        }
        this.maxAssemblingTime = tagCompound.func_74762_e("maxTime");
        this.setAssemblingTime(tagCompound.func_74762_e("currentTime"));
        this.isAssembling = tagCompound.func_74767_n("isAssembling");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack iStack = this.func_70301_a(i);
            if (iStack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            iStack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
        NBTTagList spares = new NBTTagList();
        for (int i = 0; i < this.spareModules.size(); ++i) {
            ItemStack iStack = this.spareModules.get(i);
            if (iStack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            iStack.func_77955_b(item);
            spares.func_74742_a((NBTBase)item);
        }
        tagCompound.func_74782_a("Spares", (NBTBase)spares);
        if (this.outputItem != null) {
            NBTTagCompound outputTag = new NBTTagCompound();
            this.outputItem.func_77955_b(outputTag);
            tagCompound.func_74782_a("Output", (NBTBase)outputTag);
        }
        tagCompound.func_74768_a("IntFuel", this.getFuelLevel());
        tagCompound.func_74768_a("maxTime", this.maxAssemblingTime);
        tagCompound.func_74768_a("currentTime", this.getAssemblingTime());
        tagCompound.func_74757_a("isAssembling", this.isAssembling);
    }

    public ItemStack getOutputOnInterupt() {
        if (this.outputItem == null) {
            return null;
        }
        if (!this.outputItem.func_77942_o()) {
            return null;
        }
        NBTTagCompound info = this.outputItem.func_77978_p();
        if (info == null) {
            return null;
        }
        info.func_74768_a("currentTime", this.getAssemblingTime());
        info.func_74768_a("maxTime", this.maxAssemblingTime);
        int modulecount = info.func_74770_j("Modules").length;
        NBTTagCompound spares = new NBTTagCompound();
        byte[] moduleIDs = new byte[this.spareModules.size()];
        for (int i = 0; i < this.spareModules.size(); ++i) {
            ItemStack item = this.spareModules.get(i);
            ModuleData data = ModItems.modules.getModuleData(item);
            if (data == null) continue;
            moduleIDs[i] = data.getID();
            ModItems.modules.addExtraDataToCart(info, item, i + modulecount);
        }
        info.func_74773_a("Spares", moduleIDs);
        return this.outputItem;
    }

    public boolean func_94041_b(int slotId, ItemStack item) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            return this.slots.get(slotId).func_75214_a(item);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return side == 0 || side == 1 ? this.topbotSlots : this.sideSlots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return side == 0 || side == 1 ? this.func_94041_b(slot, item) : false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    public void increaseFuel(int val) {
        this.fuelLevel += (float)val;
        if (this.fuelLevel > (float)this.getMaxFuelLevel()) {
            this.fuelLevel = this.getMaxFuelLevel();
        }
    }
}

