/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import stevesaddons.asm.StevesHooks;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.TextBoxNumberList;
import vswe.stevesfactory.interfaces.ContainerBase;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public abstract class ComponentMenuTriggered
extends ComponentMenu {
    protected TextBoxNumberList textBoxes = new TextBoxNumberList();
    private static final String NBT_DELAY = "Delay";
    private static final String NBT_COUNTDOWN = "Counter";
    protected int counter;

    public ComponentMenuTriggered(FlowComponent parent) {
        super(parent);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.textBoxes.draw(gui, mX, mY);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    public void onClick(int mX, int mY, int button) {
        this.textBoxes.onClick(mX, mY, button);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.textBoxes.onKeyStroke(gui, c, k);
    }

    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    public void writeData(DataWriter dw) {
        int val = this.getDelay();
        if (val < this.getMin()) {
            val = this.getMin();
        }
        dw.writeData(val, DataBitHelper.MENU_INTERVAL);
    }

    public void readData(DataReader dr) {
        this.setDelay(dr.readData(DataBitHelper.MENU_INTERVAL));
    }

    public void copyFrom(ComponentMenu menu) {
        this.setDelay(((ComponentMenuTriggered)menu).getDelay());
    }

    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuTriggered newDataTriggered = (ComponentMenuTriggered)newData;
        if (newDataTriggered.getDelay() != this.getDelay()) {
            this.copyFrom(newData);
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(this.getDelay(), DataBitHelper.MENU_INTERVAL);
            PacketHandler.sendDataToListeningClients((ContainerBase)container, (DataWriter)dw);
        }
    }

    public void readNetworkComponent(DataReader dr) {
        this.readData(dr);
    }

    public abstract int getDelay();

    public abstract void setDelay(int var1);

    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.setDelay(nbtTagCompound.func_74762_e(NBT_DELAY));
        this.counter = nbtTagCompound.func_74762_e(NBT_COUNTDOWN);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74768_a(NBT_DELAY, this.getDelay());
        nbtTagCompound.func_74768_a(NBT_COUNTDOWN, this.counter);
    }

    public int getMin() {
        return 1;
    }

    public void setCountdown() {
        if (this.isVisible()) {
            this.counter = 0;
            StevesHooks.registerTicker(this.getParent(), this);
        }
    }

    public void tick() {
        if (this.isVisible() && ++this.counter >= this.getDelay()) {
            this.act();
        }
    }

    public boolean remove() {
        return false;
    }

    protected void act() {
        this.getParent().getManager().activateTrigger(this.getParent(), this.getConnectionSets());
        this.resetCounter();
    }

    protected void resetCounter() {
        this.counter = 0;
    }

    protected abstract EnumSet<ConnectionOption> getConnectionSets();
}

