/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.items;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.GuiHelper;
import squeek.spiceoflife.helpers.InventoryHelper;
import squeek.spiceoflife.helpers.MealPrioritizationHelper;
import squeek.spiceoflife.helpers.MiscHelper;
import squeek.spiceoflife.inventory.ContainerFoodContainer;
import squeek.spiceoflife.inventory.FoodContainerInventory;
import squeek.spiceoflife.inventory.INBTInventoryHaver;
import squeek.spiceoflife.inventory.NBTInventory;
import squeek.spiceoflife.network.NetworkHelper;
import squeek.spiceoflife.network.PacketHandler;
import squeek.spiceoflife.network.PacketToggleFoodContainer;

public class ItemFoodContainer
extends Item
implements INBTInventoryHaver,
IEdible {
    public static final Random random = new Random();
    public static final String TAG_KEY_INVENTORY = "Inventory";
    public static final String TAG_KEY_OPEN = "Open";
    public static final String TAG_KEY_UUID = "UUID";
    public int numSlots;
    public String itemName;
    private IIcon iconOpenEmpty;
    private IIcon iconOpenFull;

    public ItemFoodContainer(String itemName, int numSlots) {
        this.itemName = itemName;
        this.numSlots = numSlots;
        this.func_77625_d(1);
        this.func_111206_d("SpiceOfLife".toLowerCase(Locale.ROOT) + ":" + this.itemName);
        this.func_77655_b("SpiceOfLife".toLowerCase(Locale.ROOT) + "." + this.itemName);
        this.func_77637_a(CreativeTabs.field_78026_f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isFull(ItemStack itemStack) {
        return this.getInventory(itemStack).isInventoryFull();
    }

    public FoodContainerInventory getInventory(ItemStack itemStack) {
        return new FoodContainerInventory(this, itemStack);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.entityItem.func_92059_d().func_77973_b() instanceof ItemFoodContainer) {
            this.onDroppedByPlayer(event.entityItem.func_92059_d(), event.player);
        }
    }

    @Override
    public String getInvName(NBTInventory inventory) {
        return this.func_77653_i(null);
    }

    public UUID getUUID(ItemStack itemStack) {
        return UUID.fromString(this.getOrInitBaseTag(itemStack).func_74779_i(TAG_KEY_UUID));
    }

    public NBTTagCompound getOrInitBaseTag(ItemStack itemStack) {
        NBTTagCompound baseTag;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!(baseTag = itemStack.func_77978_p()).func_74764_b(TAG_KEY_UUID)) {
            baseTag.func_74778_a(TAG_KEY_UUID, UUID.randomUUID().toString());
        }
        return baseTag;
    }

    @Override
    public int getSizeInventory() {
        return this.numSlots;
    }

    @Override
    public boolean isInvNameLocalized(NBTInventory inventory) {
        return false;
    }

    @Override
    public int getInventoryStackLimit(NBTInventory inventory) {
        return ModConfig.FOOD_CONTAINERS_MAX_STACKSIZE;
    }

    @Override
    public void onInventoryChanged(NBTInventory inventory) {
    }

    @Override
    public boolean isItemValidForSlot(NBTInventory inventory, int slotNum, ItemStack itemStack) {
        return FoodHelper.isFood(itemStack) && FoodHelper.isDirectlyEdible(itemStack);
    }

    public void setIsOpen(ItemStack itemStack, boolean isOpen) {
        NBTTagCompound baseTag = this.getOrInitBaseTag(itemStack);
        baseTag.func_74757_a(TAG_KEY_OPEN, isOpen);
    }

    public FoodValues getFoodValues(ItemStack itemStack) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return FoodValues.get((ItemStack)this.getBestFoodForPlayerToEat(itemStack, NetworkHelper.getClientPlayer()));
        }
        return new FoodValues(0, 0.0f);
    }

    public ItemStack getBestFoodForPlayerToEat(ItemStack itemStack, EntityPlayer player) {
        FoodContainerInventory inventory = this.getInventory(itemStack);
        int slotWithBestFood = MealPrioritizationHelper.findBestFoodForPlayerToEat(player, inventory);
        return inventory.func_70301_a(slotWithBestFood);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getFoodValues(FoodEvent.GetFoodValues event) {
        if (FoodHelper.isFoodContainer(event.food)) {
            event.foodValues = event.unmodifiedFoodValues;
        }
    }

    public void tryDumpFoodInto(ItemStack itemStack, IInventory inventory, EntityPlayer player) {
        FoodContainerInventory foodContainerInventory = this.getInventory(itemStack);
        for (int slotNum = 0; slotNum < foodContainerInventory.func_70302_i_(); ++slotNum) {
            ItemStack stackInSlot = foodContainerInventory.func_70301_a(slotNum);
            if (stackInSlot == null) continue;
            stackInSlot = InventoryHelper.insertStackIntoInventory(stackInSlot, inventory);
            foodContainerInventory.func_70299_a(slotNum, stackInSlot);
        }
    }

    public void tryPullFoodFrom(ItemStack itemStack, IInventory inventory, EntityPlayer player) {
        List<MealPrioritizationHelper.InventoryFoodInfo> foodsToPull = MealPrioritizationHelper.findBestFoodsForPlayerAccountingForVariety(player, inventory);
        if (foodsToPull.size() > 0) {
            FoodContainerInventory foodContainerInventory = this.getInventory(itemStack);
            for (MealPrioritizationHelper.InventoryFoodInfo foodToPull : foodsToPull) {
                ItemStack stackInSlot = inventory.func_70301_a(foodToPull.slotNum);
                if (stackInSlot == null) continue;
                stackInSlot = InventoryHelper.insertStackIntoInventoryOnce(stackInSlot, foodContainerInventory);
                inventory.func_70299_a(foodToPull.slotNum, stackInSlot);
            }
        }
    }

    public boolean canPlayerEatFrom(EntityPlayer player, ItemStack stack) {
        return this.canBeEatenFrom(stack) && player.func_71043_e(false);
    }

    public boolean canBeEatenFrom(ItemStack stack) {
        return this.isOpen(stack) && !this.isEmpty(stack);
    }

    public boolean isOpen(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n(TAG_KEY_OPEN);
    }

    public boolean onDroppedByPlayer(ItemStack itemStack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player.field_71070_bA != null && player.field_71070_bA instanceof ContainerFoodContainer) {
            ContainerFoodContainer openFoodContainer = (ContainerFoodContainer)player.field_71070_bA;
            UUID droppedUUID = this.getUUID(itemStack);
            if (openFoodContainer.getUUID().equals(droppedUUID)) {
                ItemStack itemOnTheCursor = player.field_71071_by.func_70445_o();
                if (itemOnTheCursor != null && itemOnTheCursor.func_77973_b() instanceof ItemFoodContainer && ((ItemFoodContainer)itemOnTheCursor.func_77973_b()).getUUID(itemOnTheCursor).equals(droppedUUID)) {
                    player.field_71071_by.func_70437_b(null);
                }
                player.func_71053_j();
            }
        }
        return super.onDroppedByPlayer(itemStack, player);
    }

    public boolean isEmpty(ItemStack itemStack) {
        return NBTInventory.isInventoryEmpty(this.getInventoryTag(itemStack));
    }

    public NBTTagCompound getInventoryTag(ItemStack itemStack) {
        NBTTagCompound baseTag = this.getOrInitBaseTag(itemStack);
        if (!baseTag.func_74764_b(TAG_KEY_INVENTORY)) {
            baseTag.func_74782_a(TAG_KEY_INVENTORY, (NBTBase)new NBTTagCompound());
        }
        return baseTag.func_74775_l(TAG_KEY_INVENTORY);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List toolTip, boolean isAdvanced) {
        super.func_77624_a(itemStack, player, toolTip, isAdvanced);
        String openCloseLineColor = EnumChatFormatting.GRAY.toString();
        if (this.isOpen(itemStack)) {
            toolTip.add(openCloseLineColor + StatCollector.func_74837_a((String)"spiceoflife.tooltip.to.close.food.container", (Object[])new Object[0]));
        } else {
            toolTip.add(openCloseLineColor + StatCollector.func_74837_a((String)"spiceoflife.tooltip.to.open.food.container", (Object[])new Object[0]));
        }
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        if (this.isOpen(itemStack)) {
            return this.isEmpty(itemStack) ? this.iconOpenEmpty : this.iconOpenFull;
        }
        return super.func_77650_f(itemStack);
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        return this.func_77650_f(itemStack);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        IInventory inventoryHit;
        if (!world.field_72995_K && this.isOpen(itemStack) && (inventoryHit = InventoryHelper.getInventoryAtLocation(world, x, y, z)) != null && inventoryHit.func_70300_a(player)) {
            this.tryDumpFoodInto(itemStack, inventoryHit, player);
            this.tryPullFoodFrom(itemStack, inventoryHit, player);
            return true;
        }
        return super.onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (this.canBeEatenFrom(itemStack)) {
            return EnumAction.eat;
        }
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.setIsOpen(itemStack, !this.isOpen(itemStack));
        } else if (this.canPlayerEatFrom(player, itemStack)) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        } else if (!this.isOpen(itemStack)) {
            GuiHelper.openGuiOfItemStack(player, itemStack);
            this.setIsOpen(itemStack, true);
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving.field_70170_p.field_72995_K && ModConfig.LEFT_CLICK_OPENS_FOOD_CONTAINERS && MiscHelper.isMouseOverNothing()) {
            PacketHandler.channel.sendToServer(new PacketToggleFoodContainer());
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer player) {
        int slotWithBestFood;
        FoodContainerInventory inventory = this.getInventory(itemStack);
        ItemStack foodToEat = inventory.func_70301_a(slotWithBestFood = MealPrioritizationHelper.findBestFoodForPlayerToEat(player, inventory));
        if (foodToEat != null) {
            ItemStack result = foodToEat.func_77950_b(world, player);
            if ((result = ForgeEventFactory.onItemUseFinish((EntityPlayer)player, (ItemStack)foodToEat, (int)32, (ItemStack)result)) == null || result.field_77994_a <= 0) {
                result = null;
            }
            inventory.func_70299_a(slotWithBestFood, result);
        }
        return super.func_77654_b(itemStack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOpenEmpty = iconRegister.func_94245_a(this.func_111208_A() + "_open_empty");
        this.iconOpenFull = iconRegister.func_94245_a(this.func_111208_A() + "_open_full");
    }
}

