/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.creeper.Entity_SpecialCreeper;

public class EntityGravityCreeper
extends Entity_SpecialCreeper {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "creeper/gravity.png")};

    public EntityGravityCreeper(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().isImmuneToFalling = true;
        this.getSpecialData().ignorePressurePlates = true;
        this.getSpecialData().immuneToPotions.add(Potion.field_76430_j.field_76415_H);
        ++this.field_70728_aV;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    public void onExplodingUpdate() {
        if (!this.field_70170_p.field_72995_K) {
            boolean powered = this.func_70830_n();
            float radius = powered ? (float)this.field_82226_g * 3.0f : (float)this.field_82226_g * 1.5f;
            List entitiesInRange = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)radius * 2.0, (double)radius * 2.0, (double)radius * 2.0));
            for (int i = 0; i < entitiesInRange.size(); ++i) {
                Entity entityHit = (Entity)entitiesInRange.get(i);
                if (!(this.func_70068_e(entityHit) <= (double)(radius * radius))) continue;
                double vX = this.field_70165_t - entityHit.field_70165_t;
                double vZ = this.field_70161_v - entityHit.field_70161_v;
                double v = Math.sqrt(vX * vX + vZ * vZ);
                entityHit.field_70159_w = vX * (double)radius * 0.05 / (v * v);
                entityHit.field_70179_y = vZ * (double)radius * 0.05 / (v * v);
                entityHit.field_70122_E = false;
                if (!(entityHit instanceof EntityPlayerMP)) continue;
                try {
                    ((EntityPlayerMP)entityHit).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(entityHit));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = powered ? (float)(this.field_82226_g + 2) * 2.0f : (float)(this.field_82226_g + 2);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, griefing);
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151074_bl, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        this.func_145779_a(Items.field_151034_e, 1);
    }
}

