/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.schematica.FileFilterSchematic;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.network.transfer.SchematicTransfer;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.util.FileUtils;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.FilenameUtils;

public class CommandSchematicaDownload
extends CommandSchematicaBase {
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);

    public String func_71517_b() {
        return "schematicaDownload";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.download.usage";
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        File directory = Schematica.proxy.getPlayerSchematicDirectory((EntityPlayer)sender, true);
        File[] files = directory.listFiles(FILE_FILTER_SCHEMATIC);
        if (files != null) {
            ArrayList<String> filenames = new ArrayList<String>();
            for (File file : files) {
                filenames.add(FilenameUtils.removeExtension((String)file.getName()));
            }
            return CommandSchematicaDownload.func_71531_a((String[])args, filenames);
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        String filename = args[0] + ".schematic";
        EntityPlayerMP player = (EntityPlayerMP)sender;
        File directory = Schematica.proxy.getPlayerSchematicDirectory((EntityPlayer)player, true);
        if (!FileUtils.contains(directory, filename)) {
            Reference.logger.error("{} has tried to download the file {}", new Object[]{player.getDisplayName(), filename});
            throw new CommandException("schematica.command.download.downloadFail", new Object[0]);
        }
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            throw new CommandException("schematica.command.download.downloadFail", new Object[0]);
        }
        DownloadHandler.INSTANCE.transferMap.put(player, new SchematicTransfer(schematic, filename));
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("schematica.command.download.started", new Object[]{filename}));
    }
}

