/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import com.google.common.primitives.Ints;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class SGDimensionMap
extends WorldSavedData {
    public static boolean debugDimensionMap = false;
    protected List<Integer> indexToDimension = new ArrayList<Integer>();
    protected Map<Integer, Integer> dimensionToIndex = new HashMap<Integer, Integer>();

    public SGDimensionMap(String name) {
        super(name);
    }

    public static SGDimensionMap get() {
        WorldServer world = BaseUtils.getWorldForDimension(0);
        return BaseUtils.getWorldData((World)world, SGDimensionMap.class, "sgcraft:dimension_map");
    }

    public static Integer dimensionForIndex(int index) {
        return SGDimensionMap.get().getDimensionForIndex(index);
    }

    protected Integer getDimensionForIndex(int index) {
        Integer dimension = null;
        if (index >= 0 && index < this.indexToDimension.size()) {
            dimension = this.indexToDimension.get(index);
        }
        if (debugDimensionMap) {
            SGCraft.log.debug(String.format("SGDimensionMap: Found index %s -> dimension %s", index, dimension));
        }
        return dimension;
    }

    public static Integer indexForDimension(int dimension) {
        return SGDimensionMap.get().getIndexForDimension(dimension);
    }

    protected Integer getIndexForDimension(int dimension) {
        int index;
        if (!this.dimensionToIndex.containsKey(dimension)) {
            index = this.indexToDimension.size();
            if (debugDimensionMap) {
                SGCraft.log.debug(String.format("SGDimensionMap: Adding dimension %s -> index %s", dimension, index));
            }
            this.indexToDimension.add(dimension);
            this.dimensionToIndex.put(dimension, index);
            this.func_76185_a();
        } else {
            index = this.dimensionToIndex.get(dimension);
            if (debugDimensionMap) {
                SGCraft.log.debug(String.format("SGDimensionMap: Found dimension %s -> index %s", dimension, index));
            }
        }
        return index;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (debugDimensionMap) {
            SGCraft.log.debug("SGDimensionMap: Reading from nbt");
        }
        int[] a = nbt.func_74759_k("dimensions");
        for (int i = 0; i < a.length; ++i) {
            this.indexToDimension.add(a[i]);
            this.dimensionToIndex.put(a[i], i);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        if (debugDimensionMap) {
            SGCraft.log.debug("SGDimensionMap: Writing to nbt");
        }
        int[] a = Ints.toArray(this.indexToDimension);
        nbt.func_74783_a("dimensions", a);
    }
}

