/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.SGCraft;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;

public class SGChunkData {
    static boolean debug = false;
    static HashMap<ChunkCoordIntPair, SGChunkData> map = new HashMap();
    public boolean oresGenerated;

    public static SGChunkData forChunk(Chunk chunk) {
        return SGChunkData.forChunk(chunk, null);
    }

    public static SGChunkData forChunk(Chunk chunk, NBTTagCompound nbt) {
        ChunkCoordIntPair coords = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        SGChunkData data = map.get(coords);
        if (data == null) {
            data = new SGChunkData();
            if (nbt != null) {
                data.readFromNBT(nbt);
            }
            map.put(coords, data);
        }
        return data;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.oresGenerated = nbt.func_74767_n("gcewing.sg.oresGenerated");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("gcewing.sg.oresGenerated", this.oresGenerated);
    }

    public static void onChunkLoad(ChunkDataEvent.Load e) {
        Chunk chunk = e.getChunk();
        SGChunkData data = SGChunkData.forChunk(chunk, e.getData());
        if (!data.oresGenerated && SGCraft.addOresToExistingWorlds) {
            if (debug) {
                SGCraft.log.debug(String.format("SGChunkData.onChunkLoad: Adding ores to chunk (%d, %d)", chunk.field_76635_g, chunk.field_76647_h));
            }
            SGCraft.naquadahOreGenerator.regenerate(chunk);
        }
    }

    public static void onChunkSave(ChunkDataEvent.Save e) {
        Chunk chunk = e.getChunk();
        SGChunkData data = SGChunkData.forChunk(chunk);
        data.writeToNBT(e.getData());
    }
}

