/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Network.Messages;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import lumien.randomthings.Items.ItemBiomeCapsule;
import lumien.randomthings.Network.IRTMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class MessagePaintBiome
implements IRTMessage {
    int posX;
    int posY;
    int posZ;
    int dimensionID;
    int biomeID;

    public MessagePaintBiome() {
    }

    public MessagePaintBiome(int x, int y, int z, int dimensionID, int biomeID) {
        this.posX = x;
        this.posZ = z;
        this.posY = y;
        this.dimensionID = dimensionID;
        this.biomeID = biomeID;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
        buffer.writeInt(this.dimensionID);
        buffer.writeInt(this.biomeID);
    }

    public void fromBytes(ByteBuf buffer) {
        this.posX = buffer.readInt();
        this.posY = buffer.readInt();
        this.posZ = buffer.readInt();
        this.dimensionID = buffer.readInt();
        this.biomeID = buffer.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageContext ctx) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p.field_73011_w.field_76574_g == this.dimensionID) {
            Chunk c = player.field_70170_p.func_72938_d(this.posX, this.posZ);
            byte[] biomeArray = c.func_76605_m();
            biomeArray[(this.posZ & 0xF) << 4 | this.posX & 0xF] = (byte)(this.biomeID & 0xFF);
            c.func_76616_a(biomeArray);
            Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72975_g(this.posX, this.posZ, 0, player.field_70170_p.func_72940_L());
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)this.biomeID);
            int colorInt = ItemBiomeCapsule.getColorForBiome(biome);
            Random rng = new Random();
            Color color = new Color(colorInt);
            for (int i = 0; i < 64; ++i) {
                EntitySmokeFX smoke = new EntitySmokeFX(player.field_70170_p, (double)((float)this.posX + rng.nextFloat()), (double)((float)this.posY + rng.nextFloat()), (double)((float)this.posZ + rng.nextFloat()), 0.0, 0.0, 0.0);
                smoke.func_70538_b(0.003921569f * (float)color.getRed(), 0.003921569f * (float)color.getGreen(), 0.003921569f * (float)color.getBlue());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)smoke);
            }
        }
    }
}

