/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;

public class ItemBucketRailcraft
extends Item {
    private final Fluid fluid;
    private String iconName;
    private ItemStack container = new ItemStack(Items.field_151133_ar);

    public ItemBucketRailcraft(Fluid fluid) {
        this.fluid = fluid;
        this.func_77625_d(1);
        this.func_77642_a(Items.field_151133_ar);
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public Item func_77655_b(String name) {
        this.iconName = MiscTools.cleanTag(name);
        return super.func_77655_b(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("railcraft:" + this.iconName);
    }

    public ItemBucketRailcraft setContainerItemStack(ItemStack stack) {
        this.container = stack;
        return this;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.container.func_77946_l();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return stack;
            }
            ForgeDirection sideHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
            if (!player.func_82247_a(x += sideHit.offsetX, y += sideHit.offsetY, z += sideHit.offsetZ, mop.field_72310_e, stack)) {
                return stack;
            }
            if (this.tryPlaceContainedLiquid(world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                return this.getContainerItem(stack);
            }
        }
        return stack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z) {
        Block block;
        if (this.fluid.getBlock() == null) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, block, (block = this.fluid.getBlock()) instanceof BlockFluidFinite ? 15 : 0, 3);
        return true;
    }
}

