/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenancePatternBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityCartUndercutter
extends CartMaintenancePatternBase {
    public static final Set<Block> EXCLUDED_BLOCKS = new HashSet<Block>();
    private static final int SLOT_EXIST_UNDER_A = 0;
    private static final int SLOT_EXIST_UNDER_B = 1;
    private static final int SLOT_EXIST_SIDE_A = 2;
    private static final int SLOT_EXIST_SIDE_B = 3;
    private static final int SLOT_REPLACE_UNDER = 4;
    private static final int SLOT_REPLACE_SIDE = 5;
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);

    public static boolean isValidBallast(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = InvTools.getBlockFromStack(stack);
        if (block == null) {
            return false;
        }
        if (EXCLUDED_BLOCKS.contains(block)) {
            return false;
        }
        if (block.func_149662_c()) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemPost;
    }

    public EntityCartUndercutter(World world) {
        super(world);
    }

    public EntityCartUndercutter(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.UNDERCUTTER;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (TrackTools.isRailBlockAt((IBlockAccess)this.field_70170_p, x, y - 1, z)) {
            --y;
        }
        if (TrackTools.isRailBlock(block = this.field_70170_p.func_147439_a(x, y, z))) {
            EnumTrackMeta trackMeta = EnumTrackMeta.fromMeta(((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, x, y, z));
            --y;
            boolean slotANull = true;
            boolean slotBNull = true;
            if (this.patternInv.func_70301_a(0) != null) {
                this.replaceUnder(x, y, z, 0);
                slotANull = false;
            }
            if (this.patternInv.func_70301_a(1) != null) {
                this.replaceUnder(x, y, z, 1);
                slotBNull = false;
            }
            if (slotANull && slotBNull) {
                this.replaceUnder(x, y, z, 0);
            }
            slotANull = true;
            slotBNull = true;
            if (this.patternInv.func_70301_a(2) != null) {
                this.replaceSide(x, y, z, 2, trackMeta);
                slotANull = false;
            }
            if (this.patternInv.func_70301_a(3) != null) {
                this.replaceSide(x, y, z, 3, trackMeta);
                slotBNull = false;
            }
            if (slotANull && slotBNull) {
                this.replaceSide(x, y, z, 2, trackMeta);
            }
        }
    }

    private void replaceUnder(int x, int y, int z, int slotExist) {
        this.replaceWith(x, y, z, slotExist, 0);
    }

    private void replaceSide(int x, int y, int z, int slotExist, EnumTrackMeta trackMeta) {
        if (trackMeta.isEastWestTrack()) {
            this.replaceWith(x, y, z + 1, slotExist, 1);
            this.replaceWith(x, y, z - 1, slotExist, 1);
        } else if (trackMeta.isNorthSouthTrack()) {
            this.replaceWith(x + 1, y, z, slotExist, 1);
            this.replaceWith(x - 1, y, z, slotExist, 1);
        }
    }

    private void replaceWith(int x, int y, int z, int slotExist, int slotStock) {
        ItemStack exist = this.patternInv.func_70301_a(slotExist);
        ItemStack stock = this.func_70301_a(slotStock);
        if (!EntityCartUndercutter.isValidBallast(stock)) {
            return;
        }
        Block blockToReplace = this.field_70170_p.func_147439_a(x, y, z);
        int oldMeta = this.field_70170_p.func_72805_g(x, y, z);
        if (blockToReplace == null || !this.blockMatches(blockToReplace, oldMeta, exist)) {
            return;
        }
        if (this.safeToReplace(x, y, z)) {
            Block stockBlock = InvTools.getBlockFromStack(stock);
            ArrayList drops = blockToReplace.getDrops(this.field_70170_p, x, y, z, oldMeta, 0);
            ItemBlock item = (ItemBlock)stock.func_77973_b();
            int newMeta = 0;
            if (item.func_77614_k()) {
                newMeta = item.func_77647_b(stock.func_77960_j());
            }
            if (this.field_70170_p.func_147465_d(x, y, z, stockBlock, newMeta, 3)) {
                SoundHelper.playBlockSound(this.field_70170_p, x, y, z, stockBlock.field_149762_H.func_150496_b(), 1.0f, 0.8f, stockBlock, newMeta);
                this.func_70298_a(slotStock, 1);
                for (ItemStack stack : drops) {
                    CartTools.offerOrDropItem((EntityMinecart)this, stack);
                }
                this.blink();
            }
        }
    }

    private boolean blockMatches(Block block, int meta, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block stackBlock;
            ItemBlock existItem = (ItemBlock)stack.func_77973_b();
            int existMeta = Short.MAX_VALUE;
            if (existItem.func_77614_k()) {
                existMeta = existItem.func_77647_b(stack.func_77960_j());
            }
            return (stackBlock = InvTools.getBlockFromStack(stack)) == block && (existMeta == Short.MAX_VALUE || meta == existMeta) || stackBlock == Blocks.field_150346_d && stackBlock == Blocks.field_150349_c;
        }
        return false;
    }

    private boolean safeToReplace(int x, int y, int z) {
        if (this.field_70170_p.func_147437_c(x, y, z)) {
            return false;
        }
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block.func_149688_o().func_76224_d()) {
            return false;
        }
        if (block.func_149712_f(this.field_70170_p, x, y, z) < 0.0f) {
            return false;
        }
        return !block.isReplaceable((IBlockAccess)this.field_70170_p, x, y, z);
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_UNDERCUTTER, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Override
    public String func_145825_b() {
        return LocalizationPlugin.translate(EnumCart.UNDERCUTTER.getTag());
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 4) {
            ItemStack trackReplace = this.patternInv.func_70301_a(4);
            return InvTools.isItemEqual(stack, trackReplace);
        }
        if (slot == 5) {
            ItemStack trackReplace = this.patternInv.func_70301_a(5);
            return InvTools.isItemEqual(stack, trackReplace);
        }
        return false;
    }

    static {
        EXCLUDED_BLOCKS.add((Block)Blocks.field_150354_m);
    }
}

