/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityCartFiltered
extends CartContainerBase
implements IMinecart {
    private static final byte FILTER_DATA_ID = 29;
    private final PhantomInventory invFilter = new PhantomInventory(1, (IInventory)this);

    public EntityCartFiltered(World world) {
        super(world);
    }

    public EntityCartFiltered(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_82709_a(29, 5);
    }

    public static ItemStack getFilterFromCartItem(ItemStack cart) {
        ItemStack filter = null;
        NBTTagCompound nbt = cart.func_77978_p();
        if (nbt != null) {
            NBTTagCompound filterNBT = nbt.func_74775_l("filterStack");
            filter = ItemStack.func_77949_a((NBTTagCompound)filterNBT);
        }
        return filter;
    }

    public static ItemStack addFilterToCartItem(ItemStack cart, ItemStack filter) {
        if (filter != null) {
            NBTTagCompound nbt = InvTools.getItemData(cart);
            NBTTagCompound filterNBT = new NBTTagCompound();
            filter.func_77955_b(filterNBT);
            nbt.func_74782_a("filterStack", (NBTBase)filterNBT);
        }
        return cart;
    }

    public ItemStack getFilteredCartItem(ItemStack filter) {
        ItemStack stack = this.getCartType().getCartItem();
        return EntityCartFiltered.addFilterToCartItem(stack, filter);
    }

    @Override
    public void initEntityFromItem(ItemStack stack) {
        super.initEntityFromItem(stack);
        ItemStack filter = EntityCartFiltered.getFilterFromCartItem(stack);
        this.setFilter(filter);
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack stack = this.getFilteredCartItem(this.getFilterItem());
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_70005_c_());
        }
        return stack;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.invFilter.readFromNBT("invFilter", data);
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.invFilter.writeToNBT("invFilter", data);
    }

    public boolean hasFilter() {
        return this.getFilterItem() != null;
    }

    public ItemStack getFilterItem() {
        return this.field_70180_af.func_82710_f(29);
    }

    public PhantomInventory getFilterInv() {
        return this.invFilter;
    }

    public void setFilter(ItemStack filter) {
        this.getFilterInv().func_70299_a(0, filter);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return EnumCart.getCartType(stack) == this.getCartType();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70180_af.func_75692_b(29, (Object)this.getFilterInv().func_70301_a(0));
    }
}

