/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.client.render.TexturedQuadAdv;
import mods.railcraft.client.render.carts.LocomotiveRendererDefault;
import mods.railcraft.client.render.models.ModelSimple;
import mods.railcraft.client.render.models.locomotives.ModelLocomotiveElectric;
import mods.railcraft.common.carts.EntityLocomotive;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LocomotiveRendererElectric
extends LocomotiveRendererDefault {
    private static final ModelBase LAMP_OFF = new ModelLampOff();
    private static final ModelBase LAMP_ON = new ModelLampOn();
    private final ResourceLocation LAMP_TEX_ON;
    private final ResourceLocation LAMP_TEX_OFF;

    public LocomotiveRendererElectric() {
        super("railcraft:default", "locomotive.model.electric.default", new ModelLocomotiveElectric());
        this.LAMP_TEX_ON = new ResourceLocation("railcraft:textures/entities/locomotives/" + this.modelTag + ".lamp.on.png");
        this.LAMP_TEX_OFF = new ResourceLocation("railcraft:textures/entities/locomotives/" + this.modelTag + ".lamp.off.png");
        this.setEmblemPosition(0.2f, -0.03f, -0.41f, -0.505f);
    }

    @Override
    public void renderLocomotive(IRenderer renderer, EntityMinecart cart, int primaryColor, int secondaryColor, ResourceLocation emblemTexture, float light, float time) {
        super.renderLocomotive(renderer, cart, primaryColor, secondaryColor, emblemTexture, light, time);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
        if (((EntityLocomotive)cart).getMode() == EntityLocomotive.LocoMode.RUNNING) {
            renderer.bindTex(this.LAMP_TEX_ON);
            LAMP_ON.func_78088_a((Entity)cart, -0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        } else {
            renderer.bindTex(this.LAMP_TEX_OFF);
            LAMP_OFF.func_78088_a((Entity)cart, -0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static class ModelLampOn
    extends ModelLampOff {
        public ModelLampOn() {
            for (Object box : this.renderer.field_78804_l) {
                TexturedQuadAdv[] quadsNew = new TexturedQuadAdv[6];
                TexturedQuad[] quadsOld = (TexturedQuad[])ObfuscationReflectionHelper.getPrivateValue(ModelBox.class, (Object)((ModelBox)box), (int)1);
                for (int i = 0; i < 6; ++i) {
                    quadsNew[i] = new TexturedQuadAdv(quadsOld[i].field_78239_a);
                    quadsNew[i].setBrightness(210);
                    quadsNew[i].setColorRGBA(255, 255, 255, 255);
                }
                ObfuscationReflectionHelper.setPrivateValue(ModelBox.class, (Object)((ModelBox)box), (Object)quadsNew, (int)1);
            }
        }
    }

    private static class ModelLampOff
    extends ModelSimple {
        public ModelLampOff() {
            super("lamp");
            this.renderer.func_78787_b(16, 16);
            this.func_78085_a("lamp.bulb", 1, 1);
            this.renderer.func_78786_a("bulb", -22.0f, -17.0f, -9.0f, 1, 2, 2);
            this.renderer.field_78800_c = 8.0f;
            this.renderer.field_78797_d = 8.0f;
            this.renderer.field_78798_e = 8.0f;
        }
    }
}

