/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.NoiseGenerator;

public class SurfaceTundra
extends SurfaceBase {
    public SurfaceTundra(Block top, Block fill) {
        super(top, fill);
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63) {
                    gravel = true;
                }
                if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                    cliff = 1;
                }
                if (c > 1.5f) {
                    cliff = 2;
                }
                if ((float)k > 110.0f + p * 4.0f && c < 0.3f + ((float)k - 100.0f) / 50.0f + p) {
                    cliff = 3;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (cliff == 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 2;
                    continue;
                }
                if (k < 63) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                    gravel = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = cliff == 3 ? Blocks.field_150433_aE : (gravel ? Blocks.field_150351_n : Blocks.field_150346_d);
        }
    }
}

