/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.coast.RealisticBiomeCoastColdCliff;
import rwg.biomes.realistic.coast.RealisticBiomeCoastColdSlope;
import rwg.biomes.realistic.coast.RealisticBiomeCoastDunes;
import rwg.biomes.realistic.coast.RealisticBiomeCoastIce;
import rwg.biomes.realistic.coast.RealisticBiomeCoastMangrove;
import rwg.biomes.realistic.coast.RealisticBiomeCoastOasis;
import rwg.biomes.realistic.coast.RealisticBiomeCoastTest;
import rwg.biomes.realistic.desert.RealisticBiomeDesert;
import rwg.biomes.realistic.desert.RealisticBiomeDesertMountains;
import rwg.biomes.realistic.desert.RealisticBiomeDuneValley;
import rwg.biomes.realistic.desert.RealisticBiomeOasis;
import rwg.biomes.realistic.forest.RealisticBiomeDarkRedwood;
import rwg.biomes.realistic.forest.RealisticBiomeDarkRedwoodPlains;
import rwg.biomes.realistic.forest.RealisticBiomeWoodHills;
import rwg.biomes.realistic.forest.RealisticBiomeWoodMountains;
import rwg.biomes.realistic.land.RealisticBiomeHighRainforest;
import rwg.biomes.realistic.land.RealisticBiomeHotRedwood;
import rwg.biomes.realistic.land.RealisticBiomeJungleCanyon;
import rwg.biomes.realistic.land.RealisticBiomeJungleHills;
import rwg.biomes.realistic.land.RealisticBiomePolar;
import rwg.biomes.realistic.land.RealisticBiomeRedwood;
import rwg.biomes.realistic.land.RealisticBiomeRedwoodJungle;
import rwg.biomes.realistic.land.RealisticBiomeRedwoodSnow;
import rwg.biomes.realistic.land.RealisticBiomeSnowHills;
import rwg.biomes.realistic.land.RealisticBiomeSnowLakes;
import rwg.biomes.realistic.land.RealisticBiomeSnowRivers;
import rwg.biomes.realistic.land.RealisticBiomeTaigaHills;
import rwg.biomes.realistic.land.RealisticBiomeTaigaPlains;
import rwg.biomes.realistic.land.RealisticBiomeTest;
import rwg.biomes.realistic.land.RealisticBiomeTestRiver;
import rwg.biomes.realistic.land.RealisticBiomeTundraHills;
import rwg.biomes.realistic.land.RealisticBiomeTundraPlains;
import rwg.biomes.realistic.ocean.RealisticBiomeIslandTropical;
import rwg.biomes.realistic.ocean.RealisticBiomeOceanTest;
import rwg.biomes.realistic.red.RealisticBiomeCanyon;
import rwg.biomes.realistic.red.RealisticBiomeMesa;
import rwg.biomes.realistic.red.RealisticBiomeRedDesertMountains;
import rwg.biomes.realistic.red.RealisticBiomeRedOasis;
import rwg.biomes.realistic.savanna.RealisticBiomeCanyonForest;
import rwg.biomes.realistic.savanna.RealisticBiomeDuneValleyForest;
import rwg.biomes.realistic.savanna.RealisticBiomeHotForest;
import rwg.biomes.realistic.savanna.RealisticBiomeMesaPlains;
import rwg.biomes.realistic.savanna.RealisticBiomeSavanna;
import rwg.biomes.realistic.savanna.RealisticBiomeSavannaDunes;
import rwg.biomes.realistic.savanna.RealisticBiomeSavannaForest;
import rwg.biomes.realistic.savanna.RealisticBiomeStoneMountains;
import rwg.biomes.realistic.savanna.RealisticBiomeStoneMountainsCactus;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;
import rwg.world.ChunkManagerRealistic;

public class RealisticBiomeBase {
    private static final RealisticBiomeBase[] biomeList = new RealisticBiomeBase[256];
    private static int nextBiomeID = 0;
    public static RealisticBiomeBase test = new RealisticBiomeTest();
    public static RealisticBiomeBase river = new RealisticBiomeTestRiver();
    public static RealisticBiomeBase ocean = new RealisticBiomeOceanTest();
    public static RealisticBiomeBase coast = new RealisticBiomeCoastTest();
    public static RealisticBiomeBase polar = new RealisticBiomePolar();
    public static RealisticBiomeBase snowHills = new RealisticBiomeSnowHills();
    public static RealisticBiomeBase snowRivers = new RealisticBiomeSnowRivers();
    public static RealisticBiomeBase snowLakes = new RealisticBiomeSnowLakes();
    public static RealisticBiomeBase redwoodSnow = new RealisticBiomeRedwoodSnow();
    public static RealisticBiomeBase tundraHills = new RealisticBiomeTundraHills();
    public static RealisticBiomeBase tundraPlains = new RealisticBiomeTundraPlains();
    public static RealisticBiomeBase taigaHills = new RealisticBiomeTaigaHills();
    public static RealisticBiomeBase taigaPlains = new RealisticBiomeTaigaPlains();
    public static RealisticBiomeBase redwood = new RealisticBiomeRedwood();
    public static RealisticBiomeBase darkRedwood = new RealisticBiomeDarkRedwood();
    public static RealisticBiomeBase darkRedwoodPlains = new RealisticBiomeDarkRedwoodPlains();
    public static RealisticBiomeBase woodhills = new RealisticBiomeWoodHills();
    public static RealisticBiomeBase woodmountains = new RealisticBiomeWoodMountains();
    public static RealisticBiomeBase duneValleyForest = new RealisticBiomeDuneValleyForest();
    public static RealisticBiomeBase savanna = new RealisticBiomeSavanna();
    public static RealisticBiomeBase savannaForest = new RealisticBiomeSavannaForest();
    public static RealisticBiomeBase savannaDunes = new RealisticBiomeSavannaDunes();
    public static RealisticBiomeBase stoneMountains = new RealisticBiomeStoneMountains();
    public static RealisticBiomeBase stoneMountainsCactus = new RealisticBiomeStoneMountainsCactus();
    public static RealisticBiomeBase hotForest = new RealisticBiomeHotForest();
    public static RealisticBiomeBase hotRedwood = new RealisticBiomeHotRedwood();
    public static RealisticBiomeBase canyonForest = new RealisticBiomeCanyonForest();
    public static RealisticBiomeBase mesaPlains = new RealisticBiomeMesaPlains();
    public static RealisticBiomeBase desert = new RealisticBiomeDesert();
    public static RealisticBiomeBase desertMountains = new RealisticBiomeDesertMountains();
    public static RealisticBiomeBase duneValley = new RealisticBiomeDuneValley();
    public static RealisticBiomeBase oasis = new RealisticBiomeOasis();
    public static RealisticBiomeBase redDesertMountains = new RealisticBiomeRedDesertMountains();
    public static RealisticBiomeBase redDesertOasis = new RealisticBiomeRedOasis();
    public static RealisticBiomeBase canyon = new RealisticBiomeCanyon();
    public static RealisticBiomeBase mesa = new RealisticBiomeMesa();
    public static RealisticBiomeBase rainForestHigh = new RealisticBiomeHighRainforest();
    public static RealisticBiomeBase jungleHills = new RealisticBiomeJungleHills();
    public static RealisticBiomeBase jungleCanyon = new RealisticBiomeJungleCanyon();
    public static RealisticBiomeBase redwoodJungle = new RealisticBiomeRedwoodJungle();
    public static RealisticBiomeBase coastIce = new RealisticBiomeCoastIce();
    public static RealisticBiomeBase coastColdSlope = new RealisticBiomeCoastColdSlope();
    public static RealisticBiomeBase coastColdCliff = new RealisticBiomeCoastColdCliff();
    public static RealisticBiomeBase coastDunes = new RealisticBiomeCoastDunes();
    public static RealisticBiomeBase coastMangrove = new RealisticBiomeCoastMangrove();
    public static RealisticBiomeBase coastOasis = new RealisticBiomeCoastOasis();
    public static RealisticBiomeBase islandTropical = new RealisticBiomeIslandTropical();
    public final int biomeID = nextBiomeID++;
    public final int subID;
    public final BiomeGenBase baseBiome;
    public final RealisticBiomeBase beachBiome;
    public final BiomeGenBase riverBiome;

    public RealisticBiomeBase(int sub, BiomeGenBase biome) {
        this(sub, biome, coastIce, RWGBiomes.baseRiverTemperate);
    }

    public RealisticBiomeBase(int sub, BiomeGenBase biome, RealisticBiomeBase coast, BiomeGenBase river) {
        RealisticBiomeBase.biomeList[this.biomeID] = this;
        this.subID = sub;
        this.baseBiome = biome;
        this.beachBiome = coast;
        this.riverBiome = river;
    }

    public static RealisticBiomeBase getBiome(int id) {
        return biomeList[id];
    }

    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
    }

    public void generateMapGen(Block[] blocks, byte[] metadata, Long seed, World world, ChunkManagerRealistic cmr, Random mapRand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float[] noise) {
        int k = 5;
        mapRand.setSeed(seed);
        long l = mapRand.nextLong() / 2L * 2L + 1L;
        long l1 = mapRand.nextLong() / 2L * 2L + 1L;
        for (int baseX = chunkX - k; baseX <= chunkX + k; ++baseX) {
            for (int baseY = chunkY - k; baseY <= chunkY + k; ++baseY) {
                mapRand.setSeed((long)baseX * l + (long)baseY * l1 ^ seed);
                this.rMapGen(blocks, metadata, world, cmr, mapRand, baseX, baseY, chunkX, chunkY, perlin, cell, noise);
            }
        }
    }

    public void rMapGen(Block[] blocks, byte[] metadata, World world, ChunkManagerRealistic cmr, Random mapRand, int chunkX, int chunkY, int baseX, int baseY, NoiseGenerator perlin, CellNoise cell, float[] noise) {
    }

    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return 63.0f;
    }

    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 62) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
        }
    }

    public float r3Dnoise(float z) {
        return 0.0f;
    }
}

