/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import mcp.mobius.shadow.org.apache.commons.math3.Field;
import mcp.mobius.shadow.org.apache.commons.math3.exception.DimensionMismatchException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.MathArithmeticException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.MathIllegalArgumentException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.MathInternalError;
import mcp.mobius.shadow.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.NotPositiveException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.NullArgumentException;
import mcp.mobius.shadow.org.apache.commons.math3.exception.util.Localizable;
import mcp.mobius.shadow.org.apache.commons.math3.exception.util.LocalizedFormats;
import mcp.mobius.shadow.org.apache.commons.math3.util.FastMath;
import mcp.mobius.shadow.org.apache.commons.math3.util.MathUtils;
import mcp.mobius.shadow.org.apache.commons.math3.util.Pair;
import mcp.mobius.shadow.org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathArrays {
    private static final int SPLIT_FACTOR = 0x8000001;

    private MathArrays() {
    }

    public static double[] scale(double val, double[] arr) {
        double[] newArr = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = arr[i] * val;
        }
        return newArr;
    }

    public static void scaleInPlace(double val, double[] arr) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * val;
        }
    }

    public static double[] ebeAdd(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] + b[i];
        }
        return result;
    }

    public static double[] ebeSubtract(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] - b[i];
        }
        return result;
    }

    public static double[] ebeMultiply(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] * b[i];
        }
        return result;
    }

    public static double[] ebeDivide(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] / b[i];
        }
        return result;
    }

    public static double distance1(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            sum += FastMath.abs(p1[i] - p2[i]);
        }
        return sum;
    }

    public static int distance1(int[] p1, int[] p2) {
        int sum = 0;
        for (int i = 0; i < p1.length; ++i) {
            sum += FastMath.abs(p1[i] - p2[i]);
        }
        return sum;
    }

    public static double distance(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double distance(int[] p1, int[] p2) {
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double distanceInf(double[] p1, double[] p2) {
        double max = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            max = FastMath.max(max, FastMath.abs(p1[i] - p2[i]));
        }
        return max;
    }

    public static int distanceInf(int[] p1, int[] p2) {
        int max = 0;
        for (int i = 0; i < p1.length; ++i) {
            max = FastMath.max(max, FastMath.abs(p1[i] - p2[i]));
        }
        return max;
    }

    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] val, OrderDirection dir, boolean strict) {
        T previous = val[0];
        int max = val.length;
        for (int i = 1; i < max; ++i) {
            switch (dir) {
                case INCREASING: {
                    int comp = previous.compareTo(val[i]);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int comp = val[i].compareTo(previous);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[i];
        }
        return true;
    }

    public static boolean isMonotonic(double[] val, OrderDirection dir, boolean strict) {
        return MathArrays.checkOrder(val, dir, strict, false);
    }

    public static boolean checkOrder(double[] val, OrderDirection dir, boolean strict, boolean abort) throws NonMonotonicSequenceException {
        int index;
        double previous = val[0];
        int max = val.length;
        block4: for (index = 1; index < max; ++index) {
            switch (dir) {
                case INCREASING: {
                    if (!(strict ? val[index] <= previous : val[index] < previous)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(strict ? val[index] >= previous : val[index] > previous)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[index];
        }
        if (index == max) {
            return true;
        }
        if (abort) {
            throw new NonMonotonicSequenceException(val[index], (Number)previous, index, dir, strict);
        }
        return false;
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, dir, strict, true);
    }

    public static void checkOrder(double[] val) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] in) throws NullArgumentException, DimensionMismatchException {
        MathUtils.checkNotNull(in);
        for (int i = 1; i < in.length; ++i) {
            if (in[i].length == in[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, in[i].length, in[0].length);
        }
    }

    public static void checkPositive(double[] in) throws NotStrictlyPositiveException {
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] <= 0.0)) continue;
            throw new NotStrictlyPositiveException(in[i]);
        }
    }

    public static void checkNonNegative(long[] in) throws NotPositiveException {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] >= 0L) continue;
            throw new NotPositiveException(in[i]);
        }
    }

    public static void checkNonNegative(long[][] in) throws NotPositiveException {
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[i].length; ++j) {
                if (in[i][j] >= 0L) continue;
                throw new NotPositiveException(in[i][j]);
            }
        }
    }

    public static double safeNorm(double[] v) {
        double rdwarf = 3.834E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = v.length;
        double agiant = rgiant / floatn;
        for (int i = 0; i < v.length; ++i) {
            double xabs = Math.abs(v[i]);
            if (xabs < rdwarf || xabs > agiant) {
                double r;
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        r = x1max / xabs;
                        s1 = 1.0 + s1 * r * r;
                        x1max = xabs;
                        continue;
                    }
                    r = xabs / x1max;
                    s1 += r * r;
                    continue;
                }
                if (xabs > x3max) {
                    r = x3max / xabs;
                    s3 = 1.0 + s3 * r * r;
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                r = xabs / x3max;
                s3 += r * r;
                continue;
            }
            s2 += xabs * xabs;
        }
        double norm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 == 0.0 ? x3max * Math.sqrt(s3) : (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))));
        return norm;
    }

    public static void sortInPlace(double[] x, double[] ... yList) throws DimensionMismatchException, NullArgumentException {
        MathArrays.sortInPlace(x, OrderDirection.INCREASING, yList);
    }

    public static void sortInPlace(double[] x, final OrderDirection dir, double[] ... yList) throws NullArgumentException, DimensionMismatchException {
        if (x == null) {
            throw new NullArgumentException();
        }
        int len = x.length;
        ArrayList<Pair<Double, double[]>> list = new ArrayList<Pair<Double, double[]>>(len);
        int yListLen = yList.length;
        for (int i = 0; i < len; ++i) {
            double[] yValues = new double[yListLen];
            for (int j = 0; j < yListLen; ++j) {
                double[] y = yList[j];
                if (y == null) {
                    throw new NullArgumentException();
                }
                if (y.length != len) {
                    throw new DimensionMismatchException(y.length, len);
                }
                yValues[j] = y[i];
            }
            list.add(new Pair<Double, double[]>(x[i], yValues));
        }
        Comparator<Pair<Double, double[]>> comp = new Comparator<Pair<Double, double[]>>(){

            @Override
            public int compare(Pair<Double, double[]> o1, Pair<Double, double[]> o2) {
                int val;
                switch (dir) {
                    case INCREASING: {
                        val = o1.getKey().compareTo(o2.getKey());
                        break;
                    }
                    case DECREASING: {
                        val = o2.getKey().compareTo(o1.getKey());
                        break;
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
                return val;
            }
        };
        Collections.sort(list, comp);
        for (int i = 0; i < len; ++i) {
            Pair e = (Pair)list.get(i);
            x[i] = (Double)e.getKey();
            double[] yValues = (double[])e.getValue();
            for (int j = 0; j < yListLen; ++j) {
                yList[j][i] = yValues[j];
            }
        }
    }

    public static int[] copyOf(int[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static double[] copyOf(double[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static int[] copyOf(int[] source, int len) {
        int[] output = new int[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double[] copyOf(double[] source, int len) {
        double[] output = new double[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double linearCombination(double[] a, double[] b) throws DimensionMismatchException {
        int len = a.length;
        if (len != b.length) {
            throw new DimensionMismatchException(len, b.length);
        }
        double[] prodHigh = new double[len];
        double prodLowSum = 0.0;
        for (int i = 0; i < len; ++i) {
            double ai = a[i];
            double ca = 1.34217729E8 * ai;
            double aHigh = ca - (ca - ai);
            double aLow = ai - aHigh;
            double bi = b[i];
            double cb = 1.34217729E8 * bi;
            double bHigh = cb - (cb - bi);
            double bLow = bi - bHigh;
            prodHigh[i] = ai * bi;
            double prodLow = aLow * bLow - (prodHigh[i] - aHigh * bHigh - aLow * bHigh - aHigh * bLow);
            prodLowSum += prodLow;
        }
        double prodHighCur = prodHigh[0];
        double prodHighNext = prodHigh[1];
        double sHighPrev = prodHighCur + prodHighNext;
        double sPrime = sHighPrev - prodHighNext;
        double sLowSum = prodHighNext - (sHighPrev - sPrime) + (prodHighCur - sPrime);
        int lenMinusOne = len - 1;
        for (int i = 1; i < lenMinusOne; ++i) {
            prodHighNext = prodHigh[i + 1];
            double sHighCur = sHighPrev + prodHighNext;
            sPrime = sHighCur - prodHighNext;
            sLowSum += prodHighNext - (sHighCur - sPrime) + (sHighPrev - sPrime);
            sHighPrev = sHighCur;
        }
        double result = sHighPrev + (prodLowSum + sLowSum);
        if (Double.isNaN(result)) {
            result = 0.0;
            for (int i = 0; i < len; ++i) {
                result += a[i] * b[i];
            }
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double result = s12High + (prod1Low + prod2Low + s12Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double ca3 = 1.34217729E8 * a3;
        double a3High = ca3 - (ca3 - a3);
        double a3Low = a3 - a3High;
        double cb3 = 1.34217729E8 * b3;
        double b3High = cb3 - (cb3 - b3);
        double b3Low = b3 - b3High;
        double prod3Low = a3Low * b3Low - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double s123Prime = s123High - prod3High;
        double s123Low = prod3High - (s123High - s123Prime) + (s12High - s123Prime);
        double result = s123High + (prod1Low + prod2Low + prod3Low + s12Low + s123Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3, double a4, double b4) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double prod4High = a4 * b4;
        double s1234High = s123High + prod4High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double ca3 = 1.34217729E8 * a3;
        double a3High = ca3 - (ca3 - a3);
        double a3Low = a3 - a3High;
        double cb3 = 1.34217729E8 * b3;
        double b3High = cb3 - (cb3 - b3);
        double b3Low = b3 - b3High;
        double prod3Low = a3Low * b3Low - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low);
        double ca4 = 1.34217729E8 * a4;
        double a4High = ca4 - (ca4 - a4);
        double a4Low = a4 - a4High;
        double cb4 = 1.34217729E8 * b4;
        double b4High = cb4 - (cb4 - b4);
        double b4Low = b4 - b4High;
        double prod4Low = a4Low * b4Low - (prod4High - a4High * b4High - a4Low * b4High - a4High * b4Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double s123Prime = s123High - prod3High;
        double s123Low = prod3High - (s123High - s123Prime) + (s12High - s123Prime);
        double s1234Prime = s1234High - prod4High;
        double s1234Low = prod4High - (s1234High - s1234Prime) + (s123High - s1234Prime);
        double result = s1234High + (prod1Low + prod2Low + prod3Low + prod4Low + s12Low + s123Low + s1234Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3 + a4 * b4;
        }
        return result;
    }

    public static boolean equals(float[] x, float[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equals(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] x, float[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equalsIncludingNaN(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] x, double[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equals(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] x, double[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equalsIncludingNaN(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] normalizeArray(double[] values, double normalizedSum) throws MathIllegalArgumentException, MathArithmeticException {
        int i;
        if (Double.isInfinite(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double sum = 0.0;
        int len = values.length;
        double[] out = new double[len];
        for (i = 0; i < len; ++i) {
            if (Double.isInfinite(values[i])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, values[i], i);
            }
            if (Double.isNaN(values[i])) continue;
            sum += values[i];
        }
        if (sum == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (i = 0; i < len; ++i) {
            out[i] = Double.isNaN(values[i]) ? Double.NaN : values[i] * normalizedSum / sum;
        }
        return out;
    }

    public static <T> T[] buildArray(Field<T> field, int length) {
        Object[] array = (Object[])Array.newInstance(field.getRuntimeClass(), length);
        Arrays.fill(array, field.getZero());
        return array;
    }

    public static <T> T[][] buildArray(Field<T> field, int rows, int columns) {
        Object[][] array;
        if (columns < 0) {
            T[] dummyRow = MathArrays.buildArray(field, 0);
            array = (Object[][])Array.newInstance(dummyRow.getClass(), rows);
        } else {
            array = (Object[][])Array.newInstance(field.getRuntimeClass(), rows, columns);
            for (int i = 0; i < rows; ++i) {
                Arrays.fill(array[i], field.getZero());
            }
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

