/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntity;
import mcp.mobius.opis.data.holders.newtypes.DataEntity;
import mcp.mobius.opis.data.holders.stats.StatsChunk;
import mcp.mobius.opis.data.profilers.ProfilerEntityUpdate;
import mcp.mobius.opis.data.profilers.ProfilerTileEntityUpdate;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public enum ChunkManager implements IMessageHandler
{
    INSTANCE;

    private ArrayList<CoordinatesChunk> chunksLoad = new ArrayList();
    private HashMap<CoordinatesChunk, StatsChunk> chunkMeanTime = new HashMap();

    public synchronized void addLoadedChunks(ArrayList<ISerializable> data) {
        for (ISerializable chunk : data) {
            this.chunksLoad.add((CoordinatesChunk)chunk);
        }
    }

    public synchronized void setChunkMeanTime(ArrayList<ISerializable> data) {
        this.chunkMeanTime.clear();
        for (ISerializable stat : data) {
            this.chunkMeanTime.put(((StatsChunk)stat).getChunk(), (StatsChunk)stat);
        }
    }

    public synchronized ArrayList<CoordinatesChunk> getLoadedChunks(int dimension) {
        HashSet<CoordinatesChunk> chunkStatus = new HashSet<CoordinatesChunk>();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world != null) {
            for (ChunkCoordIntPair coord : world.getPersistentChunks().keySet()) {
                chunkStatus.add(new CoordinatesChunk(dimension, coord, 1));
            }
            for (Object o : ((ChunkProviderServer)world.func_72863_F()).field_73245_g) {
                Chunk chunk = (Chunk)o;
                chunkStatus.add(new CoordinatesChunk(dimension, chunk.func_76632_l(), 0));
            }
        }
        return new ArrayList<CoordinatesChunk>(chunkStatus);
    }

    public synchronized ArrayList<StatsChunk> getChunksUpdateTime() {
        CoordinatesChunk chunk;
        Comparable<DataBlockTileEntity> data;
        HashMap<CoordinatesChunk, StatsChunk> chunks = new HashMap<CoordinatesChunk, StatsChunk>();
        for (CoordinatesBlock coords : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            data = new DataBlockTileEntity().fill(coords);
            chunk = data.pos.asCoordinatesChunk();
            if (!chunks.containsKey(chunk)) {
                chunks.put(chunk, new StatsChunk(chunk));
            }
            ((StatsChunk)chunks.get(chunk)).addTileEntity();
            ((StatsChunk)chunks.get(chunk)).addMeasure(data.update.timing);
        }
        for (Entity entity : ((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.keySet()) {
            data = new DataEntity().fill(entity);
            chunk = ((DataEntity)data).pos.asCoordinatesChunk();
            if (!chunks.containsKey(chunk)) {
                chunks.put(chunk, new StatsChunk(chunk));
            }
            ((StatsChunk)chunks.get(chunk)).addEntity();
            ((StatsChunk)chunks.get(chunk)).addMeasure(((DataEntity)data).update.timing);
        }
        return new ArrayList<StatsChunk>(chunks.values());
    }

    public ArrayList<StatsChunk> getTopChunks(int quantity) {
        ArrayList<StatsChunk> chunks = this.getChunksUpdateTime();
        ArrayList<StatsChunk> outList = new ArrayList<StatsChunk>(quantity);
        Collections.sort(chunks);
        for (int i = 0; i < Math.min(quantity, chunks.size()); ++i) {
            outList.add(chunks.get(i));
        }
        return outList;
    }

    public int getLoadedChunkAmount() {
        int loadedChunks = 0;
        for (WorldServer world : DimensionManager.getWorlds()) {
            int loadedChunksForDim = world.func_72863_F().func_73152_e();
            loadedChunks += loadedChunksForDim;
        }
        return loadedChunks;
    }

    public int getForcedChunkAmount() {
        int forcedChunks = 0;
        for (WorldServer world : DimensionManager.getWorlds()) {
            forcedChunks += world.getPersistentChunks().size();
        }
        return forcedChunks;
    }

    public void purgeChunks(int dim) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return;
        }
        int loadedChunksDelta = 100;
        ((ChunkProviderServer)world.func_72863_F()).func_73240_a();
        while (loadedChunksDelta >= 100) {
            int loadedBefore = world.func_72863_F().func_73152_e();
            world.func_72863_F().func_73156_b();
            loadedChunksDelta = loadedBefore - world.func_72863_F().func_73152_e();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_CHUNK: {
                this.setChunkMeanTime(rawdata.array);
                break;
            }
            case LIST_CHUNK_LOADED: {
                this.addLoadedChunks(rawdata.array);
                break;
            }
            case LIST_CHUNK_LOADED_CLEAR: {
                ChunkManager chunkManager = this;
                synchronized (chunkManager) {
                    this.chunksLoad.clear();
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

