/*
 * Decompiled with CFR 0.152.
 */
package api.undercurrent.iface.editorTypes;

import api.undercurrent.iface.editorTypes.EditorType;

public class StringEditorType
extends EditorType {
    private int minLength;
    private int maxLength;

    public StringEditorType(String fieldName, String fieldValue, String displayName, String displayDescription, int minLength, int maxLength) {
        super(EditorType.EditorTypes.STRING);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.displayDescription = displayDescription;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getFieldValue() {
        return (String)this.fieldValue;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean validateValue(Object obj) throws Exception {
        try {
            String objcast = String.valueOf(obj);
            if (objcast.length() > this.getMaxLength()) {
                return false;
            }
            return objcast.length() >= this.getMinLength();
        }
        catch (Exception e) {
            return false;
        }
    }
}

