/*
 * Decompiled with CFR 0.152.
 */
package api.undercurrent.iface.editorTypes;

import api.undercurrent.iface.editorTypes.EditorType;

public class DoubleEditorType
extends EditorType {
    private int fieldPrecision;
    private double maxValue;
    private double minValue;

    public DoubleEditorType(String fieldName, double fieldValue, String displayName, String displayDescription, int fieldPrecision, double maxValue, double minValue) throws Exception {
        super(EditorType.EditorTypes.DOUBLE);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.displayDescription = displayDescription;
        this.fieldPrecision = fieldPrecision;
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object getFieldValue() {
        return (Double)this.fieldValue;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public int getFieldPrecision() {
        return this.fieldPrecision;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public boolean validateValue(Object obj) throws Exception {
        try {
            double objcast = Double.valueOf(String.valueOf(obj));
            if (objcast > this.getMaxValue()) {
                return false;
            }
            return !(objcast < this.getMinValue());
        }
        catch (Exception e) {
            return false;
        }
    }
}

